//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_41_sb_w            = 8;
  parameter vitAcs_41_pmIn0_w         = 9;
  parameter vitAcs_41_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_41_sel_w           = 1;
  parameter vitAcs_41_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_41_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_41_i0              = 1;
  parameter vitAcs_41_i1              = 0;
  parameter vitAcs_41_pbrv            = 412;
  parameter vitAcs_41_ws              = 4;
  parameter vitAcs_41_wp              = 9;

  // Iregs
  parameter vitAcs_41_pmBuf_w         = 9;
  parameter vitAcs_41_pmBuf_n         = 1;
  parameter vitAcs_41_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_41.sb_w            = vitAcs_41_sb_w;
  defparam vitAcs_41.pmIn0_w         = vitAcs_41_pmIn0_w;
  defparam vitAcs_41.pmIn1_w         = vitAcs_41_pmIn1_w;
  defparam vitAcs_41.sel_w           = vitAcs_41_sel_w;
  defparam vitAcs_41.pmOut_w         = vitAcs_41_pmOut_w;
  defparam vitAcs_41.run1_w          = vitAcs_41_run1_w;
  defparam vitAcs_41.i0              = vitAcs_41_i0;
  defparam vitAcs_41.i1              = vitAcs_41_i1;
  defparam vitAcs_41.pbrv            = vitAcs_41_pbrv;
  defparam vitAcs_41.ws              = vitAcs_41_ws;
  defparam vitAcs_41.wp              = vitAcs_41_wp;
  defparam vitAcs_41.pmBuf_w         = vitAcs_41_pmBuf_w;
  defparam vitAcs_41.pmBuf_n         = vitAcs_41_pmBuf_n;
  defparam vitAcs_41.pmBuf_m         = vitAcs_41_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_41_sel_w-1:0]  vitAcs_41_sel;
  wire                                      vitAcs_41_sel_or;
  wire                                      vitAcs_41_sel_ff;
  wire                                      vitAcs_41_sel_we;

  wire             [vitAcs_41_pmOut_w-1:0]  vitAcs_41_pmOut;
  wire                                      vitAcs_41_pmOut_or;
  wire                                      vitAcs_41_pmOut_ff;
  wire                                      vitAcs_41_pmOut_we;

  wire                [vitAcs_41_sb_w-1:0]  vitAcs_41_sb;
  wire                                      vitAcs_41_sb_ir;
  wire                                      vitAcs_41_sb_fe;
  wire                                      vitAcs_41_sb_re;

  wire             [vitAcs_41_pmIn0_w-1:0]  vitAcs_41_pmIn0;
  wire                                      vitAcs_41_pmIn0_ir;
  wire                                      vitAcs_41_pmIn0_fe;
  wire                                      vitAcs_41_pmIn0_re;

  wire             [vitAcs_41_pmIn1_w-1:0]  vitAcs_41_pmIn1;
  wire                                      vitAcs_41_pmIn1_ir;
  wire                                      vitAcs_41_pmIn1_fe;
  wire                                      vitAcs_41_pmIn1_re;

  wire              [vitAcs_41_run1_w-1:0]  vitAcs_41_run1;

  wire                                      vitAcs_41_regWe;
  wire                                      vitAcs_41_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_41(vitAcs_41_sel, vitAcs_41_sel_or, vitAcs_41_sel_ff, vitAcs_41_sel_we,
                   vitAcs_41_pmOut, vitAcs_41_pmOut_or, vitAcs_41_pmOut_ff, vitAcs_41_pmOut_we,
                   vitAcs_41_sb, vitAcs_41_sb_ir, vitAcs_41_sb_fe, vitAcs_41_sb_re, 
                   vitAcs_41_pmIn0, vitAcs_41_pmIn0_ir, vitAcs_41_pmIn0_fe, vitAcs_41_pmIn0_re, 
                   vitAcs_41_pmIn1, vitAcs_41_pmIn1_ir, vitAcs_41_pmIn1_fe, vitAcs_41_pmIn1_re, 
                   vitAcs_41_run1, 
                   regBus, regWe, regRe, vitAcs_41_regWe, vitAcs_41_regRe, clk, clk2, reset);


//==============================================================================
