//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_39_sb_w            = 8;
  parameter vitAcs_39_pmIn0_w         = 9;
  parameter vitAcs_39_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_39_sel_w           = 1;
  parameter vitAcs_39_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_39_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_39_i0              = 1;
  parameter vitAcs_39_i1              = 1;
  parameter vitAcs_39_pbrv            = 412;
  parameter vitAcs_39_ws              = 4;
  parameter vitAcs_39_wp              = 9;

  // Iregs
  parameter vitAcs_39_pmBuf_w         = 9;
  parameter vitAcs_39_pmBuf_n         = 1;
  parameter vitAcs_39_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_39.sb_w            = vitAcs_39_sb_w;
  defparam vitAcs_39.pmIn0_w         = vitAcs_39_pmIn0_w;
  defparam vitAcs_39.pmIn1_w         = vitAcs_39_pmIn1_w;
  defparam vitAcs_39.sel_w           = vitAcs_39_sel_w;
  defparam vitAcs_39.pmOut_w         = vitAcs_39_pmOut_w;
  defparam vitAcs_39.run1_w          = vitAcs_39_run1_w;
  defparam vitAcs_39.i0              = vitAcs_39_i0;
  defparam vitAcs_39.i1              = vitAcs_39_i1;
  defparam vitAcs_39.pbrv            = vitAcs_39_pbrv;
  defparam vitAcs_39.ws              = vitAcs_39_ws;
  defparam vitAcs_39.wp              = vitAcs_39_wp;
  defparam vitAcs_39.pmBuf_w         = vitAcs_39_pmBuf_w;
  defparam vitAcs_39.pmBuf_n         = vitAcs_39_pmBuf_n;
  defparam vitAcs_39.pmBuf_m         = vitAcs_39_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_39_sel_w-1:0]  vitAcs_39_sel;
  wire                                      vitAcs_39_sel_or;
  wire                                      vitAcs_39_sel_ff;
  wire                                      vitAcs_39_sel_we;

  wire             [vitAcs_39_pmOut_w-1:0]  vitAcs_39_pmOut;
  wire                                      vitAcs_39_pmOut_or;
  wire                                      vitAcs_39_pmOut_ff;
  wire                                      vitAcs_39_pmOut_we;

  wire                [vitAcs_39_sb_w-1:0]  vitAcs_39_sb;
  wire                                      vitAcs_39_sb_ir;
  wire                                      vitAcs_39_sb_fe;
  wire                                      vitAcs_39_sb_re;

  wire             [vitAcs_39_pmIn0_w-1:0]  vitAcs_39_pmIn0;
  wire                                      vitAcs_39_pmIn0_ir;
  wire                                      vitAcs_39_pmIn0_fe;
  wire                                      vitAcs_39_pmIn0_re;

  wire             [vitAcs_39_pmIn1_w-1:0]  vitAcs_39_pmIn1;
  wire                                      vitAcs_39_pmIn1_ir;
  wire                                      vitAcs_39_pmIn1_fe;
  wire                                      vitAcs_39_pmIn1_re;

  wire              [vitAcs_39_run1_w-1:0]  vitAcs_39_run1;

  wire                                      vitAcs_39_regWe;
  wire                                      vitAcs_39_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_39(vitAcs_39_sel, vitAcs_39_sel_or, vitAcs_39_sel_ff, vitAcs_39_sel_we,
                   vitAcs_39_pmOut, vitAcs_39_pmOut_or, vitAcs_39_pmOut_ff, vitAcs_39_pmOut_we,
                   vitAcs_39_sb, vitAcs_39_sb_ir, vitAcs_39_sb_fe, vitAcs_39_sb_re, 
                   vitAcs_39_pmIn0, vitAcs_39_pmIn0_ir, vitAcs_39_pmIn0_fe, vitAcs_39_pmIn0_re, 
                   vitAcs_39_pmIn1, vitAcs_39_pmIn1_ir, vitAcs_39_pmIn1_fe, vitAcs_39_pmIn1_re, 
                   vitAcs_39_run1, 
                   regBus, regWe, regRe, vitAcs_39_regWe, vitAcs_39_regRe, clk, clk2, reset);


//==============================================================================
