//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_38_sb_w            = 8;
  parameter vitAcs_38_pmIn0_w         = 9;
  parameter vitAcs_38_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_38_sel_w           = 1;
  parameter vitAcs_38_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_38_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_38_i0              = 0;
  parameter vitAcs_38_i1              = 0;
  parameter vitAcs_38_pbrv            = 412;
  parameter vitAcs_38_ws              = 4;
  parameter vitAcs_38_wp              = 9;

  // Iregs
  parameter vitAcs_38_pmBuf_w         = 9;
  parameter vitAcs_38_pmBuf_n         = 1;
  parameter vitAcs_38_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_38.sb_w            = vitAcs_38_sb_w;
  defparam vitAcs_38.pmIn0_w         = vitAcs_38_pmIn0_w;
  defparam vitAcs_38.pmIn1_w         = vitAcs_38_pmIn1_w;
  defparam vitAcs_38.sel_w           = vitAcs_38_sel_w;
  defparam vitAcs_38.pmOut_w         = vitAcs_38_pmOut_w;
  defparam vitAcs_38.run1_w          = vitAcs_38_run1_w;
  defparam vitAcs_38.i0              = vitAcs_38_i0;
  defparam vitAcs_38.i1              = vitAcs_38_i1;
  defparam vitAcs_38.pbrv            = vitAcs_38_pbrv;
  defparam vitAcs_38.ws              = vitAcs_38_ws;
  defparam vitAcs_38.wp              = vitAcs_38_wp;
  defparam vitAcs_38.pmBuf_w         = vitAcs_38_pmBuf_w;
  defparam vitAcs_38.pmBuf_n         = vitAcs_38_pmBuf_n;
  defparam vitAcs_38.pmBuf_m         = vitAcs_38_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_38_sel_w-1:0]  vitAcs_38_sel;
  wire                                      vitAcs_38_sel_or;
  wire                                      vitAcs_38_sel_ff;
  wire                                      vitAcs_38_sel_we;

  wire             [vitAcs_38_pmOut_w-1:0]  vitAcs_38_pmOut;
  wire                                      vitAcs_38_pmOut_or;
  wire                                      vitAcs_38_pmOut_ff;
  wire                                      vitAcs_38_pmOut_we;

  wire                [vitAcs_38_sb_w-1:0]  vitAcs_38_sb;
  wire                                      vitAcs_38_sb_ir;
  wire                                      vitAcs_38_sb_fe;
  wire                                      vitAcs_38_sb_re;

  wire             [vitAcs_38_pmIn0_w-1:0]  vitAcs_38_pmIn0;
  wire                                      vitAcs_38_pmIn0_ir;
  wire                                      vitAcs_38_pmIn0_fe;
  wire                                      vitAcs_38_pmIn0_re;

  wire             [vitAcs_38_pmIn1_w-1:0]  vitAcs_38_pmIn1;
  wire                                      vitAcs_38_pmIn1_ir;
  wire                                      vitAcs_38_pmIn1_fe;
  wire                                      vitAcs_38_pmIn1_re;

  wire              [vitAcs_38_run1_w-1:0]  vitAcs_38_run1;

  wire                                      vitAcs_38_regWe;
  wire                                      vitAcs_38_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_38(vitAcs_38_sel, vitAcs_38_sel_or, vitAcs_38_sel_ff, vitAcs_38_sel_we,
                   vitAcs_38_pmOut, vitAcs_38_pmOut_or, vitAcs_38_pmOut_ff, vitAcs_38_pmOut_we,
                   vitAcs_38_sb, vitAcs_38_sb_ir, vitAcs_38_sb_fe, vitAcs_38_sb_re, 
                   vitAcs_38_pmIn0, vitAcs_38_pmIn0_ir, vitAcs_38_pmIn0_fe, vitAcs_38_pmIn0_re, 
                   vitAcs_38_pmIn1, vitAcs_38_pmIn1_ir, vitAcs_38_pmIn1_fe, vitAcs_38_pmIn1_re, 
                   vitAcs_38_run1, 
                   regBus, regWe, regRe, vitAcs_38_regWe, vitAcs_38_regRe, clk, clk2, reset);


//==============================================================================
