//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_37_sb_w            = 8;
  parameter vitAcs_37_pmIn0_w         = 9;
  parameter vitAcs_37_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_37_sel_w           = 1;
  parameter vitAcs_37_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_37_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_37_i0              = 1;
  parameter vitAcs_37_i1              = 0;
  parameter vitAcs_37_pbrv            = 412;
  parameter vitAcs_37_ws              = 4;
  parameter vitAcs_37_wp              = 9;

  // Iregs
  parameter vitAcs_37_pmBuf_w         = 9;
  parameter vitAcs_37_pmBuf_n         = 1;
  parameter vitAcs_37_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_37.sb_w            = vitAcs_37_sb_w;
  defparam vitAcs_37.pmIn0_w         = vitAcs_37_pmIn0_w;
  defparam vitAcs_37.pmIn1_w         = vitAcs_37_pmIn1_w;
  defparam vitAcs_37.sel_w           = vitAcs_37_sel_w;
  defparam vitAcs_37.pmOut_w         = vitAcs_37_pmOut_w;
  defparam vitAcs_37.run1_w          = vitAcs_37_run1_w;
  defparam vitAcs_37.i0              = vitAcs_37_i0;
  defparam vitAcs_37.i1              = vitAcs_37_i1;
  defparam vitAcs_37.pbrv            = vitAcs_37_pbrv;
  defparam vitAcs_37.ws              = vitAcs_37_ws;
  defparam vitAcs_37.wp              = vitAcs_37_wp;
  defparam vitAcs_37.pmBuf_w         = vitAcs_37_pmBuf_w;
  defparam vitAcs_37.pmBuf_n         = vitAcs_37_pmBuf_n;
  defparam vitAcs_37.pmBuf_m         = vitAcs_37_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_37_sel_w-1:0]  vitAcs_37_sel;
  wire                                      vitAcs_37_sel_or;
  wire                                      vitAcs_37_sel_ff;
  wire                                      vitAcs_37_sel_we;

  wire             [vitAcs_37_pmOut_w-1:0]  vitAcs_37_pmOut;
  wire                                      vitAcs_37_pmOut_or;
  wire                                      vitAcs_37_pmOut_ff;
  wire                                      vitAcs_37_pmOut_we;

  wire                [vitAcs_37_sb_w-1:0]  vitAcs_37_sb;
  wire                                      vitAcs_37_sb_ir;
  wire                                      vitAcs_37_sb_fe;
  wire                                      vitAcs_37_sb_re;

  wire             [vitAcs_37_pmIn0_w-1:0]  vitAcs_37_pmIn0;
  wire                                      vitAcs_37_pmIn0_ir;
  wire                                      vitAcs_37_pmIn0_fe;
  wire                                      vitAcs_37_pmIn0_re;

  wire             [vitAcs_37_pmIn1_w-1:0]  vitAcs_37_pmIn1;
  wire                                      vitAcs_37_pmIn1_ir;
  wire                                      vitAcs_37_pmIn1_fe;
  wire                                      vitAcs_37_pmIn1_re;

  wire              [vitAcs_37_run1_w-1:0]  vitAcs_37_run1;

  wire                                      vitAcs_37_regWe;
  wire                                      vitAcs_37_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_37(vitAcs_37_sel, vitAcs_37_sel_or, vitAcs_37_sel_ff, vitAcs_37_sel_we,
                   vitAcs_37_pmOut, vitAcs_37_pmOut_or, vitAcs_37_pmOut_ff, vitAcs_37_pmOut_we,
                   vitAcs_37_sb, vitAcs_37_sb_ir, vitAcs_37_sb_fe, vitAcs_37_sb_re, 
                   vitAcs_37_pmIn0, vitAcs_37_pmIn0_ir, vitAcs_37_pmIn0_fe, vitAcs_37_pmIn0_re, 
                   vitAcs_37_pmIn1, vitAcs_37_pmIn1_ir, vitAcs_37_pmIn1_fe, vitAcs_37_pmIn1_re, 
                   vitAcs_37_run1, 
                   regBus, regWe, regRe, vitAcs_37_regWe, vitAcs_37_regRe, clk, clk2, reset);


//==============================================================================
