//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_36_sb_w            = 8;
  parameter vitAcs_36_pmIn0_w         = 9;
  parameter vitAcs_36_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_36_sel_w           = 1;
  parameter vitAcs_36_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_36_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_36_i0              = 0;
  parameter vitAcs_36_i1              = 1;
  parameter vitAcs_36_pbrv            = 412;
  parameter vitAcs_36_ws              = 4;
  parameter vitAcs_36_wp              = 9;

  // Iregs
  parameter vitAcs_36_pmBuf_w         = 9;
  parameter vitAcs_36_pmBuf_n         = 1;
  parameter vitAcs_36_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_36.sb_w            = vitAcs_36_sb_w;
  defparam vitAcs_36.pmIn0_w         = vitAcs_36_pmIn0_w;
  defparam vitAcs_36.pmIn1_w         = vitAcs_36_pmIn1_w;
  defparam vitAcs_36.sel_w           = vitAcs_36_sel_w;
  defparam vitAcs_36.pmOut_w         = vitAcs_36_pmOut_w;
  defparam vitAcs_36.run1_w          = vitAcs_36_run1_w;
  defparam vitAcs_36.i0              = vitAcs_36_i0;
  defparam vitAcs_36.i1              = vitAcs_36_i1;
  defparam vitAcs_36.pbrv            = vitAcs_36_pbrv;
  defparam vitAcs_36.ws              = vitAcs_36_ws;
  defparam vitAcs_36.wp              = vitAcs_36_wp;
  defparam vitAcs_36.pmBuf_w         = vitAcs_36_pmBuf_w;
  defparam vitAcs_36.pmBuf_n         = vitAcs_36_pmBuf_n;
  defparam vitAcs_36.pmBuf_m         = vitAcs_36_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_36_sel_w-1:0]  vitAcs_36_sel;
  wire                                      vitAcs_36_sel_or;
  wire                                      vitAcs_36_sel_ff;
  wire                                      vitAcs_36_sel_we;

  wire             [vitAcs_36_pmOut_w-1:0]  vitAcs_36_pmOut;
  wire                                      vitAcs_36_pmOut_or;
  wire                                      vitAcs_36_pmOut_ff;
  wire                                      vitAcs_36_pmOut_we;

  wire                [vitAcs_36_sb_w-1:0]  vitAcs_36_sb;
  wire                                      vitAcs_36_sb_ir;
  wire                                      vitAcs_36_sb_fe;
  wire                                      vitAcs_36_sb_re;

  wire             [vitAcs_36_pmIn0_w-1:0]  vitAcs_36_pmIn0;
  wire                                      vitAcs_36_pmIn0_ir;
  wire                                      vitAcs_36_pmIn0_fe;
  wire                                      vitAcs_36_pmIn0_re;

  wire             [vitAcs_36_pmIn1_w-1:0]  vitAcs_36_pmIn1;
  wire                                      vitAcs_36_pmIn1_ir;
  wire                                      vitAcs_36_pmIn1_fe;
  wire                                      vitAcs_36_pmIn1_re;

  wire              [vitAcs_36_run1_w-1:0]  vitAcs_36_run1;

  wire                                      vitAcs_36_regWe;
  wire                                      vitAcs_36_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_36(vitAcs_36_sel, vitAcs_36_sel_or, vitAcs_36_sel_ff, vitAcs_36_sel_we,
                   vitAcs_36_pmOut, vitAcs_36_pmOut_or, vitAcs_36_pmOut_ff, vitAcs_36_pmOut_we,
                   vitAcs_36_sb, vitAcs_36_sb_ir, vitAcs_36_sb_fe, vitAcs_36_sb_re, 
                   vitAcs_36_pmIn0, vitAcs_36_pmIn0_ir, vitAcs_36_pmIn0_fe, vitAcs_36_pmIn0_re, 
                   vitAcs_36_pmIn1, vitAcs_36_pmIn1_ir, vitAcs_36_pmIn1_fe, vitAcs_36_pmIn1_re, 
                   vitAcs_36_run1, 
                   regBus, regWe, regRe, vitAcs_36_regWe, vitAcs_36_regRe, clk, clk2, reset);


//==============================================================================
