//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_34_sb_w            = 8;
  parameter vitAcs_34_pmIn0_w         = 9;
  parameter vitAcs_34_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_34_sel_w           = 1;
  parameter vitAcs_34_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_34_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_34_i0              = 1;
  parameter vitAcs_34_i1              = 1;
  parameter vitAcs_34_pbrv            = 412;
  parameter vitAcs_34_ws              = 4;
  parameter vitAcs_34_wp              = 9;

  // Iregs
  parameter vitAcs_34_pmBuf_w         = 9;
  parameter vitAcs_34_pmBuf_n         = 1;
  parameter vitAcs_34_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_34.sb_w            = vitAcs_34_sb_w;
  defparam vitAcs_34.pmIn0_w         = vitAcs_34_pmIn0_w;
  defparam vitAcs_34.pmIn1_w         = vitAcs_34_pmIn1_w;
  defparam vitAcs_34.sel_w           = vitAcs_34_sel_w;
  defparam vitAcs_34.pmOut_w         = vitAcs_34_pmOut_w;
  defparam vitAcs_34.run1_w          = vitAcs_34_run1_w;
  defparam vitAcs_34.i0              = vitAcs_34_i0;
  defparam vitAcs_34.i1              = vitAcs_34_i1;
  defparam vitAcs_34.pbrv            = vitAcs_34_pbrv;
  defparam vitAcs_34.ws              = vitAcs_34_ws;
  defparam vitAcs_34.wp              = vitAcs_34_wp;
  defparam vitAcs_34.pmBuf_w         = vitAcs_34_pmBuf_w;
  defparam vitAcs_34.pmBuf_n         = vitAcs_34_pmBuf_n;
  defparam vitAcs_34.pmBuf_m         = vitAcs_34_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_34_sel_w-1:0]  vitAcs_34_sel;
  wire                                      vitAcs_34_sel_or;
  wire                                      vitAcs_34_sel_ff;
  wire                                      vitAcs_34_sel_we;

  wire             [vitAcs_34_pmOut_w-1:0]  vitAcs_34_pmOut;
  wire                                      vitAcs_34_pmOut_or;
  wire                                      vitAcs_34_pmOut_ff;
  wire                                      vitAcs_34_pmOut_we;

  wire                [vitAcs_34_sb_w-1:0]  vitAcs_34_sb;
  wire                                      vitAcs_34_sb_ir;
  wire                                      vitAcs_34_sb_fe;
  wire                                      vitAcs_34_sb_re;

  wire             [vitAcs_34_pmIn0_w-1:0]  vitAcs_34_pmIn0;
  wire                                      vitAcs_34_pmIn0_ir;
  wire                                      vitAcs_34_pmIn0_fe;
  wire                                      vitAcs_34_pmIn0_re;

  wire             [vitAcs_34_pmIn1_w-1:0]  vitAcs_34_pmIn1;
  wire                                      vitAcs_34_pmIn1_ir;
  wire                                      vitAcs_34_pmIn1_fe;
  wire                                      vitAcs_34_pmIn1_re;

  wire              [vitAcs_34_run1_w-1:0]  vitAcs_34_run1;

  wire                                      vitAcs_34_regWe;
  wire                                      vitAcs_34_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_34(vitAcs_34_sel, vitAcs_34_sel_or, vitAcs_34_sel_ff, vitAcs_34_sel_we,
                   vitAcs_34_pmOut, vitAcs_34_pmOut_or, vitAcs_34_pmOut_ff, vitAcs_34_pmOut_we,
                   vitAcs_34_sb, vitAcs_34_sb_ir, vitAcs_34_sb_fe, vitAcs_34_sb_re, 
                   vitAcs_34_pmIn0, vitAcs_34_pmIn0_ir, vitAcs_34_pmIn0_fe, vitAcs_34_pmIn0_re, 
                   vitAcs_34_pmIn1, vitAcs_34_pmIn1_ir, vitAcs_34_pmIn1_fe, vitAcs_34_pmIn1_re, 
                   vitAcs_34_run1, 
                   regBus, regWe, regRe, vitAcs_34_regWe, vitAcs_34_regRe, clk, clk2, reset);


//==============================================================================
