//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_32_sb_w            = 8;
  parameter vitAcs_32_pmIn0_w         = 9;
  parameter vitAcs_32_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_32_sel_w           = 1;
  parameter vitAcs_32_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_32_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_32_i0              = 1;
  parameter vitAcs_32_i1              = 0;
  parameter vitAcs_32_pbrv            = 412;
  parameter vitAcs_32_ws              = 4;
  parameter vitAcs_32_wp              = 9;

  // Iregs
  parameter vitAcs_32_pmBuf_w         = 9;
  parameter vitAcs_32_pmBuf_n         = 1;
  parameter vitAcs_32_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_32.sb_w            = vitAcs_32_sb_w;
  defparam vitAcs_32.pmIn0_w         = vitAcs_32_pmIn0_w;
  defparam vitAcs_32.pmIn1_w         = vitAcs_32_pmIn1_w;
  defparam vitAcs_32.sel_w           = vitAcs_32_sel_w;
  defparam vitAcs_32.pmOut_w         = vitAcs_32_pmOut_w;
  defparam vitAcs_32.run1_w          = vitAcs_32_run1_w;
  defparam vitAcs_32.i0              = vitAcs_32_i0;
  defparam vitAcs_32.i1              = vitAcs_32_i1;
  defparam vitAcs_32.pbrv            = vitAcs_32_pbrv;
  defparam vitAcs_32.ws              = vitAcs_32_ws;
  defparam vitAcs_32.wp              = vitAcs_32_wp;
  defparam vitAcs_32.pmBuf_w         = vitAcs_32_pmBuf_w;
  defparam vitAcs_32.pmBuf_n         = vitAcs_32_pmBuf_n;
  defparam vitAcs_32.pmBuf_m         = vitAcs_32_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_32_sel_w-1:0]  vitAcs_32_sel;
  wire                                      vitAcs_32_sel_or;
  wire                                      vitAcs_32_sel_ff;
  wire                                      vitAcs_32_sel_we;

  wire             [vitAcs_32_pmOut_w-1:0]  vitAcs_32_pmOut;
  wire                                      vitAcs_32_pmOut_or;
  wire                                      vitAcs_32_pmOut_ff;
  wire                                      vitAcs_32_pmOut_we;

  wire                [vitAcs_32_sb_w-1:0]  vitAcs_32_sb;
  wire                                      vitAcs_32_sb_ir;
  wire                                      vitAcs_32_sb_fe;
  wire                                      vitAcs_32_sb_re;

  wire             [vitAcs_32_pmIn0_w-1:0]  vitAcs_32_pmIn0;
  wire                                      vitAcs_32_pmIn0_ir;
  wire                                      vitAcs_32_pmIn0_fe;
  wire                                      vitAcs_32_pmIn0_re;

  wire             [vitAcs_32_pmIn1_w-1:0]  vitAcs_32_pmIn1;
  wire                                      vitAcs_32_pmIn1_ir;
  wire                                      vitAcs_32_pmIn1_fe;
  wire                                      vitAcs_32_pmIn1_re;

  wire              [vitAcs_32_run1_w-1:0]  vitAcs_32_run1;

  wire                                      vitAcs_32_regWe;
  wire                                      vitAcs_32_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_32(vitAcs_32_sel, vitAcs_32_sel_or, vitAcs_32_sel_ff, vitAcs_32_sel_we,
                   vitAcs_32_pmOut, vitAcs_32_pmOut_or, vitAcs_32_pmOut_ff, vitAcs_32_pmOut_we,
                   vitAcs_32_sb, vitAcs_32_sb_ir, vitAcs_32_sb_fe, vitAcs_32_sb_re, 
                   vitAcs_32_pmIn0, vitAcs_32_pmIn0_ir, vitAcs_32_pmIn0_fe, vitAcs_32_pmIn0_re, 
                   vitAcs_32_pmIn1, vitAcs_32_pmIn1_ir, vitAcs_32_pmIn1_fe, vitAcs_32_pmIn1_re, 
                   vitAcs_32_run1, 
                   regBus, regWe, regRe, vitAcs_32_regWe, vitAcs_32_regRe, clk, clk2, reset);


//==============================================================================
