//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_31_sb_w            = 8;
  parameter vitAcs_31_pmIn0_w         = 9;
  parameter vitAcs_31_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_31_sel_w           = 1;
  parameter vitAcs_31_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_31_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_31_i0              = 1;
  parameter vitAcs_31_i1              = 0;
  parameter vitAcs_31_pbrv            = 412;
  parameter vitAcs_31_ws              = 4;
  parameter vitAcs_31_wp              = 9;

  // Iregs
  parameter vitAcs_31_pmBuf_w         = 9;
  parameter vitAcs_31_pmBuf_n         = 1;
  parameter vitAcs_31_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_31.sb_w            = vitAcs_31_sb_w;
  defparam vitAcs_31.pmIn0_w         = vitAcs_31_pmIn0_w;
  defparam vitAcs_31.pmIn1_w         = vitAcs_31_pmIn1_w;
  defparam vitAcs_31.sel_w           = vitAcs_31_sel_w;
  defparam vitAcs_31.pmOut_w         = vitAcs_31_pmOut_w;
  defparam vitAcs_31.run1_w          = vitAcs_31_run1_w;
  defparam vitAcs_31.i0              = vitAcs_31_i0;
  defparam vitAcs_31.i1              = vitAcs_31_i1;
  defparam vitAcs_31.pbrv            = vitAcs_31_pbrv;
  defparam vitAcs_31.ws              = vitAcs_31_ws;
  defparam vitAcs_31.wp              = vitAcs_31_wp;
  defparam vitAcs_31.pmBuf_w         = vitAcs_31_pmBuf_w;
  defparam vitAcs_31.pmBuf_n         = vitAcs_31_pmBuf_n;
  defparam vitAcs_31.pmBuf_m         = vitAcs_31_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_31_sel_w-1:0]  vitAcs_31_sel;
  wire                                      vitAcs_31_sel_or;
  wire                                      vitAcs_31_sel_ff;
  wire                                      vitAcs_31_sel_we;

  wire             [vitAcs_31_pmOut_w-1:0]  vitAcs_31_pmOut;
  wire                                      vitAcs_31_pmOut_or;
  wire                                      vitAcs_31_pmOut_ff;
  wire                                      vitAcs_31_pmOut_we;

  wire                [vitAcs_31_sb_w-1:0]  vitAcs_31_sb;
  wire                                      vitAcs_31_sb_ir;
  wire                                      vitAcs_31_sb_fe;
  wire                                      vitAcs_31_sb_re;

  wire             [vitAcs_31_pmIn0_w-1:0]  vitAcs_31_pmIn0;
  wire                                      vitAcs_31_pmIn0_ir;
  wire                                      vitAcs_31_pmIn0_fe;
  wire                                      vitAcs_31_pmIn0_re;

  wire             [vitAcs_31_pmIn1_w-1:0]  vitAcs_31_pmIn1;
  wire                                      vitAcs_31_pmIn1_ir;
  wire                                      vitAcs_31_pmIn1_fe;
  wire                                      vitAcs_31_pmIn1_re;

  wire              [vitAcs_31_run1_w-1:0]  vitAcs_31_run1;

  wire                                      vitAcs_31_regWe;
  wire                                      vitAcs_31_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_31(vitAcs_31_sel, vitAcs_31_sel_or, vitAcs_31_sel_ff, vitAcs_31_sel_we,
                   vitAcs_31_pmOut, vitAcs_31_pmOut_or, vitAcs_31_pmOut_ff, vitAcs_31_pmOut_we,
                   vitAcs_31_sb, vitAcs_31_sb_ir, vitAcs_31_sb_fe, vitAcs_31_sb_re, 
                   vitAcs_31_pmIn0, vitAcs_31_pmIn0_ir, vitAcs_31_pmIn0_fe, vitAcs_31_pmIn0_re, 
                   vitAcs_31_pmIn1, vitAcs_31_pmIn1_ir, vitAcs_31_pmIn1_fe, vitAcs_31_pmIn1_re, 
                   vitAcs_31_run1, 
                   regBus, regWe, regRe, vitAcs_31_regWe, vitAcs_31_regRe, clk, clk2, reset);


//==============================================================================
