//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_30_sb_w            = 8;
  parameter vitAcs_30_pmIn0_w         = 9;
  parameter vitAcs_30_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_30_sel_w           = 1;
  parameter vitAcs_30_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_30_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_30_i0              = 0;
  parameter vitAcs_30_i1              = 1;
  parameter vitAcs_30_pbrv            = 412;
  parameter vitAcs_30_ws              = 4;
  parameter vitAcs_30_wp              = 9;

  // Iregs
  parameter vitAcs_30_pmBuf_w         = 9;
  parameter vitAcs_30_pmBuf_n         = 1;
  parameter vitAcs_30_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_30.sb_w            = vitAcs_30_sb_w;
  defparam vitAcs_30.pmIn0_w         = vitAcs_30_pmIn0_w;
  defparam vitAcs_30.pmIn1_w         = vitAcs_30_pmIn1_w;
  defparam vitAcs_30.sel_w           = vitAcs_30_sel_w;
  defparam vitAcs_30.pmOut_w         = vitAcs_30_pmOut_w;
  defparam vitAcs_30.run1_w          = vitAcs_30_run1_w;
  defparam vitAcs_30.i0              = vitAcs_30_i0;
  defparam vitAcs_30.i1              = vitAcs_30_i1;
  defparam vitAcs_30.pbrv            = vitAcs_30_pbrv;
  defparam vitAcs_30.ws              = vitAcs_30_ws;
  defparam vitAcs_30.wp              = vitAcs_30_wp;
  defparam vitAcs_30.pmBuf_w         = vitAcs_30_pmBuf_w;
  defparam vitAcs_30.pmBuf_n         = vitAcs_30_pmBuf_n;
  defparam vitAcs_30.pmBuf_m         = vitAcs_30_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_30_sel_w-1:0]  vitAcs_30_sel;
  wire                                      vitAcs_30_sel_or;
  wire                                      vitAcs_30_sel_ff;
  wire                                      vitAcs_30_sel_we;

  wire             [vitAcs_30_pmOut_w-1:0]  vitAcs_30_pmOut;
  wire                                      vitAcs_30_pmOut_or;
  wire                                      vitAcs_30_pmOut_ff;
  wire                                      vitAcs_30_pmOut_we;

  wire                [vitAcs_30_sb_w-1:0]  vitAcs_30_sb;
  wire                                      vitAcs_30_sb_ir;
  wire                                      vitAcs_30_sb_fe;
  wire                                      vitAcs_30_sb_re;

  wire             [vitAcs_30_pmIn0_w-1:0]  vitAcs_30_pmIn0;
  wire                                      vitAcs_30_pmIn0_ir;
  wire                                      vitAcs_30_pmIn0_fe;
  wire                                      vitAcs_30_pmIn0_re;

  wire             [vitAcs_30_pmIn1_w-1:0]  vitAcs_30_pmIn1;
  wire                                      vitAcs_30_pmIn1_ir;
  wire                                      vitAcs_30_pmIn1_fe;
  wire                                      vitAcs_30_pmIn1_re;

  wire              [vitAcs_30_run1_w-1:0]  vitAcs_30_run1;

  wire                                      vitAcs_30_regWe;
  wire                                      vitAcs_30_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_30(vitAcs_30_sel, vitAcs_30_sel_or, vitAcs_30_sel_ff, vitAcs_30_sel_we,
                   vitAcs_30_pmOut, vitAcs_30_pmOut_or, vitAcs_30_pmOut_ff, vitAcs_30_pmOut_we,
                   vitAcs_30_sb, vitAcs_30_sb_ir, vitAcs_30_sb_fe, vitAcs_30_sb_re, 
                   vitAcs_30_pmIn0, vitAcs_30_pmIn0_ir, vitAcs_30_pmIn0_fe, vitAcs_30_pmIn0_re, 
                   vitAcs_30_pmIn1, vitAcs_30_pmIn1_ir, vitAcs_30_pmIn1_fe, vitAcs_30_pmIn1_re, 
                   vitAcs_30_run1, 
                   regBus, regWe, regRe, vitAcs_30_regWe, vitAcs_30_regRe, clk, clk2, reset);


//==============================================================================
