//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_27_sb_w            = 8;
  parameter vitAcs_27_pmIn0_w         = 9;
  parameter vitAcs_27_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_27_sel_w           = 1;
  parameter vitAcs_27_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_27_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_27_i0              = 0;
  parameter vitAcs_27_i1              = 1;
  parameter vitAcs_27_pbrv            = 412;
  parameter vitAcs_27_ws              = 4;
  parameter vitAcs_27_wp              = 9;

  // Iregs
  parameter vitAcs_27_pmBuf_w         = 9;
  parameter vitAcs_27_pmBuf_n         = 1;
  parameter vitAcs_27_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_27.sb_w            = vitAcs_27_sb_w;
  defparam vitAcs_27.pmIn0_w         = vitAcs_27_pmIn0_w;
  defparam vitAcs_27.pmIn1_w         = vitAcs_27_pmIn1_w;
  defparam vitAcs_27.sel_w           = vitAcs_27_sel_w;
  defparam vitAcs_27.pmOut_w         = vitAcs_27_pmOut_w;
  defparam vitAcs_27.run1_w          = vitAcs_27_run1_w;
  defparam vitAcs_27.i0              = vitAcs_27_i0;
  defparam vitAcs_27.i1              = vitAcs_27_i1;
  defparam vitAcs_27.pbrv            = vitAcs_27_pbrv;
  defparam vitAcs_27.ws              = vitAcs_27_ws;
  defparam vitAcs_27.wp              = vitAcs_27_wp;
  defparam vitAcs_27.pmBuf_w         = vitAcs_27_pmBuf_w;
  defparam vitAcs_27.pmBuf_n         = vitAcs_27_pmBuf_n;
  defparam vitAcs_27.pmBuf_m         = vitAcs_27_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_27_sel_w-1:0]  vitAcs_27_sel;
  wire                                      vitAcs_27_sel_or;
  wire                                      vitAcs_27_sel_ff;
  wire                                      vitAcs_27_sel_we;

  wire             [vitAcs_27_pmOut_w-1:0]  vitAcs_27_pmOut;
  wire                                      vitAcs_27_pmOut_or;
  wire                                      vitAcs_27_pmOut_ff;
  wire                                      vitAcs_27_pmOut_we;

  wire                [vitAcs_27_sb_w-1:0]  vitAcs_27_sb;
  wire                                      vitAcs_27_sb_ir;
  wire                                      vitAcs_27_sb_fe;
  wire                                      vitAcs_27_sb_re;

  wire             [vitAcs_27_pmIn0_w-1:0]  vitAcs_27_pmIn0;
  wire                                      vitAcs_27_pmIn0_ir;
  wire                                      vitAcs_27_pmIn0_fe;
  wire                                      vitAcs_27_pmIn0_re;

  wire             [vitAcs_27_pmIn1_w-1:0]  vitAcs_27_pmIn1;
  wire                                      vitAcs_27_pmIn1_ir;
  wire                                      vitAcs_27_pmIn1_fe;
  wire                                      vitAcs_27_pmIn1_re;

  wire              [vitAcs_27_run1_w-1:0]  vitAcs_27_run1;

  wire                                      vitAcs_27_regWe;
  wire                                      vitAcs_27_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_27(vitAcs_27_sel, vitAcs_27_sel_or, vitAcs_27_sel_ff, vitAcs_27_sel_we,
                   vitAcs_27_pmOut, vitAcs_27_pmOut_or, vitAcs_27_pmOut_ff, vitAcs_27_pmOut_we,
                   vitAcs_27_sb, vitAcs_27_sb_ir, vitAcs_27_sb_fe, vitAcs_27_sb_re, 
                   vitAcs_27_pmIn0, vitAcs_27_pmIn0_ir, vitAcs_27_pmIn0_fe, vitAcs_27_pmIn0_re, 
                   vitAcs_27_pmIn1, vitAcs_27_pmIn1_ir, vitAcs_27_pmIn1_fe, vitAcs_27_pmIn1_re, 
                   vitAcs_27_run1, 
                   regBus, regWe, regRe, vitAcs_27_regWe, vitAcs_27_regRe, clk, clk2, reset);


//==============================================================================
