//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_25_sb_w            = 8;
  parameter vitAcs_25_pmIn0_w         = 9;
  parameter vitAcs_25_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_25_sel_w           = 1;
  parameter vitAcs_25_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_25_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_25_i0              = 0;
  parameter vitAcs_25_i1              = 0;
  parameter vitAcs_25_pbrv            = 412;
  parameter vitAcs_25_ws              = 4;
  parameter vitAcs_25_wp              = 9;

  // Iregs
  parameter vitAcs_25_pmBuf_w         = 9;
  parameter vitAcs_25_pmBuf_n         = 1;
  parameter vitAcs_25_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_25.sb_w            = vitAcs_25_sb_w;
  defparam vitAcs_25.pmIn0_w         = vitAcs_25_pmIn0_w;
  defparam vitAcs_25.pmIn1_w         = vitAcs_25_pmIn1_w;
  defparam vitAcs_25.sel_w           = vitAcs_25_sel_w;
  defparam vitAcs_25.pmOut_w         = vitAcs_25_pmOut_w;
  defparam vitAcs_25.run1_w          = vitAcs_25_run1_w;
  defparam vitAcs_25.i0              = vitAcs_25_i0;
  defparam vitAcs_25.i1              = vitAcs_25_i1;
  defparam vitAcs_25.pbrv            = vitAcs_25_pbrv;
  defparam vitAcs_25.ws              = vitAcs_25_ws;
  defparam vitAcs_25.wp              = vitAcs_25_wp;
  defparam vitAcs_25.pmBuf_w         = vitAcs_25_pmBuf_w;
  defparam vitAcs_25.pmBuf_n         = vitAcs_25_pmBuf_n;
  defparam vitAcs_25.pmBuf_m         = vitAcs_25_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_25_sel_w-1:0]  vitAcs_25_sel;
  wire                                      vitAcs_25_sel_or;
  wire                                      vitAcs_25_sel_ff;
  wire                                      vitAcs_25_sel_we;

  wire             [vitAcs_25_pmOut_w-1:0]  vitAcs_25_pmOut;
  wire                                      vitAcs_25_pmOut_or;
  wire                                      vitAcs_25_pmOut_ff;
  wire                                      vitAcs_25_pmOut_we;

  wire                [vitAcs_25_sb_w-1:0]  vitAcs_25_sb;
  wire                                      vitAcs_25_sb_ir;
  wire                                      vitAcs_25_sb_fe;
  wire                                      vitAcs_25_sb_re;

  wire             [vitAcs_25_pmIn0_w-1:0]  vitAcs_25_pmIn0;
  wire                                      vitAcs_25_pmIn0_ir;
  wire                                      vitAcs_25_pmIn0_fe;
  wire                                      vitAcs_25_pmIn0_re;

  wire             [vitAcs_25_pmIn1_w-1:0]  vitAcs_25_pmIn1;
  wire                                      vitAcs_25_pmIn1_ir;
  wire                                      vitAcs_25_pmIn1_fe;
  wire                                      vitAcs_25_pmIn1_re;

  wire              [vitAcs_25_run1_w-1:0]  vitAcs_25_run1;

  wire                                      vitAcs_25_regWe;
  wire                                      vitAcs_25_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_25(vitAcs_25_sel, vitAcs_25_sel_or, vitAcs_25_sel_ff, vitAcs_25_sel_we,
                   vitAcs_25_pmOut, vitAcs_25_pmOut_or, vitAcs_25_pmOut_ff, vitAcs_25_pmOut_we,
                   vitAcs_25_sb, vitAcs_25_sb_ir, vitAcs_25_sb_fe, vitAcs_25_sb_re, 
                   vitAcs_25_pmIn0, vitAcs_25_pmIn0_ir, vitAcs_25_pmIn0_fe, vitAcs_25_pmIn0_re, 
                   vitAcs_25_pmIn1, vitAcs_25_pmIn1_ir, vitAcs_25_pmIn1_fe, vitAcs_25_pmIn1_re, 
                   vitAcs_25_run1, 
                   regBus, regWe, regRe, vitAcs_25_regWe, vitAcs_25_regRe, clk, clk2, reset);


//==============================================================================
