//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_22_sb_w            = 8;
  parameter vitAcs_22_pmIn0_w         = 9;
  parameter vitAcs_22_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_22_sel_w           = 1;
  parameter vitAcs_22_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_22_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_22_i0              = 1;
  parameter vitAcs_22_i1              = 0;
  parameter vitAcs_22_pbrv            = 412;
  parameter vitAcs_22_ws              = 4;
  parameter vitAcs_22_wp              = 9;

  // Iregs
  parameter vitAcs_22_pmBuf_w         = 9;
  parameter vitAcs_22_pmBuf_n         = 1;
  parameter vitAcs_22_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_22.sb_w            = vitAcs_22_sb_w;
  defparam vitAcs_22.pmIn0_w         = vitAcs_22_pmIn0_w;
  defparam vitAcs_22.pmIn1_w         = vitAcs_22_pmIn1_w;
  defparam vitAcs_22.sel_w           = vitAcs_22_sel_w;
  defparam vitAcs_22.pmOut_w         = vitAcs_22_pmOut_w;
  defparam vitAcs_22.run1_w          = vitAcs_22_run1_w;
  defparam vitAcs_22.i0              = vitAcs_22_i0;
  defparam vitAcs_22.i1              = vitAcs_22_i1;
  defparam vitAcs_22.pbrv            = vitAcs_22_pbrv;
  defparam vitAcs_22.ws              = vitAcs_22_ws;
  defparam vitAcs_22.wp              = vitAcs_22_wp;
  defparam vitAcs_22.pmBuf_w         = vitAcs_22_pmBuf_w;
  defparam vitAcs_22.pmBuf_n         = vitAcs_22_pmBuf_n;
  defparam vitAcs_22.pmBuf_m         = vitAcs_22_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_22_sel_w-1:0]  vitAcs_22_sel;
  wire                                      vitAcs_22_sel_or;
  wire                                      vitAcs_22_sel_ff;
  wire                                      vitAcs_22_sel_we;

  wire             [vitAcs_22_pmOut_w-1:0]  vitAcs_22_pmOut;
  wire                                      vitAcs_22_pmOut_or;
  wire                                      vitAcs_22_pmOut_ff;
  wire                                      vitAcs_22_pmOut_we;

  wire                [vitAcs_22_sb_w-1:0]  vitAcs_22_sb;
  wire                                      vitAcs_22_sb_ir;
  wire                                      vitAcs_22_sb_fe;
  wire                                      vitAcs_22_sb_re;

  wire             [vitAcs_22_pmIn0_w-1:0]  vitAcs_22_pmIn0;
  wire                                      vitAcs_22_pmIn0_ir;
  wire                                      vitAcs_22_pmIn0_fe;
  wire                                      vitAcs_22_pmIn0_re;

  wire             [vitAcs_22_pmIn1_w-1:0]  vitAcs_22_pmIn1;
  wire                                      vitAcs_22_pmIn1_ir;
  wire                                      vitAcs_22_pmIn1_fe;
  wire                                      vitAcs_22_pmIn1_re;

  wire              [vitAcs_22_run1_w-1:0]  vitAcs_22_run1;

  wire                                      vitAcs_22_regWe;
  wire                                      vitAcs_22_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_22(vitAcs_22_sel, vitAcs_22_sel_or, vitAcs_22_sel_ff, vitAcs_22_sel_we,
                   vitAcs_22_pmOut, vitAcs_22_pmOut_or, vitAcs_22_pmOut_ff, vitAcs_22_pmOut_we,
                   vitAcs_22_sb, vitAcs_22_sb_ir, vitAcs_22_sb_fe, vitAcs_22_sb_re, 
                   vitAcs_22_pmIn0, vitAcs_22_pmIn0_ir, vitAcs_22_pmIn0_fe, vitAcs_22_pmIn0_re, 
                   vitAcs_22_pmIn1, vitAcs_22_pmIn1_ir, vitAcs_22_pmIn1_fe, vitAcs_22_pmIn1_re, 
                   vitAcs_22_run1, 
                   regBus, regWe, regRe, vitAcs_22_regWe, vitAcs_22_regRe, clk, clk2, reset);


//==============================================================================
