//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_21_sb_w            = 8;
  parameter vitAcs_21_pmIn0_w         = 9;
  parameter vitAcs_21_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_21_sel_w           = 1;
  parameter vitAcs_21_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_21_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_21_i0              = 0;
  parameter vitAcs_21_i1              = 0;
  parameter vitAcs_21_pbrv            = 412;
  parameter vitAcs_21_ws              = 4;
  parameter vitAcs_21_wp              = 9;

  // Iregs
  parameter vitAcs_21_pmBuf_w         = 9;
  parameter vitAcs_21_pmBuf_n         = 1;
  parameter vitAcs_21_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_21.sb_w            = vitAcs_21_sb_w;
  defparam vitAcs_21.pmIn0_w         = vitAcs_21_pmIn0_w;
  defparam vitAcs_21.pmIn1_w         = vitAcs_21_pmIn1_w;
  defparam vitAcs_21.sel_w           = vitAcs_21_sel_w;
  defparam vitAcs_21.pmOut_w         = vitAcs_21_pmOut_w;
  defparam vitAcs_21.run1_w          = vitAcs_21_run1_w;
  defparam vitAcs_21.i0              = vitAcs_21_i0;
  defparam vitAcs_21.i1              = vitAcs_21_i1;
  defparam vitAcs_21.pbrv            = vitAcs_21_pbrv;
  defparam vitAcs_21.ws              = vitAcs_21_ws;
  defparam vitAcs_21.wp              = vitAcs_21_wp;
  defparam vitAcs_21.pmBuf_w         = vitAcs_21_pmBuf_w;
  defparam vitAcs_21.pmBuf_n         = vitAcs_21_pmBuf_n;
  defparam vitAcs_21.pmBuf_m         = vitAcs_21_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_21_sel_w-1:0]  vitAcs_21_sel;
  wire                                      vitAcs_21_sel_or;
  wire                                      vitAcs_21_sel_ff;
  wire                                      vitAcs_21_sel_we;

  wire             [vitAcs_21_pmOut_w-1:0]  vitAcs_21_pmOut;
  wire                                      vitAcs_21_pmOut_or;
  wire                                      vitAcs_21_pmOut_ff;
  wire                                      vitAcs_21_pmOut_we;

  wire                [vitAcs_21_sb_w-1:0]  vitAcs_21_sb;
  wire                                      vitAcs_21_sb_ir;
  wire                                      vitAcs_21_sb_fe;
  wire                                      vitAcs_21_sb_re;

  wire             [vitAcs_21_pmIn0_w-1:0]  vitAcs_21_pmIn0;
  wire                                      vitAcs_21_pmIn0_ir;
  wire                                      vitAcs_21_pmIn0_fe;
  wire                                      vitAcs_21_pmIn0_re;

  wire             [vitAcs_21_pmIn1_w-1:0]  vitAcs_21_pmIn1;
  wire                                      vitAcs_21_pmIn1_ir;
  wire                                      vitAcs_21_pmIn1_fe;
  wire                                      vitAcs_21_pmIn1_re;

  wire              [vitAcs_21_run1_w-1:0]  vitAcs_21_run1;

  wire                                      vitAcs_21_regWe;
  wire                                      vitAcs_21_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_21(vitAcs_21_sel, vitAcs_21_sel_or, vitAcs_21_sel_ff, vitAcs_21_sel_we,
                   vitAcs_21_pmOut, vitAcs_21_pmOut_or, vitAcs_21_pmOut_ff, vitAcs_21_pmOut_we,
                   vitAcs_21_sb, vitAcs_21_sb_ir, vitAcs_21_sb_fe, vitAcs_21_sb_re, 
                   vitAcs_21_pmIn0, vitAcs_21_pmIn0_ir, vitAcs_21_pmIn0_fe, vitAcs_21_pmIn0_re, 
                   vitAcs_21_pmIn1, vitAcs_21_pmIn1_ir, vitAcs_21_pmIn1_fe, vitAcs_21_pmIn1_re, 
                   vitAcs_21_run1, 
                   regBus, regWe, regRe, vitAcs_21_regWe, vitAcs_21_regRe, clk, clk2, reset);


//==============================================================================
