//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_19_sb_w            = 8;
  parameter vitAcs_19_pmIn0_w         = 9;
  parameter vitAcs_19_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_19_sel_w           = 1;
  parameter vitAcs_19_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_19_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_19_i0              = 1;
  parameter vitAcs_19_i1              = 0;
  parameter vitAcs_19_pbrv            = 412;
  parameter vitAcs_19_ws              = 4;
  parameter vitAcs_19_wp              = 9;

  // Iregs
  parameter vitAcs_19_pmBuf_w         = 9;
  parameter vitAcs_19_pmBuf_n         = 1;
  parameter vitAcs_19_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_19.sb_w            = vitAcs_19_sb_w;
  defparam vitAcs_19.pmIn0_w         = vitAcs_19_pmIn0_w;
  defparam vitAcs_19.pmIn1_w         = vitAcs_19_pmIn1_w;
  defparam vitAcs_19.sel_w           = vitAcs_19_sel_w;
  defparam vitAcs_19.pmOut_w         = vitAcs_19_pmOut_w;
  defparam vitAcs_19.run1_w          = vitAcs_19_run1_w;
  defparam vitAcs_19.i0              = vitAcs_19_i0;
  defparam vitAcs_19.i1              = vitAcs_19_i1;
  defparam vitAcs_19.pbrv            = vitAcs_19_pbrv;
  defparam vitAcs_19.ws              = vitAcs_19_ws;
  defparam vitAcs_19.wp              = vitAcs_19_wp;
  defparam vitAcs_19.pmBuf_w         = vitAcs_19_pmBuf_w;
  defparam vitAcs_19.pmBuf_n         = vitAcs_19_pmBuf_n;
  defparam vitAcs_19.pmBuf_m         = vitAcs_19_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_19_sel_w-1:0]  vitAcs_19_sel;
  wire                                      vitAcs_19_sel_or;
  wire                                      vitAcs_19_sel_ff;
  wire                                      vitAcs_19_sel_we;

  wire             [vitAcs_19_pmOut_w-1:0]  vitAcs_19_pmOut;
  wire                                      vitAcs_19_pmOut_or;
  wire                                      vitAcs_19_pmOut_ff;
  wire                                      vitAcs_19_pmOut_we;

  wire                [vitAcs_19_sb_w-1:0]  vitAcs_19_sb;
  wire                                      vitAcs_19_sb_ir;
  wire                                      vitAcs_19_sb_fe;
  wire                                      vitAcs_19_sb_re;

  wire             [vitAcs_19_pmIn0_w-1:0]  vitAcs_19_pmIn0;
  wire                                      vitAcs_19_pmIn0_ir;
  wire                                      vitAcs_19_pmIn0_fe;
  wire                                      vitAcs_19_pmIn0_re;

  wire             [vitAcs_19_pmIn1_w-1:0]  vitAcs_19_pmIn1;
  wire                                      vitAcs_19_pmIn1_ir;
  wire                                      vitAcs_19_pmIn1_fe;
  wire                                      vitAcs_19_pmIn1_re;

  wire              [vitAcs_19_run1_w-1:0]  vitAcs_19_run1;

  wire                                      vitAcs_19_regWe;
  wire                                      vitAcs_19_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_19(vitAcs_19_sel, vitAcs_19_sel_or, vitAcs_19_sel_ff, vitAcs_19_sel_we,
                   vitAcs_19_pmOut, vitAcs_19_pmOut_or, vitAcs_19_pmOut_ff, vitAcs_19_pmOut_we,
                   vitAcs_19_sb, vitAcs_19_sb_ir, vitAcs_19_sb_fe, vitAcs_19_sb_re, 
                   vitAcs_19_pmIn0, vitAcs_19_pmIn0_ir, vitAcs_19_pmIn0_fe, vitAcs_19_pmIn0_re, 
                   vitAcs_19_pmIn1, vitAcs_19_pmIn1_ir, vitAcs_19_pmIn1_fe, vitAcs_19_pmIn1_re, 
                   vitAcs_19_run1, 
                   regBus, regWe, regRe, vitAcs_19_regWe, vitAcs_19_regRe, clk, clk2, reset);


//==============================================================================
