//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_18_sb_w            = 8;
  parameter vitAcs_18_pmIn0_w         = 9;
  parameter vitAcs_18_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_18_sel_w           = 1;
  parameter vitAcs_18_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_18_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_18_i0              = 0;
  parameter vitAcs_18_i1              = 1;
  parameter vitAcs_18_pbrv            = 412;
  parameter vitAcs_18_ws              = 4;
  parameter vitAcs_18_wp              = 9;

  // Iregs
  parameter vitAcs_18_pmBuf_w         = 9;
  parameter vitAcs_18_pmBuf_n         = 1;
  parameter vitAcs_18_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_18.sb_w            = vitAcs_18_sb_w;
  defparam vitAcs_18.pmIn0_w         = vitAcs_18_pmIn0_w;
  defparam vitAcs_18.pmIn1_w         = vitAcs_18_pmIn1_w;
  defparam vitAcs_18.sel_w           = vitAcs_18_sel_w;
  defparam vitAcs_18.pmOut_w         = vitAcs_18_pmOut_w;
  defparam vitAcs_18.run1_w          = vitAcs_18_run1_w;
  defparam vitAcs_18.i0              = vitAcs_18_i0;
  defparam vitAcs_18.i1              = vitAcs_18_i1;
  defparam vitAcs_18.pbrv            = vitAcs_18_pbrv;
  defparam vitAcs_18.ws              = vitAcs_18_ws;
  defparam vitAcs_18.wp              = vitAcs_18_wp;
  defparam vitAcs_18.pmBuf_w         = vitAcs_18_pmBuf_w;
  defparam vitAcs_18.pmBuf_n         = vitAcs_18_pmBuf_n;
  defparam vitAcs_18.pmBuf_m         = vitAcs_18_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_18_sel_w-1:0]  vitAcs_18_sel;
  wire                                      vitAcs_18_sel_or;
  wire                                      vitAcs_18_sel_ff;
  wire                                      vitAcs_18_sel_we;

  wire             [vitAcs_18_pmOut_w-1:0]  vitAcs_18_pmOut;
  wire                                      vitAcs_18_pmOut_or;
  wire                                      vitAcs_18_pmOut_ff;
  wire                                      vitAcs_18_pmOut_we;

  wire                [vitAcs_18_sb_w-1:0]  vitAcs_18_sb;
  wire                                      vitAcs_18_sb_ir;
  wire                                      vitAcs_18_sb_fe;
  wire                                      vitAcs_18_sb_re;

  wire             [vitAcs_18_pmIn0_w-1:0]  vitAcs_18_pmIn0;
  wire                                      vitAcs_18_pmIn0_ir;
  wire                                      vitAcs_18_pmIn0_fe;
  wire                                      vitAcs_18_pmIn0_re;

  wire             [vitAcs_18_pmIn1_w-1:0]  vitAcs_18_pmIn1;
  wire                                      vitAcs_18_pmIn1_ir;
  wire                                      vitAcs_18_pmIn1_fe;
  wire                                      vitAcs_18_pmIn1_re;

  wire              [vitAcs_18_run1_w-1:0]  vitAcs_18_run1;

  wire                                      vitAcs_18_regWe;
  wire                                      vitAcs_18_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_18(vitAcs_18_sel, vitAcs_18_sel_or, vitAcs_18_sel_ff, vitAcs_18_sel_we,
                   vitAcs_18_pmOut, vitAcs_18_pmOut_or, vitAcs_18_pmOut_ff, vitAcs_18_pmOut_we,
                   vitAcs_18_sb, vitAcs_18_sb_ir, vitAcs_18_sb_fe, vitAcs_18_sb_re, 
                   vitAcs_18_pmIn0, vitAcs_18_pmIn0_ir, vitAcs_18_pmIn0_fe, vitAcs_18_pmIn0_re, 
                   vitAcs_18_pmIn1, vitAcs_18_pmIn1_ir, vitAcs_18_pmIn1_fe, vitAcs_18_pmIn1_re, 
                   vitAcs_18_run1, 
                   regBus, regWe, regRe, vitAcs_18_regWe, vitAcs_18_regRe, clk, clk2, reset);


//==============================================================================
