//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_17_sb_w            = 8;
  parameter vitAcs_17_pmIn0_w         = 9;
  parameter vitAcs_17_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_17_sel_w           = 1;
  parameter vitAcs_17_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_17_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_17_i0              = 1;
  parameter vitAcs_17_i1              = 1;
  parameter vitAcs_17_pbrv            = 412;
  parameter vitAcs_17_ws              = 4;
  parameter vitAcs_17_wp              = 9;

  // Iregs
  parameter vitAcs_17_pmBuf_w         = 9;
  parameter vitAcs_17_pmBuf_n         = 1;
  parameter vitAcs_17_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_17.sb_w            = vitAcs_17_sb_w;
  defparam vitAcs_17.pmIn0_w         = vitAcs_17_pmIn0_w;
  defparam vitAcs_17.pmIn1_w         = vitAcs_17_pmIn1_w;
  defparam vitAcs_17.sel_w           = vitAcs_17_sel_w;
  defparam vitAcs_17.pmOut_w         = vitAcs_17_pmOut_w;
  defparam vitAcs_17.run1_w          = vitAcs_17_run1_w;
  defparam vitAcs_17.i0              = vitAcs_17_i0;
  defparam vitAcs_17.i1              = vitAcs_17_i1;
  defparam vitAcs_17.pbrv            = vitAcs_17_pbrv;
  defparam vitAcs_17.ws              = vitAcs_17_ws;
  defparam vitAcs_17.wp              = vitAcs_17_wp;
  defparam vitAcs_17.pmBuf_w         = vitAcs_17_pmBuf_w;
  defparam vitAcs_17.pmBuf_n         = vitAcs_17_pmBuf_n;
  defparam vitAcs_17.pmBuf_m         = vitAcs_17_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_17_sel_w-1:0]  vitAcs_17_sel;
  wire                                      vitAcs_17_sel_or;
  wire                                      vitAcs_17_sel_ff;
  wire                                      vitAcs_17_sel_we;

  wire             [vitAcs_17_pmOut_w-1:0]  vitAcs_17_pmOut;
  wire                                      vitAcs_17_pmOut_or;
  wire                                      vitAcs_17_pmOut_ff;
  wire                                      vitAcs_17_pmOut_we;

  wire                [vitAcs_17_sb_w-1:0]  vitAcs_17_sb;
  wire                                      vitAcs_17_sb_ir;
  wire                                      vitAcs_17_sb_fe;
  wire                                      vitAcs_17_sb_re;

  wire             [vitAcs_17_pmIn0_w-1:0]  vitAcs_17_pmIn0;
  wire                                      vitAcs_17_pmIn0_ir;
  wire                                      vitAcs_17_pmIn0_fe;
  wire                                      vitAcs_17_pmIn0_re;

  wire             [vitAcs_17_pmIn1_w-1:0]  vitAcs_17_pmIn1;
  wire                                      vitAcs_17_pmIn1_ir;
  wire                                      vitAcs_17_pmIn1_fe;
  wire                                      vitAcs_17_pmIn1_re;

  wire              [vitAcs_17_run1_w-1:0]  vitAcs_17_run1;

  wire                                      vitAcs_17_regWe;
  wire                                      vitAcs_17_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_17(vitAcs_17_sel, vitAcs_17_sel_or, vitAcs_17_sel_ff, vitAcs_17_sel_we,
                   vitAcs_17_pmOut, vitAcs_17_pmOut_or, vitAcs_17_pmOut_ff, vitAcs_17_pmOut_we,
                   vitAcs_17_sb, vitAcs_17_sb_ir, vitAcs_17_sb_fe, vitAcs_17_sb_re, 
                   vitAcs_17_pmIn0, vitAcs_17_pmIn0_ir, vitAcs_17_pmIn0_fe, vitAcs_17_pmIn0_re, 
                   vitAcs_17_pmIn1, vitAcs_17_pmIn1_ir, vitAcs_17_pmIn1_fe, vitAcs_17_pmIn1_re, 
                   vitAcs_17_run1, 
                   regBus, regWe, regRe, vitAcs_17_regWe, vitAcs_17_regRe, clk, clk2, reset);


//==============================================================================
