//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_16_sb_w            = 8;
  parameter vitAcs_16_pmIn0_w         = 9;
  parameter vitAcs_16_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_16_sel_w           = 1;
  parameter vitAcs_16_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_16_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_16_i0              = 0;
  parameter vitAcs_16_i1              = 0;
  parameter vitAcs_16_pbrv            = 412;
  parameter vitAcs_16_ws              = 4;
  parameter vitAcs_16_wp              = 9;

  // Iregs
  parameter vitAcs_16_pmBuf_w         = 9;
  parameter vitAcs_16_pmBuf_n         = 1;
  parameter vitAcs_16_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_16.sb_w            = vitAcs_16_sb_w;
  defparam vitAcs_16.pmIn0_w         = vitAcs_16_pmIn0_w;
  defparam vitAcs_16.pmIn1_w         = vitAcs_16_pmIn1_w;
  defparam vitAcs_16.sel_w           = vitAcs_16_sel_w;
  defparam vitAcs_16.pmOut_w         = vitAcs_16_pmOut_w;
  defparam vitAcs_16.run1_w          = vitAcs_16_run1_w;
  defparam vitAcs_16.i0              = vitAcs_16_i0;
  defparam vitAcs_16.i1              = vitAcs_16_i1;
  defparam vitAcs_16.pbrv            = vitAcs_16_pbrv;
  defparam vitAcs_16.ws              = vitAcs_16_ws;
  defparam vitAcs_16.wp              = vitAcs_16_wp;
  defparam vitAcs_16.pmBuf_w         = vitAcs_16_pmBuf_w;
  defparam vitAcs_16.pmBuf_n         = vitAcs_16_pmBuf_n;
  defparam vitAcs_16.pmBuf_m         = vitAcs_16_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_16_sel_w-1:0]  vitAcs_16_sel;
  wire                                      vitAcs_16_sel_or;
  wire                                      vitAcs_16_sel_ff;
  wire                                      vitAcs_16_sel_we;

  wire             [vitAcs_16_pmOut_w-1:0]  vitAcs_16_pmOut;
  wire                                      vitAcs_16_pmOut_or;
  wire                                      vitAcs_16_pmOut_ff;
  wire                                      vitAcs_16_pmOut_we;

  wire                [vitAcs_16_sb_w-1:0]  vitAcs_16_sb;
  wire                                      vitAcs_16_sb_ir;
  wire                                      vitAcs_16_sb_fe;
  wire                                      vitAcs_16_sb_re;

  wire             [vitAcs_16_pmIn0_w-1:0]  vitAcs_16_pmIn0;
  wire                                      vitAcs_16_pmIn0_ir;
  wire                                      vitAcs_16_pmIn0_fe;
  wire                                      vitAcs_16_pmIn0_re;

  wire             [vitAcs_16_pmIn1_w-1:0]  vitAcs_16_pmIn1;
  wire                                      vitAcs_16_pmIn1_ir;
  wire                                      vitAcs_16_pmIn1_fe;
  wire                                      vitAcs_16_pmIn1_re;

  wire              [vitAcs_16_run1_w-1:0]  vitAcs_16_run1;

  wire                                      vitAcs_16_regWe;
  wire                                      vitAcs_16_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_16(vitAcs_16_sel, vitAcs_16_sel_or, vitAcs_16_sel_ff, vitAcs_16_sel_we,
                   vitAcs_16_pmOut, vitAcs_16_pmOut_or, vitAcs_16_pmOut_ff, vitAcs_16_pmOut_we,
                   vitAcs_16_sb, vitAcs_16_sb_ir, vitAcs_16_sb_fe, vitAcs_16_sb_re, 
                   vitAcs_16_pmIn0, vitAcs_16_pmIn0_ir, vitAcs_16_pmIn0_fe, vitAcs_16_pmIn0_re, 
                   vitAcs_16_pmIn1, vitAcs_16_pmIn1_ir, vitAcs_16_pmIn1_fe, vitAcs_16_pmIn1_re, 
                   vitAcs_16_run1, 
                   regBus, regWe, regRe, vitAcs_16_regWe, vitAcs_16_regRe, clk, clk2, reset);


//==============================================================================
