//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_15_sb_w            = 8;
  parameter vitAcs_15_pmIn0_w         = 9;
  parameter vitAcs_15_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_15_sel_w           = 1;
  parameter vitAcs_15_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_15_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_15_i0              = 1;
  parameter vitAcs_15_i1              = 0;
  parameter vitAcs_15_pbrv            = 412;
  parameter vitAcs_15_ws              = 4;
  parameter vitAcs_15_wp              = 9;

  // Iregs
  parameter vitAcs_15_pmBuf_w         = 9;
  parameter vitAcs_15_pmBuf_n         = 1;
  parameter vitAcs_15_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_15.sb_w            = vitAcs_15_sb_w;
  defparam vitAcs_15.pmIn0_w         = vitAcs_15_pmIn0_w;
  defparam vitAcs_15.pmIn1_w         = vitAcs_15_pmIn1_w;
  defparam vitAcs_15.sel_w           = vitAcs_15_sel_w;
  defparam vitAcs_15.pmOut_w         = vitAcs_15_pmOut_w;
  defparam vitAcs_15.run1_w          = vitAcs_15_run1_w;
  defparam vitAcs_15.i0              = vitAcs_15_i0;
  defparam vitAcs_15.i1              = vitAcs_15_i1;
  defparam vitAcs_15.pbrv            = vitAcs_15_pbrv;
  defparam vitAcs_15.ws              = vitAcs_15_ws;
  defparam vitAcs_15.wp              = vitAcs_15_wp;
  defparam vitAcs_15.pmBuf_w         = vitAcs_15_pmBuf_w;
  defparam vitAcs_15.pmBuf_n         = vitAcs_15_pmBuf_n;
  defparam vitAcs_15.pmBuf_m         = vitAcs_15_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_15_sel_w-1:0]  vitAcs_15_sel;
  wire                                      vitAcs_15_sel_or;
  wire                                      vitAcs_15_sel_ff;
  wire                                      vitAcs_15_sel_we;

  wire             [vitAcs_15_pmOut_w-1:0]  vitAcs_15_pmOut;
  wire                                      vitAcs_15_pmOut_or;
  wire                                      vitAcs_15_pmOut_ff;
  wire                                      vitAcs_15_pmOut_we;

  wire                [vitAcs_15_sb_w-1:0]  vitAcs_15_sb;
  wire                                      vitAcs_15_sb_ir;
  wire                                      vitAcs_15_sb_fe;
  wire                                      vitAcs_15_sb_re;

  wire             [vitAcs_15_pmIn0_w-1:0]  vitAcs_15_pmIn0;
  wire                                      vitAcs_15_pmIn0_ir;
  wire                                      vitAcs_15_pmIn0_fe;
  wire                                      vitAcs_15_pmIn0_re;

  wire             [vitAcs_15_pmIn1_w-1:0]  vitAcs_15_pmIn1;
  wire                                      vitAcs_15_pmIn1_ir;
  wire                                      vitAcs_15_pmIn1_fe;
  wire                                      vitAcs_15_pmIn1_re;

  wire              [vitAcs_15_run1_w-1:0]  vitAcs_15_run1;

  wire                                      vitAcs_15_regWe;
  wire                                      vitAcs_15_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_15(vitAcs_15_sel, vitAcs_15_sel_or, vitAcs_15_sel_ff, vitAcs_15_sel_we,
                   vitAcs_15_pmOut, vitAcs_15_pmOut_or, vitAcs_15_pmOut_ff, vitAcs_15_pmOut_we,
                   vitAcs_15_sb, vitAcs_15_sb_ir, vitAcs_15_sb_fe, vitAcs_15_sb_re, 
                   vitAcs_15_pmIn0, vitAcs_15_pmIn0_ir, vitAcs_15_pmIn0_fe, vitAcs_15_pmIn0_re, 
                   vitAcs_15_pmIn1, vitAcs_15_pmIn1_ir, vitAcs_15_pmIn1_fe, vitAcs_15_pmIn1_re, 
                   vitAcs_15_run1, 
                   regBus, regWe, regRe, vitAcs_15_regWe, vitAcs_15_regRe, clk, clk2, reset);


//==============================================================================
