//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_13_sb_w            = 8;
  parameter vitAcs_13_pmIn0_w         = 9;
  parameter vitAcs_13_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_13_sel_w           = 1;
  parameter vitAcs_13_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_13_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_13_i0              = 1;
  parameter vitAcs_13_i1              = 1;
  parameter vitAcs_13_pbrv            = 412;
  parameter vitAcs_13_ws              = 4;
  parameter vitAcs_13_wp              = 9;

  // Iregs
  parameter vitAcs_13_pmBuf_w         = 9;
  parameter vitAcs_13_pmBuf_n         = 1;
  parameter vitAcs_13_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_13.sb_w            = vitAcs_13_sb_w;
  defparam vitAcs_13.pmIn0_w         = vitAcs_13_pmIn0_w;
  defparam vitAcs_13.pmIn1_w         = vitAcs_13_pmIn1_w;
  defparam vitAcs_13.sel_w           = vitAcs_13_sel_w;
  defparam vitAcs_13.pmOut_w         = vitAcs_13_pmOut_w;
  defparam vitAcs_13.run1_w          = vitAcs_13_run1_w;
  defparam vitAcs_13.i0              = vitAcs_13_i0;
  defparam vitAcs_13.i1              = vitAcs_13_i1;
  defparam vitAcs_13.pbrv            = vitAcs_13_pbrv;
  defparam vitAcs_13.ws              = vitAcs_13_ws;
  defparam vitAcs_13.wp              = vitAcs_13_wp;
  defparam vitAcs_13.pmBuf_w         = vitAcs_13_pmBuf_w;
  defparam vitAcs_13.pmBuf_n         = vitAcs_13_pmBuf_n;
  defparam vitAcs_13.pmBuf_m         = vitAcs_13_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_13_sel_w-1:0]  vitAcs_13_sel;
  wire                                      vitAcs_13_sel_or;
  wire                                      vitAcs_13_sel_ff;
  wire                                      vitAcs_13_sel_we;

  wire             [vitAcs_13_pmOut_w-1:0]  vitAcs_13_pmOut;
  wire                                      vitAcs_13_pmOut_or;
  wire                                      vitAcs_13_pmOut_ff;
  wire                                      vitAcs_13_pmOut_we;

  wire                [vitAcs_13_sb_w-1:0]  vitAcs_13_sb;
  wire                                      vitAcs_13_sb_ir;
  wire                                      vitAcs_13_sb_fe;
  wire                                      vitAcs_13_sb_re;

  wire             [vitAcs_13_pmIn0_w-1:0]  vitAcs_13_pmIn0;
  wire                                      vitAcs_13_pmIn0_ir;
  wire                                      vitAcs_13_pmIn0_fe;
  wire                                      vitAcs_13_pmIn0_re;

  wire             [vitAcs_13_pmIn1_w-1:0]  vitAcs_13_pmIn1;
  wire                                      vitAcs_13_pmIn1_ir;
  wire                                      vitAcs_13_pmIn1_fe;
  wire                                      vitAcs_13_pmIn1_re;

  wire              [vitAcs_13_run1_w-1:0]  vitAcs_13_run1;

  wire                                      vitAcs_13_regWe;
  wire                                      vitAcs_13_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_13(vitAcs_13_sel, vitAcs_13_sel_or, vitAcs_13_sel_ff, vitAcs_13_sel_we,
                   vitAcs_13_pmOut, vitAcs_13_pmOut_or, vitAcs_13_pmOut_ff, vitAcs_13_pmOut_we,
                   vitAcs_13_sb, vitAcs_13_sb_ir, vitAcs_13_sb_fe, vitAcs_13_sb_re, 
                   vitAcs_13_pmIn0, vitAcs_13_pmIn0_ir, vitAcs_13_pmIn0_fe, vitAcs_13_pmIn0_re, 
                   vitAcs_13_pmIn1, vitAcs_13_pmIn1_ir, vitAcs_13_pmIn1_fe, vitAcs_13_pmIn1_re, 
                   vitAcs_13_run1, 
                   regBus, regWe, regRe, vitAcs_13_regWe, vitAcs_13_regRe, clk, clk2, reset);


//==============================================================================
