//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_10_sb_w            = 8;
  parameter vitAcs_10_pmIn0_w         = 9;
  parameter vitAcs_10_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_10_sel_w           = 1;
  parameter vitAcs_10_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_10_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_10_i0              = 1;
  parameter vitAcs_10_i1              = 0;
  parameter vitAcs_10_pbrv            = 412;
  parameter vitAcs_10_ws              = 4;
  parameter vitAcs_10_wp              = 9;

  // Iregs
  parameter vitAcs_10_pmBuf_w         = 9;
  parameter vitAcs_10_pmBuf_n         = 1;
  parameter vitAcs_10_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_10.sb_w            = vitAcs_10_sb_w;
  defparam vitAcs_10.pmIn0_w         = vitAcs_10_pmIn0_w;
  defparam vitAcs_10.pmIn1_w         = vitAcs_10_pmIn1_w;
  defparam vitAcs_10.sel_w           = vitAcs_10_sel_w;
  defparam vitAcs_10.pmOut_w         = vitAcs_10_pmOut_w;
  defparam vitAcs_10.run1_w          = vitAcs_10_run1_w;
  defparam vitAcs_10.i0              = vitAcs_10_i0;
  defparam vitAcs_10.i1              = vitAcs_10_i1;
  defparam vitAcs_10.pbrv            = vitAcs_10_pbrv;
  defparam vitAcs_10.ws              = vitAcs_10_ws;
  defparam vitAcs_10.wp              = vitAcs_10_wp;
  defparam vitAcs_10.pmBuf_w         = vitAcs_10_pmBuf_w;
  defparam vitAcs_10.pmBuf_n         = vitAcs_10_pmBuf_n;
  defparam vitAcs_10.pmBuf_m         = vitAcs_10_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_10_sel_w-1:0]  vitAcs_10_sel;
  wire                                      vitAcs_10_sel_or;
  wire                                      vitAcs_10_sel_ff;
  wire                                      vitAcs_10_sel_we;

  wire             [vitAcs_10_pmOut_w-1:0]  vitAcs_10_pmOut;
  wire                                      vitAcs_10_pmOut_or;
  wire                                      vitAcs_10_pmOut_ff;
  wire                                      vitAcs_10_pmOut_we;

  wire                [vitAcs_10_sb_w-1:0]  vitAcs_10_sb;
  wire                                      vitAcs_10_sb_ir;
  wire                                      vitAcs_10_sb_fe;
  wire                                      vitAcs_10_sb_re;

  wire             [vitAcs_10_pmIn0_w-1:0]  vitAcs_10_pmIn0;
  wire                                      vitAcs_10_pmIn0_ir;
  wire                                      vitAcs_10_pmIn0_fe;
  wire                                      vitAcs_10_pmIn0_re;

  wire             [vitAcs_10_pmIn1_w-1:0]  vitAcs_10_pmIn1;
  wire                                      vitAcs_10_pmIn1_ir;
  wire                                      vitAcs_10_pmIn1_fe;
  wire                                      vitAcs_10_pmIn1_re;

  wire              [vitAcs_10_run1_w-1:0]  vitAcs_10_run1;

  wire                                      vitAcs_10_regWe;
  wire                                      vitAcs_10_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_10(vitAcs_10_sel, vitAcs_10_sel_or, vitAcs_10_sel_ff, vitAcs_10_sel_we,
                   vitAcs_10_pmOut, vitAcs_10_pmOut_or, vitAcs_10_pmOut_ff, vitAcs_10_pmOut_we,
                   vitAcs_10_sb, vitAcs_10_sb_ir, vitAcs_10_sb_fe, vitAcs_10_sb_re, 
                   vitAcs_10_pmIn0, vitAcs_10_pmIn0_ir, vitAcs_10_pmIn0_fe, vitAcs_10_pmIn0_re, 
                   vitAcs_10_pmIn1, vitAcs_10_pmIn1_ir, vitAcs_10_pmIn1_fe, vitAcs_10_pmIn1_re, 
                   vitAcs_10_run1, 
                   regBus, regWe, regRe, vitAcs_10_regWe, vitAcs_10_regRe, clk, clk2, reset);


//==============================================================================
