//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_09_sb_w            = 8;
  parameter vitAcs_09_pmIn0_w         = 9;
  parameter vitAcs_09_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_09_sel_w           = 1;
  parameter vitAcs_09_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_09_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_09_i0              = 0;
  parameter vitAcs_09_i1              = 0;
  parameter vitAcs_09_pbrv            = 412;
  parameter vitAcs_09_ws              = 4;
  parameter vitAcs_09_wp              = 9;

  // Iregs
  parameter vitAcs_09_pmBuf_w         = 9;
  parameter vitAcs_09_pmBuf_n         = 1;
  parameter vitAcs_09_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_09.sb_w            = vitAcs_09_sb_w;
  defparam vitAcs_09.pmIn0_w         = vitAcs_09_pmIn0_w;
  defparam vitAcs_09.pmIn1_w         = vitAcs_09_pmIn1_w;
  defparam vitAcs_09.sel_w           = vitAcs_09_sel_w;
  defparam vitAcs_09.pmOut_w         = vitAcs_09_pmOut_w;
  defparam vitAcs_09.run1_w          = vitAcs_09_run1_w;
  defparam vitAcs_09.i0              = vitAcs_09_i0;
  defparam vitAcs_09.i1              = vitAcs_09_i1;
  defparam vitAcs_09.pbrv            = vitAcs_09_pbrv;
  defparam vitAcs_09.ws              = vitAcs_09_ws;
  defparam vitAcs_09.wp              = vitAcs_09_wp;
  defparam vitAcs_09.pmBuf_w         = vitAcs_09_pmBuf_w;
  defparam vitAcs_09.pmBuf_n         = vitAcs_09_pmBuf_n;
  defparam vitAcs_09.pmBuf_m         = vitAcs_09_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_09_sel_w-1:0]  vitAcs_09_sel;
  wire                                      vitAcs_09_sel_or;
  wire                                      vitAcs_09_sel_ff;
  wire                                      vitAcs_09_sel_we;

  wire             [vitAcs_09_pmOut_w-1:0]  vitAcs_09_pmOut;
  wire                                      vitAcs_09_pmOut_or;
  wire                                      vitAcs_09_pmOut_ff;
  wire                                      vitAcs_09_pmOut_we;

  wire                [vitAcs_09_sb_w-1:0]  vitAcs_09_sb;
  wire                                      vitAcs_09_sb_ir;
  wire                                      vitAcs_09_sb_fe;
  wire                                      vitAcs_09_sb_re;

  wire             [vitAcs_09_pmIn0_w-1:0]  vitAcs_09_pmIn0;
  wire                                      vitAcs_09_pmIn0_ir;
  wire                                      vitAcs_09_pmIn0_fe;
  wire                                      vitAcs_09_pmIn0_re;

  wire             [vitAcs_09_pmIn1_w-1:0]  vitAcs_09_pmIn1;
  wire                                      vitAcs_09_pmIn1_ir;
  wire                                      vitAcs_09_pmIn1_fe;
  wire                                      vitAcs_09_pmIn1_re;

  wire              [vitAcs_09_run1_w-1:0]  vitAcs_09_run1;

  wire                                      vitAcs_09_regWe;
  wire                                      vitAcs_09_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_09(vitAcs_09_sel, vitAcs_09_sel_or, vitAcs_09_sel_ff, vitAcs_09_sel_we,
                   vitAcs_09_pmOut, vitAcs_09_pmOut_or, vitAcs_09_pmOut_ff, vitAcs_09_pmOut_we,
                   vitAcs_09_sb, vitAcs_09_sb_ir, vitAcs_09_sb_fe, vitAcs_09_sb_re, 
                   vitAcs_09_pmIn0, vitAcs_09_pmIn0_ir, vitAcs_09_pmIn0_fe, vitAcs_09_pmIn0_re, 
                   vitAcs_09_pmIn1, vitAcs_09_pmIn1_ir, vitAcs_09_pmIn1_fe, vitAcs_09_pmIn1_re, 
                   vitAcs_09_run1, 
                   regBus, regWe, regRe, vitAcs_09_regWe, vitAcs_09_regRe, clk, clk2, reset);


//==============================================================================
