//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_08_sb_w            = 8;
  parameter vitAcs_08_pmIn0_w         = 9;
  parameter vitAcs_08_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_08_sel_w           = 1;
  parameter vitAcs_08_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_08_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_08_i0              = 1;
  parameter vitAcs_08_i1              = 1;
  parameter vitAcs_08_pbrv            = 412;
  parameter vitAcs_08_ws              = 4;
  parameter vitAcs_08_wp              = 9;

  // Iregs
  parameter vitAcs_08_pmBuf_w         = 9;
  parameter vitAcs_08_pmBuf_n         = 1;
  parameter vitAcs_08_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_08.sb_w            = vitAcs_08_sb_w;
  defparam vitAcs_08.pmIn0_w         = vitAcs_08_pmIn0_w;
  defparam vitAcs_08.pmIn1_w         = vitAcs_08_pmIn1_w;
  defparam vitAcs_08.sel_w           = vitAcs_08_sel_w;
  defparam vitAcs_08.pmOut_w         = vitAcs_08_pmOut_w;
  defparam vitAcs_08.run1_w          = vitAcs_08_run1_w;
  defparam vitAcs_08.i0              = vitAcs_08_i0;
  defparam vitAcs_08.i1              = vitAcs_08_i1;
  defparam vitAcs_08.pbrv            = vitAcs_08_pbrv;
  defparam vitAcs_08.ws              = vitAcs_08_ws;
  defparam vitAcs_08.wp              = vitAcs_08_wp;
  defparam vitAcs_08.pmBuf_w         = vitAcs_08_pmBuf_w;
  defparam vitAcs_08.pmBuf_n         = vitAcs_08_pmBuf_n;
  defparam vitAcs_08.pmBuf_m         = vitAcs_08_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_08_sel_w-1:0]  vitAcs_08_sel;
  wire                                      vitAcs_08_sel_or;
  wire                                      vitAcs_08_sel_ff;
  wire                                      vitAcs_08_sel_we;

  wire             [vitAcs_08_pmOut_w-1:0]  vitAcs_08_pmOut;
  wire                                      vitAcs_08_pmOut_or;
  wire                                      vitAcs_08_pmOut_ff;
  wire                                      vitAcs_08_pmOut_we;

  wire                [vitAcs_08_sb_w-1:0]  vitAcs_08_sb;
  wire                                      vitAcs_08_sb_ir;
  wire                                      vitAcs_08_sb_fe;
  wire                                      vitAcs_08_sb_re;

  wire             [vitAcs_08_pmIn0_w-1:0]  vitAcs_08_pmIn0;
  wire                                      vitAcs_08_pmIn0_ir;
  wire                                      vitAcs_08_pmIn0_fe;
  wire                                      vitAcs_08_pmIn0_re;

  wire             [vitAcs_08_pmIn1_w-1:0]  vitAcs_08_pmIn1;
  wire                                      vitAcs_08_pmIn1_ir;
  wire                                      vitAcs_08_pmIn1_fe;
  wire                                      vitAcs_08_pmIn1_re;

  wire              [vitAcs_08_run1_w-1:0]  vitAcs_08_run1;

  wire                                      vitAcs_08_regWe;
  wire                                      vitAcs_08_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_08(vitAcs_08_sel, vitAcs_08_sel_or, vitAcs_08_sel_ff, vitAcs_08_sel_we,
                   vitAcs_08_pmOut, vitAcs_08_pmOut_or, vitAcs_08_pmOut_ff, vitAcs_08_pmOut_we,
                   vitAcs_08_sb, vitAcs_08_sb_ir, vitAcs_08_sb_fe, vitAcs_08_sb_re, 
                   vitAcs_08_pmIn0, vitAcs_08_pmIn0_ir, vitAcs_08_pmIn0_fe, vitAcs_08_pmIn0_re, 
                   vitAcs_08_pmIn1, vitAcs_08_pmIn1_ir, vitAcs_08_pmIn1_fe, vitAcs_08_pmIn1_re, 
                   vitAcs_08_run1, 
                   regBus, regWe, regRe, vitAcs_08_regWe, vitAcs_08_regRe, clk, clk2, reset);


//==============================================================================
