//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_05_sb_w            = 8;
  parameter vitAcs_05_pmIn0_w         = 9;
  parameter vitAcs_05_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_05_sel_w           = 1;
  parameter vitAcs_05_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_05_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_05_i0              = 0;
  parameter vitAcs_05_i1              = 0;
  parameter vitAcs_05_pbrv            = 412;
  parameter vitAcs_05_ws              = 4;
  parameter vitAcs_05_wp              = 9;

  // Iregs
  parameter vitAcs_05_pmBuf_w         = 9;
  parameter vitAcs_05_pmBuf_n         = 1;
  parameter vitAcs_05_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_05.sb_w            = vitAcs_05_sb_w;
  defparam vitAcs_05.pmIn0_w         = vitAcs_05_pmIn0_w;
  defparam vitAcs_05.pmIn1_w         = vitAcs_05_pmIn1_w;
  defparam vitAcs_05.sel_w           = vitAcs_05_sel_w;
  defparam vitAcs_05.pmOut_w         = vitAcs_05_pmOut_w;
  defparam vitAcs_05.run1_w          = vitAcs_05_run1_w;
  defparam vitAcs_05.i0              = vitAcs_05_i0;
  defparam vitAcs_05.i1              = vitAcs_05_i1;
  defparam vitAcs_05.pbrv            = vitAcs_05_pbrv;
  defparam vitAcs_05.ws              = vitAcs_05_ws;
  defparam vitAcs_05.wp              = vitAcs_05_wp;
  defparam vitAcs_05.pmBuf_w         = vitAcs_05_pmBuf_w;
  defparam vitAcs_05.pmBuf_n         = vitAcs_05_pmBuf_n;
  defparam vitAcs_05.pmBuf_m         = vitAcs_05_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_05_sel_w-1:0]  vitAcs_05_sel;
  wire                                      vitAcs_05_sel_or;
  wire                                      vitAcs_05_sel_ff;
  wire                                      vitAcs_05_sel_we;

  wire             [vitAcs_05_pmOut_w-1:0]  vitAcs_05_pmOut;
  wire                                      vitAcs_05_pmOut_or;
  wire                                      vitAcs_05_pmOut_ff;
  wire                                      vitAcs_05_pmOut_we;

  wire                [vitAcs_05_sb_w-1:0]  vitAcs_05_sb;
  wire                                      vitAcs_05_sb_ir;
  wire                                      vitAcs_05_sb_fe;
  wire                                      vitAcs_05_sb_re;

  wire             [vitAcs_05_pmIn0_w-1:0]  vitAcs_05_pmIn0;
  wire                                      vitAcs_05_pmIn0_ir;
  wire                                      vitAcs_05_pmIn0_fe;
  wire                                      vitAcs_05_pmIn0_re;

  wire             [vitAcs_05_pmIn1_w-1:0]  vitAcs_05_pmIn1;
  wire                                      vitAcs_05_pmIn1_ir;
  wire                                      vitAcs_05_pmIn1_fe;
  wire                                      vitAcs_05_pmIn1_re;

  wire              [vitAcs_05_run1_w-1:0]  vitAcs_05_run1;

  wire                                      vitAcs_05_regWe;
  wire                                      vitAcs_05_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_05(vitAcs_05_sel, vitAcs_05_sel_or, vitAcs_05_sel_ff, vitAcs_05_sel_we,
                   vitAcs_05_pmOut, vitAcs_05_pmOut_or, vitAcs_05_pmOut_ff, vitAcs_05_pmOut_we,
                   vitAcs_05_sb, vitAcs_05_sb_ir, vitAcs_05_sb_fe, vitAcs_05_sb_re, 
                   vitAcs_05_pmIn0, vitAcs_05_pmIn0_ir, vitAcs_05_pmIn0_fe, vitAcs_05_pmIn0_re, 
                   vitAcs_05_pmIn1, vitAcs_05_pmIn1_ir, vitAcs_05_pmIn1_fe, vitAcs_05_pmIn1_re, 
                   vitAcs_05_run1, 
                   regBus, regWe, regRe, vitAcs_05_regWe, vitAcs_05_regRe, clk, clk2, reset);


//==============================================================================
