//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_04_sb_w            = 8;
  parameter vitAcs_04_pmIn0_w         = 9;
  parameter vitAcs_04_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_04_sel_w           = 1;
  parameter vitAcs_04_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_04_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_04_i0              = 1;
  parameter vitAcs_04_i1              = 1;
  parameter vitAcs_04_pbrv            = 412;
  parameter vitAcs_04_ws              = 4;
  parameter vitAcs_04_wp              = 9;

  // Iregs
  parameter vitAcs_04_pmBuf_w         = 9;
  parameter vitAcs_04_pmBuf_n         = 1;
  parameter vitAcs_04_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_04.sb_w            = vitAcs_04_sb_w;
  defparam vitAcs_04.pmIn0_w         = vitAcs_04_pmIn0_w;
  defparam vitAcs_04.pmIn1_w         = vitAcs_04_pmIn1_w;
  defparam vitAcs_04.sel_w           = vitAcs_04_sel_w;
  defparam vitAcs_04.pmOut_w         = vitAcs_04_pmOut_w;
  defparam vitAcs_04.run1_w          = vitAcs_04_run1_w;
  defparam vitAcs_04.i0              = vitAcs_04_i0;
  defparam vitAcs_04.i1              = vitAcs_04_i1;
  defparam vitAcs_04.pbrv            = vitAcs_04_pbrv;
  defparam vitAcs_04.ws              = vitAcs_04_ws;
  defparam vitAcs_04.wp              = vitAcs_04_wp;
  defparam vitAcs_04.pmBuf_w         = vitAcs_04_pmBuf_w;
  defparam vitAcs_04.pmBuf_n         = vitAcs_04_pmBuf_n;
  defparam vitAcs_04.pmBuf_m         = vitAcs_04_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_04_sel_w-1:0]  vitAcs_04_sel;
  wire                                      vitAcs_04_sel_or;
  wire                                      vitAcs_04_sel_ff;
  wire                                      vitAcs_04_sel_we;

  wire             [vitAcs_04_pmOut_w-1:0]  vitAcs_04_pmOut;
  wire                                      vitAcs_04_pmOut_or;
  wire                                      vitAcs_04_pmOut_ff;
  wire                                      vitAcs_04_pmOut_we;

  wire                [vitAcs_04_sb_w-1:0]  vitAcs_04_sb;
  wire                                      vitAcs_04_sb_ir;
  wire                                      vitAcs_04_sb_fe;
  wire                                      vitAcs_04_sb_re;

  wire             [vitAcs_04_pmIn0_w-1:0]  vitAcs_04_pmIn0;
  wire                                      vitAcs_04_pmIn0_ir;
  wire                                      vitAcs_04_pmIn0_fe;
  wire                                      vitAcs_04_pmIn0_re;

  wire             [vitAcs_04_pmIn1_w-1:0]  vitAcs_04_pmIn1;
  wire                                      vitAcs_04_pmIn1_ir;
  wire                                      vitAcs_04_pmIn1_fe;
  wire                                      vitAcs_04_pmIn1_re;

  wire              [vitAcs_04_run1_w-1:0]  vitAcs_04_run1;

  wire                                      vitAcs_04_regWe;
  wire                                      vitAcs_04_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_04(vitAcs_04_sel, vitAcs_04_sel_or, vitAcs_04_sel_ff, vitAcs_04_sel_we,
                   vitAcs_04_pmOut, vitAcs_04_pmOut_or, vitAcs_04_pmOut_ff, vitAcs_04_pmOut_we,
                   vitAcs_04_sb, vitAcs_04_sb_ir, vitAcs_04_sb_fe, vitAcs_04_sb_re, 
                   vitAcs_04_pmIn0, vitAcs_04_pmIn0_ir, vitAcs_04_pmIn0_fe, vitAcs_04_pmIn0_re, 
                   vitAcs_04_pmIn1, vitAcs_04_pmIn1_ir, vitAcs_04_pmIn1_fe, vitAcs_04_pmIn1_re, 
                   vitAcs_04_run1, 
                   regBus, regWe, regRe, vitAcs_04_regWe, vitAcs_04_regRe, clk, clk2, reset);


//==============================================================================
