//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_02_sb_w            = 8;
  parameter vitAcs_02_pmIn0_w         = 9;
  parameter vitAcs_02_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_02_sel_w           = 1;
  parameter vitAcs_02_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_02_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_02_i0              = 0;
  parameter vitAcs_02_i1              = 1;
  parameter vitAcs_02_pbrv            = 412;
  parameter vitAcs_02_ws              = 4;
  parameter vitAcs_02_wp              = 9;

  // Iregs
  parameter vitAcs_02_pmBuf_w         = 9;
  parameter vitAcs_02_pmBuf_n         = 1;
  parameter vitAcs_02_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_02.sb_w            = vitAcs_02_sb_w;
  defparam vitAcs_02.pmIn0_w         = vitAcs_02_pmIn0_w;
  defparam vitAcs_02.pmIn1_w         = vitAcs_02_pmIn1_w;
  defparam vitAcs_02.sel_w           = vitAcs_02_sel_w;
  defparam vitAcs_02.pmOut_w         = vitAcs_02_pmOut_w;
  defparam vitAcs_02.run1_w          = vitAcs_02_run1_w;
  defparam vitAcs_02.i0              = vitAcs_02_i0;
  defparam vitAcs_02.i1              = vitAcs_02_i1;
  defparam vitAcs_02.pbrv            = vitAcs_02_pbrv;
  defparam vitAcs_02.ws              = vitAcs_02_ws;
  defparam vitAcs_02.wp              = vitAcs_02_wp;
  defparam vitAcs_02.pmBuf_w         = vitAcs_02_pmBuf_w;
  defparam vitAcs_02.pmBuf_n         = vitAcs_02_pmBuf_n;
  defparam vitAcs_02.pmBuf_m         = vitAcs_02_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_02_sel_w-1:0]  vitAcs_02_sel;
  wire                                      vitAcs_02_sel_or;
  wire                                      vitAcs_02_sel_ff;
  wire                                      vitAcs_02_sel_we;

  wire             [vitAcs_02_pmOut_w-1:0]  vitAcs_02_pmOut;
  wire                                      vitAcs_02_pmOut_or;
  wire                                      vitAcs_02_pmOut_ff;
  wire                                      vitAcs_02_pmOut_we;

  wire                [vitAcs_02_sb_w-1:0]  vitAcs_02_sb;
  wire                                      vitAcs_02_sb_ir;
  wire                                      vitAcs_02_sb_fe;
  wire                                      vitAcs_02_sb_re;

  wire             [vitAcs_02_pmIn0_w-1:0]  vitAcs_02_pmIn0;
  wire                                      vitAcs_02_pmIn0_ir;
  wire                                      vitAcs_02_pmIn0_fe;
  wire                                      vitAcs_02_pmIn0_re;

  wire             [vitAcs_02_pmIn1_w-1:0]  vitAcs_02_pmIn1;
  wire                                      vitAcs_02_pmIn1_ir;
  wire                                      vitAcs_02_pmIn1_fe;
  wire                                      vitAcs_02_pmIn1_re;

  wire              [vitAcs_02_run1_w-1:0]  vitAcs_02_run1;

  wire                                      vitAcs_02_regWe;
  wire                                      vitAcs_02_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_02(vitAcs_02_sel, vitAcs_02_sel_or, vitAcs_02_sel_ff, vitAcs_02_sel_we,
                   vitAcs_02_pmOut, vitAcs_02_pmOut_or, vitAcs_02_pmOut_ff, vitAcs_02_pmOut_we,
                   vitAcs_02_sb, vitAcs_02_sb_ir, vitAcs_02_sb_fe, vitAcs_02_sb_re, 
                   vitAcs_02_pmIn0, vitAcs_02_pmIn0_ir, vitAcs_02_pmIn0_fe, vitAcs_02_pmIn0_re, 
                   vitAcs_02_pmIn1, vitAcs_02_pmIn1_ir, vitAcs_02_pmIn1_fe, vitAcs_02_pmIn1_re, 
                   vitAcs_02_run1, 
                   regBus, regWe, regRe, vitAcs_02_regWe, vitAcs_02_regRe, clk, clk2, reset);


//==============================================================================
