//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_00_sb_w            = 8;
  parameter vitAcs_00_pmIn0_w         = 9;
  parameter vitAcs_00_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_00_sel_w           = 1;
  parameter vitAcs_00_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_00_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_00_i0              = 0;
  parameter vitAcs_00_i1              = 0;
  parameter vitAcs_00_pbrv            = 0;
  parameter vitAcs_00_ws              = 4;
  parameter vitAcs_00_wp              = 9;

  // Iregs
  parameter vitAcs_00_pmBuf_w         = 9;
  parameter vitAcs_00_pmBuf_n         = 1;
  parameter vitAcs_00_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_00.sb_w            = vitAcs_00_sb_w;
  defparam vitAcs_00.pmIn0_w         = vitAcs_00_pmIn0_w;
  defparam vitAcs_00.pmIn1_w         = vitAcs_00_pmIn1_w;
  defparam vitAcs_00.sel_w           = vitAcs_00_sel_w;
  defparam vitAcs_00.pmOut_w         = vitAcs_00_pmOut_w;
  defparam vitAcs_00.run1_w          = vitAcs_00_run1_w;
  defparam vitAcs_00.i0              = vitAcs_00_i0;
  defparam vitAcs_00.i1              = vitAcs_00_i1;
  defparam vitAcs_00.pbrv            = vitAcs_00_pbrv;
  defparam vitAcs_00.ws              = vitAcs_00_ws;
  defparam vitAcs_00.wp              = vitAcs_00_wp;
  defparam vitAcs_00.pmBuf_w         = vitAcs_00_pmBuf_w;
  defparam vitAcs_00.pmBuf_n         = vitAcs_00_pmBuf_n;
  defparam vitAcs_00.pmBuf_m         = vitAcs_00_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_00_sel_w-1:0]  vitAcs_00_sel;
  wire                                      vitAcs_00_sel_or;
  wire                                      vitAcs_00_sel_ff;
  wire                                      vitAcs_00_sel_we;

  wire             [vitAcs_00_pmOut_w-1:0]  vitAcs_00_pmOut;
  wire                                      vitAcs_00_pmOut_or;
  wire                                      vitAcs_00_pmOut_ff;
  wire                                      vitAcs_00_pmOut_we;

  wire                [vitAcs_00_sb_w-1:0]  vitAcs_00_sb;
  wire                                      vitAcs_00_sb_ir;
  wire                                      vitAcs_00_sb_fe;
  wire                                      vitAcs_00_sb_re;

  wire             [vitAcs_00_pmIn0_w-1:0]  vitAcs_00_pmIn0;
  wire                                      vitAcs_00_pmIn0_ir;
  wire                                      vitAcs_00_pmIn0_fe;
  wire                                      vitAcs_00_pmIn0_re;

  wire             [vitAcs_00_pmIn1_w-1:0]  vitAcs_00_pmIn1;
  wire                                      vitAcs_00_pmIn1_ir;
  wire                                      vitAcs_00_pmIn1_fe;
  wire                                      vitAcs_00_pmIn1_re;

  wire              [vitAcs_00_run1_w-1:0]  vitAcs_00_run1;

  wire                                      vitAcs_00_regWe;
  wire                                      vitAcs_00_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_00(vitAcs_00_sel, vitAcs_00_sel_or, vitAcs_00_sel_ff, vitAcs_00_sel_we,
                   vitAcs_00_pmOut, vitAcs_00_pmOut_or, vitAcs_00_pmOut_ff, vitAcs_00_pmOut_we,
                   vitAcs_00_sb, vitAcs_00_sb_ir, vitAcs_00_sb_fe, vitAcs_00_sb_re, 
                   vitAcs_00_pmIn0, vitAcs_00_pmIn0_ir, vitAcs_00_pmIn0_fe, vitAcs_00_pmIn0_re, 
                   vitAcs_00_pmIn1, vitAcs_00_pmIn1_ir, vitAcs_00_pmIn1_fe, vitAcs_00_pmIn1_re, 
                   vitAcs_00_run1, 
                   regBus, regWe, regRe, vitAcs_00_regWe, vitAcs_00_regRe, clk, clk2, reset);


//==============================================================================
