//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter txRfCtrl_0_tCnt_w          = 1;

  // Outputs

  // Input control lines

  // Output control lines
  parameter txRfCtrl_0_paOn_w          = 1;
  parameter txRfCtrl_0_txOn_w          = 1;
  parameter txRfCtrl_0_bbOn_w          = 1;

  // Eregs
  parameter txRfCtrl_0_run1_w          = 1;
  parameter txRfCtrl_0_run1_r          = 0;
  parameter txRfCtrl_0_run1_s          = 0;
  parameter txRfCtrl_0_paDelay_w       = 16;
  parameter txRfCtrl_0_paDelay_r       = 1;
  parameter txRfCtrl_0_paDelay_s       = 0;
  parameter txRfCtrl_0_txDelay_w       = 16;
  parameter txRfCtrl_0_txDelay_r       = 1;
  parameter txRfCtrl_0_txDelay_s       = 0;
  parameter txRfCtrl_0_bbDelay_w       = 16;
  parameter txRfCtrl_0_bbDelay_r       = 1;
  parameter txRfCtrl_0_bbDelay_s       = 0;

  // Parameters
  parameter txRfCtrl_0_wt              = 16;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam txRfCtrl_0.tCnt_w          = txRfCtrl_0_tCnt_w;
  defparam txRfCtrl_0.paOn_w          = txRfCtrl_0_paOn_w;
  defparam txRfCtrl_0.txOn_w          = txRfCtrl_0_txOn_w;
  defparam txRfCtrl_0.bbOn_w          = txRfCtrl_0_bbOn_w;
  defparam txRfCtrl_0.run1_w          = txRfCtrl_0_run1_w;
  defparam txRfCtrl_0.run1_r          = txRfCtrl_0_run1_r;
  defparam txRfCtrl_0.run1_s          = txRfCtrl_0_run1_s;
  defparam txRfCtrl_0.paDelay_w       = txRfCtrl_0_paDelay_w;
  defparam txRfCtrl_0.paDelay_r       = txRfCtrl_0_paDelay_r;
  defparam txRfCtrl_0.paDelay_s       = txRfCtrl_0_paDelay_s;
  defparam txRfCtrl_0.txDelay_w       = txRfCtrl_0_txDelay_w;
  defparam txRfCtrl_0.txDelay_r       = txRfCtrl_0_txDelay_r;
  defparam txRfCtrl_0.txDelay_s       = txRfCtrl_0_txDelay_s;
  defparam txRfCtrl_0.bbDelay_w       = txRfCtrl_0_bbDelay_w;
  defparam txRfCtrl_0.bbDelay_r       = txRfCtrl_0_bbDelay_r;
  defparam txRfCtrl_0.bbDelay_s       = txRfCtrl_0_bbDelay_s;
  defparam txRfCtrl_0.wt              = txRfCtrl_0_wt;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_txRfCtrl_0_run1                                            = 0;
  defparam  txRfCtrl_0.R_run1                                            = R_txRfCtrl_0_run1;
  parameter R_txRfCtrl_0_paDelay                                         = 1;
  defparam  txRfCtrl_0.R_paDelay                                         = R_txRfCtrl_0_paDelay;
  parameter R_txRfCtrl_0_txDelay                                         = 2;
  defparam  txRfCtrl_0.R_txDelay                                         = R_txRfCtrl_0_txDelay;
  parameter R_txRfCtrl_0_bbDelay                                         = 3;
  defparam  txRfCtrl_0.R_bbDelay                                         = R_txRfCtrl_0_bbDelay;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire             [txRfCtrl_0_tCnt_w-1:0]  txRfCtrl_0_tCnt;
  wire                                      txRfCtrl_0_tCnt_ir;
  wire                                      txRfCtrl_0_tCnt_fe;
  wire                                      txRfCtrl_0_tCnt_re;

  wire             [txRfCtrl_0_paOn_w-1:0]  txRfCtrl_0_paOn;
  wire             [txRfCtrl_0_txOn_w-1:0]  txRfCtrl_0_txOn;
  wire             [txRfCtrl_0_bbOn_w-1:0]  txRfCtrl_0_bbOn;

  wire                                      txRfCtrl_0_regWe;
  wire                                      txRfCtrl_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  txRfCtrl txRfCtrl_0(txRfCtrl_0_tCnt, txRfCtrl_0_tCnt_ir, txRfCtrl_0_tCnt_fe, txRfCtrl_0_tCnt_re, 
                      txRfCtrl_0_paOn, 
                      txRfCtrl_0_txOn, 
                      txRfCtrl_0_bbOn, 
                      regBus, regWe, regRe, txRfCtrl_0_regWe, txRfCtrl_0_regRe, clk, clk2, reset);


//==============================================================================
