//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter tx11a_0_x_w             = 8;
  parameter tx11a_0_xFft_w          = 20;

  // Outputs
  parameter tx11a_0_y_w             = 20;
  parameter tx11a_0_yFft_w          = 20;

  // Input control lines

  // Output control lines
  parameter tx11a_0_irqDone_w       = 3;

  // Eregs

  // Parameters
  parameter tx11a_0_w               = 10;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam tx11a_0.x_w             = tx11a_0_x_w;
  defparam tx11a_0.xFft_w          = tx11a_0_xFft_w;
  defparam tx11a_0.y_w             = tx11a_0_y_w;
  defparam tx11a_0.yFft_w          = tx11a_0_yFft_w;
  defparam tx11a_0.irqDone_w       = tx11a_0_irqDone_w;
  defparam tx11a_0.w               = tx11a_0_w;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_tx11a_0_enc11a_0_run1                                      = 0;
  defparam  tx11a_0.R_enc11a_0_run1                                      = R_tx11a_0_enc11a_0_run1;
  parameter R_tx11a_0_enc11a_0_crc32_0_numBits                           = 1;
  defparam  tx11a_0.R_enc11a_0_crc32_0_numBits                           = R_tx11a_0_enc11a_0_crc32_0_numBits;
  parameter R_tx11a_0_enc11a_0_ppdu11a_0_plcpHdr0                        = 2;
  defparam  tx11a_0.R_enc11a_0_ppdu11a_0_plcpHdr0                        = R_tx11a_0_enc11a_0_ppdu11a_0_plcpHdr0;
  parameter R_tx11a_0_enc11a_0_ppdu11a_0_plcpHdr1                        = 3;
  defparam  tx11a_0.R_enc11a_0_ppdu11a_0_plcpHdr1                        = R_tx11a_0_enc11a_0_ppdu11a_0_plcpHdr1;
  parameter R_tx11a_0_enc11a_0_ppdu11a_0_numByte                         = 4;
  defparam  tx11a_0.R_enc11a_0_ppdu11a_0_numByte                         = R_tx11a_0_enc11a_0_ppdu11a_0_numByte;
  parameter R_tx11a_0_enc11a_0_ppdu11a_0_numPadBit                       = 5;
  defparam  tx11a_0.R_enc11a_0_ppdu11a_0_numPadBit                       = R_tx11a_0_enc11a_0_ppdu11a_0_numPadBit;
  parameter R_tx11a_0_enc11a_0_scrmbl_0_s                                = 6;
  defparam  tx11a_0.R_enc11a_0_scrmbl_0_s                                = R_tx11a_0_enc11a_0_scrmbl_0_s;
  parameter R_tx11a_0_enc11a_0_punct_0_run1                              = 7;
  defparam  tx11a_0.R_enc11a_0_punct_0_run1                              = R_tx11a_0_enc11a_0_punct_0_run1;
  parameter R_tx11a_0_mod11a_0_run1                                      = 8;
  defparam  tx11a_0.R_mod11a_0_run1                                      = R_tx11a_0_mod11a_0_run1;
  parameter R_tx11a_0_mod11a_0_intlv_0_mode1                             = 9;
  defparam  tx11a_0.R_mod11a_0_intlv_0_mode1                             = R_tx11a_0_mod11a_0_intlv_0_mode1;
  parameter R_tx11a_0_mod11a_0_qamMod_0_mode1                            = 10;
  defparam  tx11a_0.R_mod11a_0_qamMod_0_mode1                            = R_tx11a_0_mod11a_0_qamMod_0_mode1;
  parameter R_tx11a_0_mod11a_0_shortSym_0_numOfdm                        = 11;
  defparam  tx11a_0.R_mod11a_0_shortSym_0_numOfdm                        = R_tx11a_0_mod11a_0_shortSym_0_numOfdm;

  // FIFO address definitions - might be overwritten by an upper module
  parameter R_tx11a_0_mod11a_0_qam2lpd                                   = 12;
  defparam  tx11a_0.R_mod11a_0_qam2lpd                                   = R_tx11a_0_mod11a_0_qam2lpd;

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                   [tx11a_0_y_w-1:0]  tx11a_0_y;
  wire                                      tx11a_0_y_or;
  wire                                      tx11a_0_y_ff;
  wire                                      tx11a_0_y_we;

  wire                [tx11a_0_yFft_w-1:0]  tx11a_0_yFft;
  wire                                      tx11a_0_yFft_or;
  wire                                      tx11a_0_yFft_ff;
  wire                                      tx11a_0_yFft_we;

  wire                   [tx11a_0_x_w-1:0]  tx11a_0_x;
  wire                                      tx11a_0_x_ir;
  wire                                      tx11a_0_x_fe;
  wire                                      tx11a_0_x_re;

  wire                [tx11a_0_xFft_w-1:0]  tx11a_0_xFft;
  wire                                      tx11a_0_xFft_ir;
  wire                                      tx11a_0_xFft_fe;
  wire                                      tx11a_0_xFft_re;

  wire             [tx11a_0_irqDone_w-1:0]  tx11a_0_irqDone;

  wire                                      tx11a_0_regWe;
  wire                                      tx11a_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  tx11a tx11a_0(tx11a_0_y, tx11a_0_y_or, tx11a_0_y_ff, tx11a_0_y_we,
                tx11a_0_yFft, tx11a_0_yFft_or, tx11a_0_yFft_ff, tx11a_0_yFft_we,
                tx11a_0_x, tx11a_0_x_ir, tx11a_0_x_fe, tx11a_0_x_re, 
                tx11a_0_xFft, tx11a_0_xFft_ir, tx11a_0_xFft_fe, tx11a_0_xFft_re, 
                tx11a_0_irqDone, 
                regBus, regWe, regRe, tx11a_0_regWe, tx11a_0_regRe, clk, clk2, reset);


//==============================================================================
