//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter sync11a_0_x_w             = 20;
  parameter sync11a_0_xu_w            = 20;
  parameter sync11a_0_xFft_w          = 20;

  // Outputs
  parameter sync11a_0_yC_w            = 26;
  parameter sync11a_0_ySh_w           = 9;
  parameter sync11a_0_yFft_w          = 20;
  parameter sync11a_0_yAbs_w          = 10;

  // Input control lines

  // Output control lines
  parameter sync11a_0_irqDone_w       = 2;

  // Eregs
  parameter sync11a_0_run1_w          = 3;
  parameter sync11a_0_run1_r          = 0;
  parameter sync11a_0_run1_s          = 0;

  // Parameters
  parameter sync11a_0_w               = 10;
  parameter sync11a_0_wu              = 10;
  parameter sync11a_0_ws              = 9;
  parameter sync11a_0_modeFte         = 1;
  parameter sync11a_0_modeFfe         = 2;
  parameter sync11a_0_modeAmpEst      = 3;
  parameter sync11a_0_modeChEst       = 4;
  parameter sync11a_0_modeChCor       = 5;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam sync11a_0.x_w             = sync11a_0_x_w;
  defparam sync11a_0.xu_w            = sync11a_0_xu_w;
  defparam sync11a_0.xFft_w          = sync11a_0_xFft_w;
  defparam sync11a_0.yC_w            = sync11a_0_yC_w;
  defparam sync11a_0.ySh_w           = sync11a_0_ySh_w;
  defparam sync11a_0.yFft_w          = sync11a_0_yFft_w;
  defparam sync11a_0.yAbs_w          = sync11a_0_yAbs_w;
  defparam sync11a_0.irqDone_w       = sync11a_0_irqDone_w;
  defparam sync11a_0.run1_w          = sync11a_0_run1_w;
  defparam sync11a_0.run1_r          = sync11a_0_run1_r;
  defparam sync11a_0.run1_s          = sync11a_0_run1_s;
  defparam sync11a_0.w               = sync11a_0_w;
  defparam sync11a_0.wu              = sync11a_0_wu;
  defparam sync11a_0.ws              = sync11a_0_ws;
  defparam sync11a_0.modeFte         = sync11a_0_modeFte;
  defparam sync11a_0.modeFfe         = sync11a_0_modeFfe;
  defparam sync11a_0.modeAmpEst      = sync11a_0_modeAmpEst;
  defparam sync11a_0.modeChEst       = sync11a_0_modeChEst;
  defparam sync11a_0.modeChCor       = sync11a_0_modeChCor;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_sync11a_0_run1                                             = 0;
  defparam  sync11a_0.R_run1                                             = R_sync11a_0_run1;
  parameter R_sync11a_0_lsCcf_0_peakPos                                  = 1;
  defparam  sync11a_0.R_lsCcf_0_peakPos                                  = R_sync11a_0_lsCcf_0_peakPos;
  parameter R_sync11a_0_lsCcf_0_peakVal                                  = 2;
  defparam  sync11a_0.R_lsCcf_0_peakVal                                  = R_sync11a_0_lsCcf_0_peakVal;
  parameter R_sync11a_0_cxMulAvg_0_numSmpl                               = 3;
  defparam  sync11a_0.R_cxMulAvg_0_numSmpl                               = R_sync11a_0_cxMulAvg_0_numSmpl;
  parameter R_sync11a_0_cxMulAvg_0_yReLo                                 = 4;
  defparam  sync11a_0.R_cxMulAvg_0_yReLo                                 = R_sync11a_0_cxMulAvg_0_yReLo;
  parameter R_sync11a_0_cxMulAvg_0_yImHi                                 = 5;
  defparam  sync11a_0.R_cxMulAvg_0_yImHi                                 = R_sync11a_0_cxMulAvg_0_yImHi;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                [sync11a_0_yC_w-1:0]  sync11a_0_yC;
  wire                                      sync11a_0_yC_or;
  wire                                      sync11a_0_yC_ff;
  wire                                      sync11a_0_yC_we;

  wire               [sync11a_0_ySh_w-1:0]  sync11a_0_ySh;
  wire                                      sync11a_0_ySh_or;
  wire                                      sync11a_0_ySh_ff;
  wire                                      sync11a_0_ySh_we;

  wire              [sync11a_0_yFft_w-1:0]  sync11a_0_yFft;
  wire                                      sync11a_0_yFft_or;
  wire                                      sync11a_0_yFft_ff;
  wire                                      sync11a_0_yFft_we;

  wire              [sync11a_0_yAbs_w-1:0]  sync11a_0_yAbs;
  wire                                      sync11a_0_yAbs_or;
  wire                                      sync11a_0_yAbs_ff;
  wire                                      sync11a_0_yAbs_we;

  wire                 [sync11a_0_x_w-1:0]  sync11a_0_x;
  wire                                      sync11a_0_x_ir;
  wire                                      sync11a_0_x_fe;
  wire                                      sync11a_0_x_re;

  wire                [sync11a_0_xu_w-1:0]  sync11a_0_xu;
  wire                                      sync11a_0_xu_ir;
  wire                                      sync11a_0_xu_fe;
  wire                                      sync11a_0_xu_re;

  wire              [sync11a_0_xFft_w-1:0]  sync11a_0_xFft;
  wire                                      sync11a_0_xFft_ir;
  wire                                      sync11a_0_xFft_fe;
  wire                                      sync11a_0_xFft_re;

  wire           [sync11a_0_irqDone_w-1:0]  sync11a_0_irqDone;

  wire                                      sync11a_0_regWe;
  wire                                      sync11a_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  sync11a sync11a_0(sync11a_0_yC, sync11a_0_yC_or, sync11a_0_yC_ff, sync11a_0_yC_we,
                    sync11a_0_ySh, sync11a_0_ySh_or, sync11a_0_ySh_ff, sync11a_0_ySh_we,
                    sync11a_0_yFft, sync11a_0_yFft_or, sync11a_0_yFft_ff, sync11a_0_yFft_we,
                    sync11a_0_yAbs, sync11a_0_yAbs_or, sync11a_0_yAbs_ff, sync11a_0_yAbs_we,
                    sync11a_0_x, sync11a_0_x_ir, sync11a_0_x_fe, sync11a_0_x_re, 
                    sync11a_0_xu, sync11a_0_xu_ir, sync11a_0_xu_fe, sync11a_0_xu_re, 
                    sync11a_0_xFft, sync11a_0_xFft_ir, sync11a_0_xFft_fe, sync11a_0_xFft_re, 
                    sync11a_0_irqDone, 
                    regBus, regWe, regRe, sync11a_0_regWe, sync11a_0_regRe, clk, clk2, reset);


//==============================================================================
