//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter ssNorm_0_x_w             = 20;

  // Outputs
  parameter ssNorm_0_y_w             = 10;
  parameter ssNorm_0_yAmp_w          = 9;

  // Input control lines
  parameter ssNorm_0_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter ssNorm_0_wx              = 10;
  parameter ssNorm_0_wy              = 5;
  parameter ssNorm_0_wa              = 9;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos
  parameter ssNorm_0_ffIn_w          = 20;
  parameter ssNorm_0_ffIn_n          = 25;
  parameter ssNorm_0_ffIn_m          = 5;

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam ssNorm_0.x_w             = ssNorm_0_x_w;
  defparam ssNorm_0.y_w             = ssNorm_0_y_w;
  defparam ssNorm_0.yAmp_w          = ssNorm_0_yAmp_w;
  defparam ssNorm_0.run1_w          = ssNorm_0_run1_w;
  defparam ssNorm_0.wx              = ssNorm_0_wx;
  defparam ssNorm_0.wy              = ssNorm_0_wy;
  defparam ssNorm_0.wa              = ssNorm_0_wa;
  defparam ssNorm_0.ffIn_w          = ssNorm_0_ffIn_w;
  defparam ssNorm_0.ffIn_m          = ssNorm_0_ffIn_m;
  defparam ssNorm_0.ffIn_n          = ssNorm_0_ffIn_n;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_ssNorm_0_cutN_20c4_numCut                                  = 0;
  defparam  ssNorm_0.R_cutN_20c4_numCut                                  = R_ssNorm_0_cutN_20c4_numCut;

  // FIFO address definitions - might be overwritten by an upper module
  parameter R_ssNorm_0_ffIn                                              = 1;
  defparam  ssNorm_0.R_ffIn                                              = R_ssNorm_0_ffIn;

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                  [ssNorm_0_y_w-1:0]  ssNorm_0_y;
  wire                                      ssNorm_0_y_or;
  wire                                      ssNorm_0_y_ff;
  wire                                      ssNorm_0_y_we;

  wire               [ssNorm_0_yAmp_w-1:0]  ssNorm_0_yAmp;
  wire                                      ssNorm_0_yAmp_or;
  wire                                      ssNorm_0_yAmp_ff;
  wire                                      ssNorm_0_yAmp_we;

  wire                  [ssNorm_0_x_w-1:0]  ssNorm_0_x;
  wire                                      ssNorm_0_x_ir;
  wire                                      ssNorm_0_x_fe;
  wire                                      ssNorm_0_x_re;

  wire               [ssNorm_0_run1_w-1:0]  ssNorm_0_run1;

  wire                                      ssNorm_0_regWe;
  wire                                      ssNorm_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  ssNorm ssNorm_0(ssNorm_0_y, ssNorm_0_y_or, ssNorm_0_y_ff, ssNorm_0_y_we,
                  ssNorm_0_yAmp, ssNorm_0_yAmp_or, ssNorm_0_yAmp_ff, ssNorm_0_yAmp_we,
                  ssNorm_0_x, ssNorm_0_x_ir, ssNorm_0_x_fe, ssNorm_0_x_re, 
                  ssNorm_0_run1, 
                  regBus, regWe, regRe, ssNorm_0_regWe, ssNorm_0_regRe, clk, clk2, reset);


//==============================================================================
