//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter ssDiv_0_x_w             = 20;
  parameter ssDiv_0_amp_w           = 9;

  // Outputs
  parameter ssDiv_0_y_w             = 10;

  // Input control lines
  parameter ssDiv_0_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter ssDiv_0_wx              = 10;
  parameter ssDiv_0_wy              = 5;
  parameter ssDiv_0_wa              = 9;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam ssDiv_0.x_w             = ssDiv_0_x_w;
  defparam ssDiv_0.amp_w           = ssDiv_0_amp_w;
  defparam ssDiv_0.y_w             = ssDiv_0_y_w;
  defparam ssDiv_0.run1_w          = ssDiv_0_run1_w;
  defparam ssDiv_0.wx              = ssDiv_0_wx;
  defparam ssDiv_0.wy              = ssDiv_0_wy;
  defparam ssDiv_0.wa              = ssDiv_0_wa;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                   [ssDiv_0_y_w-1:0]  ssDiv_0_y;
  wire                                      ssDiv_0_y_or;
  wire                                      ssDiv_0_y_ff;
  wire                                      ssDiv_0_y_we;

  wire                   [ssDiv_0_x_w-1:0]  ssDiv_0_x;
  wire                                      ssDiv_0_x_ir;
  wire                                      ssDiv_0_x_fe;
  wire                                      ssDiv_0_x_re;

  wire                 [ssDiv_0_amp_w-1:0]  ssDiv_0_amp;
  wire                                      ssDiv_0_amp_ir;
  wire                                      ssDiv_0_amp_fe;
  wire                                      ssDiv_0_amp_re;

  wire                [ssDiv_0_run1_w-1:0]  ssDiv_0_run1;

  wire                                      ssDiv_0_regWe;
  wire                                      ssDiv_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  ssDiv ssDiv_0(ssDiv_0_y, ssDiv_0_y_or, ssDiv_0_y_ff, ssDiv_0_y_we,
                ssDiv_0_x, ssDiv_0_x_ir, ssDiv_0_x_fe, ssDiv_0_x_re, 
                ssDiv_0_amp, ssDiv_0_amp_ir, ssDiv_0_amp_fe, ssDiv_0_amp_re, 
                ssDiv_0_run1, 
                regBus, regWe, regRe, ssDiv_0_regWe, ssDiv_0_regRe, clk, clk2, reset);


//==============================================================================
