//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter rx11a_0_x_w             = 20;
  parameter rx11a_0_xFft_w          = 20;

  // Outputs
  parameter rx11a_0_y_w             = 8;
  parameter rx11a_0_yFft_w          = 20;
  parameter rx11a_0_yAcqCor_w       = 8;
  parameter rx11a_0_yAcqAbs_w       = 8;
  parameter rx11a_0_yAcqPh_w        = 8;
  parameter rx11a_0_ySyncAbs_w      = 10;
  parameter rx11a_0_ySyncC_w        = 26;
  parameter rx11a_0_ySyncSh_w       = 9;
  parameter rx11a_0_yDemD_w         = 11;
  parameter rx11a_0_yDemSb_w        = 22;
  parameter rx11a_0_yDecSb_w        = 8;
  parameter rx11a_0_yDecSb2_w       = 8;
  parameter rx11a_0_yDecVit_w       = 8;

  // Input control lines
  parameter rx11a_0_ssAcqHalt_w     = 1;

  // Output control lines
  parameter rx11a_0_irqDone_w       = 10;
  parameter rx11a_0_ssDetect_w      = 1;

  // Eregs
  parameter rx11a_0_runAcqBuf_w     = 1;
  parameter rx11a_0_runAcqBuf_r     = 0;
  parameter rx11a_0_runAcqBuf_s     = 0;

  // Parameters
  parameter rx11a_0_wx              = 10;
  parameter rx11a_0_wf              = 10;
  parameter rx11a_0_modeSyncFte     = 1;
  parameter rx11a_0_modeSyncFfe     = 2;
  parameter rx11a_0_modeSyncAmpEst  = 3;
  parameter rx11a_0_modeSyncChEst   = 4;
  parameter rx11a_0_modeSyncChCor   = 5;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam rx11a_0.x_w             = rx11a_0_x_w;
  defparam rx11a_0.xFft_w          = rx11a_0_xFft_w;
  defparam rx11a_0.y_w             = rx11a_0_y_w;
  defparam rx11a_0.yFft_w          = rx11a_0_yFft_w;
  defparam rx11a_0.yAcqCor_w       = rx11a_0_yAcqCor_w;
  defparam rx11a_0.yAcqAbs_w       = rx11a_0_yAcqAbs_w;
  defparam rx11a_0.yAcqPh_w        = rx11a_0_yAcqPh_w;
  defparam rx11a_0.ySyncAbs_w      = rx11a_0_ySyncAbs_w;
  defparam rx11a_0.ySyncC_w        = rx11a_0_ySyncC_w;
  defparam rx11a_0.ySyncSh_w       = rx11a_0_ySyncSh_w;
  defparam rx11a_0.yDemD_w         = rx11a_0_yDemD_w;
  defparam rx11a_0.yDemSb_w        = rx11a_0_yDemSb_w;
  defparam rx11a_0.yDecSb_w        = rx11a_0_yDecSb_w;
  defparam rx11a_0.yDecSb2_w       = rx11a_0_yDecSb2_w;
  defparam rx11a_0.yDecVit_w       = rx11a_0_yDecVit_w;
  defparam rx11a_0.ssAcqHalt_w     = rx11a_0_ssAcqHalt_w;
  defparam rx11a_0.irqDone_w       = rx11a_0_irqDone_w;
  defparam rx11a_0.ssDetect_w      = rx11a_0_ssDetect_w;
  defparam rx11a_0.runAcqBuf_w     = rx11a_0_runAcqBuf_w;
  defparam rx11a_0.runAcqBuf_r     = rx11a_0_runAcqBuf_r;
  defparam rx11a_0.runAcqBuf_s     = rx11a_0_runAcqBuf_s;
  defparam rx11a_0.wx              = rx11a_0_wx;
  defparam rx11a_0.wf              = rx11a_0_wf;
  defparam rx11a_0.modeSyncFte     = rx11a_0_modeSyncFte;
  defparam rx11a_0.modeSyncFfe     = rx11a_0_modeSyncFfe;
  defparam rx11a_0.modeSyncAmpEst  = rx11a_0_modeSyncAmpEst;
  defparam rx11a_0.modeSyncChEst   = rx11a_0_modeSyncChEst;
  defparam rx11a_0.modeSyncChCor   = rx11a_0_modeSyncChCor;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_rx11a_0_runAcqBuf                                          = 0;
  defparam  rx11a_0.R_runAcqBuf                                          = R_rx11a_0_runAcqBuf;
  parameter R_rx11a_0_bufNormRot_0_numOut                                = 1;
  defparam  rx11a_0.R_bufNormRot_0_numOut                                = R_rx11a_0_bufNormRot_0_numOut;
  parameter R_rx11a_0_bufNormRot_0_runOut                                = 2;
  defparam  rx11a_0.R_bufNormRot_0_runOut                                = R_rx11a_0_bufNormRot_0_runOut;
  parameter R_rx11a_0_bufNormRot_0_fftWrap                               = 3;
  defparam  rx11a_0.R_bufNormRot_0_fftWrap                               = R_rx11a_0_bufNormRot_0_fftWrap;
  parameter R_rx11a_0_bufNormRot_0_rxBuf_0_wrAdr                         = 4;
  defparam  rx11a_0.R_bufNormRot_0_rxBuf_0_wrAdr                         = R_rx11a_0_bufNormRot_0_rxBuf_0_wrAdr;
  parameter R_rx11a_0_bufNormRot_0_rxBuf_0_rdAdr0                        = 5;
  defparam  rx11a_0.R_bufNormRot_0_rxBuf_0_rdAdr0                        = R_rx11a_0_bufNormRot_0_rxBuf_0_rdAdr0;
  parameter R_rx11a_0_bufNormRot_0_rxBuf_0_irqAdr                        = 6;
  defparam  rx11a_0.R_bufNormRot_0_rxBuf_0_irqAdr                        = R_rx11a_0_bufNormRot_0_rxBuf_0_irqAdr;
  parameter R_rx11a_0_bufNormRot_0_rxBuf_0_agcDoneAdr                    = 7;
  defparam  rx11a_0.R_bufNormRot_0_rxBuf_0_agcDoneAdr                    = R_rx11a_0_bufNormRot_0_rxBuf_0_agcDoneAdr;
  parameter R_rx11a_0_bufNormRot_0_normX_0_amp                           = 8;
  defparam  rx11a_0.R_bufNormRot_0_normX_0_amp                           = R_rx11a_0_bufNormRot_0_normX_0_amp;
  parameter R_rx11a_0_bufNormRot_0_cordicRot_0_ph                        = 9;
  defparam  rx11a_0.R_bufNormRot_0_cordicRot_0_ph                        = R_rx11a_0_bufNormRot_0_cordicRot_0_ph;
  parameter R_rx11a_0_bufNormRot_0_cordicRot_0_dph                       = 10;
  defparam  rx11a_0.R_bufNormRot_0_cordicRot_0_dph                       = R_rx11a_0_bufNormRot_0_cordicRot_0_dph;
  parameter R_rx11a_0_acq11a_0_freqOff                                   = 11;
  defparam  rx11a_0.R_acq11a_0_freqOff                                   = R_rx11a_0_acq11a_0_freqOff;
  parameter R_rx11a_0_acq11a_0_timeOff                                   = 12;
  defparam  rx11a_0.R_acq11a_0_timeOff                                   = R_rx11a_0_acq11a_0_timeOff;
  parameter R_rx11a_0_acq11a_0_ampEst                                    = 13;
  defparam  rx11a_0.R_acq11a_0_ampEst                                    = R_rx11a_0_acq11a_0_ampEst;
  parameter R_rx11a_0_acq11a_0_ssNorm_0_cutN_20c4_numCut                 = 14;
  defparam  rx11a_0.R_acq11a_0_ssNorm_0_cutN_20c4_numCut                 = R_rx11a_0_acq11a_0_ssNorm_0_cutN_20c4_numCut;
  parameter R_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr2                        = 15;
  defparam  rx11a_0.R_acq11a_0_ssCcfAvgDet_0_thr2                        = R_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr2;
  parameter R_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr3                        = 16;
  defparam  rx11a_0.R_acq11a_0_ssCcfAvgDet_0_thr3                        = R_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr3;
  parameter R_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr4                        = 17;
  defparam  rx11a_0.R_acq11a_0_ssCcfAvgDet_0_thr4                        = R_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr4;
  parameter R_rx11a_0_acq11a_0_ctfe_0_ctfeCordic_0_thr                   = 18;
  defparam  rx11a_0.R_acq11a_0_ctfe_0_ctfeCordic_0_thr                   = R_rx11a_0_acq11a_0_ctfe_0_ctfeCordic_0_thr;
  parameter R_rx11a_0_sync11a_0_run1                                     = 19;
  defparam  rx11a_0.R_sync11a_0_run1                                     = R_rx11a_0_sync11a_0_run1;
  parameter R_rx11a_0_sync11a_0_lsCcf_0_peakPos                          = 20;
  defparam  rx11a_0.R_sync11a_0_lsCcf_0_peakPos                          = R_rx11a_0_sync11a_0_lsCcf_0_peakPos;
  parameter R_rx11a_0_sync11a_0_lsCcf_0_peakVal                          = 21;
  defparam  rx11a_0.R_sync11a_0_lsCcf_0_peakVal                          = R_rx11a_0_sync11a_0_lsCcf_0_peakVal;
  parameter R_rx11a_0_sync11a_0_cxMulAvg_0_numSmpl                       = 22;
  defparam  rx11a_0.R_sync11a_0_cxMulAvg_0_numSmpl                       = R_rx11a_0_sync11a_0_cxMulAvg_0_numSmpl;
  parameter R_rx11a_0_sync11a_0_cxMulAvg_0_yReLo                         = 23;
  defparam  rx11a_0.R_sync11a_0_cxMulAvg_0_yReLo                         = R_rx11a_0_sync11a_0_cxMulAvg_0_yReLo;
  parameter R_rx11a_0_sync11a_0_cxMulAvg_0_yImHi                         = 24;
  defparam  rx11a_0.R_sync11a_0_cxMulAvg_0_yImHi                         = R_rx11a_0_sync11a_0_cxMulAvg_0_yImHi;
  parameter R_rx11a_0_dem11a_0_run1                                      = 25;
  defparam  rx11a_0.R_dem11a_0_run1                                      = R_rx11a_0_dem11a_0_run1;
  parameter R_rx11a_0_dem11a_0_ttCordic_0_run1                           = 26;
  defparam  rx11a_0.R_dem11a_0_ttCordic_0_run1                           = R_rx11a_0_dem11a_0_ttCordic_0_run1;
  parameter R_rx11a_0_dem11a_0_ttCordic_0_ph                             = 27;
  defparam  rx11a_0.R_dem11a_0_ttCordic_0_ph                             = R_rx11a_0_dem11a_0_ttCordic_0_ph;
  parameter R_rx11a_0_dem11a_0_ttCordic_0_dph3                           = 28;
  defparam  rx11a_0.R_dem11a_0_ttCordic_0_dph3                           = R_rx11a_0_dem11a_0_ttCordic_0_dph3;
  parameter R_rx11a_0_dem11a_0_ttCordic_0_dph4                           = 29;
  defparam  rx11a_0.R_dem11a_0_ttCordic_0_dph4                           = R_rx11a_0_dem11a_0_ttCordic_0_dph4;
  parameter R_rx11a_0_dem11a_0_ttCordic_0_dphM49                         = 30;
  defparam  rx11a_0.R_dem11a_0_ttCordic_0_dphM49                         = R_rx11a_0_dem11a_0_ttCordic_0_dphM49;
  parameter R_rx11a_0_dem11a_0_ttCordic_0_dph14                          = 31;
  defparam  rx11a_0.R_dem11a_0_ttCordic_0_dph14                          = R_rx11a_0_dem11a_0_ttCordic_0_dph14;
  parameter R_rx11a_0_dem11a_0_pltExt_0_pltSumRe                         = 32;
  defparam  rx11a_0.R_dem11a_0_pltExt_0_pltSumRe                         = R_rx11a_0_dem11a_0_pltExt_0_pltSumRe;
  parameter R_rx11a_0_dem11a_0_pltExt_0_pltSumIm                         = 33;
  defparam  rx11a_0.R_dem11a_0_pltExt_0_pltSumIm                         = R_rx11a_0_dem11a_0_pltExt_0_pltSumIm;
  parameter R_rx11a_0_dec11a_0_run1                                      = 34;
  defparam  rx11a_0.R_dec11a_0_run1                                      = R_rx11a_0_dec11a_0_run1;
  parameter R_rx11a_0_dec11a_0_deIntlv_0_mode1                           = 35;
  defparam  rx11a_0.R_dec11a_0_deIntlv_0_mode1                           = R_rx11a_0_dec11a_0_deIntlv_0_mode1;
  parameter R_rx11a_0_dec11a_0_dePunct_0_run1                            = 36;
  defparam  rx11a_0.R_dec11a_0_dePunct_0_run1                            = R_rx11a_0_dec11a_0_dePunct_0_run1;
  parameter R_rx11a_0_dec11a_0_vitMain_0_run1                            = 37;
  defparam  rx11a_0.R_dec11a_0_vitMain_0_run1                            = R_rx11a_0_dec11a_0_vitMain_0_run1;
  parameter R_rx11a_0_dec11a_0_vitMain_0_numBits                         = 38;
  defparam  rx11a_0.R_dec11a_0_vitMain_0_numBits                         = R_rx11a_0_dec11a_0_vitMain_0_numBits;
  parameter R_rx11a_0_dec11a_0_vitMain_0_rxMode                          = 39;
  defparam  rx11a_0.R_dec11a_0_vitMain_0_rxMode                          = R_rx11a_0_dec11a_0_vitMain_0_rxMode;
  parameter R_rx11a_0_dec11a_0_vitMain_0_rxLen                           = 40;
  defparam  rx11a_0.R_dec11a_0_vitMain_0_rxLen                           = R_rx11a_0_dec11a_0_vitMain_0_rxLen;
  parameter R_rx11a_0_dec11a_0_vitMain_0_pm00                            = 41;
  defparam  rx11a_0.R_dec11a_0_vitMain_0_pm00                            = R_rx11a_0_dec11a_0_vitMain_0_pm00;
  parameter R_rx11a_0_dec11a_0_crc32x8_0_numBytes                        = 42;
  defparam  rx11a_0.R_dec11a_0_crc32x8_0_numBytes                        = R_rx11a_0_dec11a_0_crc32x8_0_numBytes;
  parameter R_rx11a_0_dec11a_0_crc32x8_0_crcRes                          = 43;
  defparam  rx11a_0.R_dec11a_0_crc32x8_0_crcRes                          = R_rx11a_0_dec11a_0_crc32x8_0_crcRes;

  // FIFO address definitions - might be overwritten by an upper module
  parameter R_rx11a_0_acq11a_0_ssNorm_0_ffIn                             = 44;
  defparam  rx11a_0.R_acq11a_0_ssNorm_0_ffIn                             = R_rx11a_0_acq11a_0_ssNorm_0_ffIn;
  parameter R_rx11a_0_dem11a_0_ffIn                                      = 45;
  defparam  rx11a_0.R_dem11a_0_ffIn                                      = R_rx11a_0_dem11a_0_ffIn;
  parameter R_rx11a_0_dec11a_0_ffD2D                                     = 46;
  defparam  rx11a_0.R_dec11a_0_ffD2D                                     = R_rx11a_0_dec11a_0_ffD2D;

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                   [rx11a_0_y_w-1:0]  rx11a_0_y;
  wire                                      rx11a_0_y_or;
  wire                                      rx11a_0_y_ff;
  wire                                      rx11a_0_y_we;

  wire                [rx11a_0_yFft_w-1:0]  rx11a_0_yFft;
  wire                                      rx11a_0_yFft_or;
  wire                                      rx11a_0_yFft_ff;
  wire                                      rx11a_0_yFft_we;

  wire             [rx11a_0_yAcqCor_w-1:0]  rx11a_0_yAcqCor;
  wire                                      rx11a_0_yAcqCor_or;
  wire                                      rx11a_0_yAcqCor_ff;
  wire                                      rx11a_0_yAcqCor_we;

  wire             [rx11a_0_yAcqAbs_w-1:0]  rx11a_0_yAcqAbs;
  wire                                      rx11a_0_yAcqAbs_or;
  wire                                      rx11a_0_yAcqAbs_ff;
  wire                                      rx11a_0_yAcqAbs_we;

  wire              [rx11a_0_yAcqPh_w-1:0]  rx11a_0_yAcqPh;
  wire                                      rx11a_0_yAcqPh_or;
  wire                                      rx11a_0_yAcqPh_ff;
  wire                                      rx11a_0_yAcqPh_we;

  wire            [rx11a_0_ySyncAbs_w-1:0]  rx11a_0_ySyncAbs;
  wire                                      rx11a_0_ySyncAbs_or;
  wire                                      rx11a_0_ySyncAbs_ff;
  wire                                      rx11a_0_ySyncAbs_we;

  wire              [rx11a_0_ySyncC_w-1:0]  rx11a_0_ySyncC;
  wire                                      rx11a_0_ySyncC_or;
  wire                                      rx11a_0_ySyncC_ff;
  wire                                      rx11a_0_ySyncC_we;

  wire             [rx11a_0_ySyncSh_w-1:0]  rx11a_0_ySyncSh;
  wire                                      rx11a_0_ySyncSh_or;
  wire                                      rx11a_0_ySyncSh_ff;
  wire                                      rx11a_0_ySyncSh_we;

  wire               [rx11a_0_yDemD_w-1:0]  rx11a_0_yDemD;
  wire                                      rx11a_0_yDemD_or;
  wire                                      rx11a_0_yDemD_ff;
  wire                                      rx11a_0_yDemD_we;

  wire              [rx11a_0_yDemSb_w-1:0]  rx11a_0_yDemSb;
  wire                                      rx11a_0_yDemSb_or;
  wire                                      rx11a_0_yDemSb_ff;
  wire                                      rx11a_0_yDemSb_we;

  wire              [rx11a_0_yDecSb_w-1:0]  rx11a_0_yDecSb;
  wire                                      rx11a_0_yDecSb_or;
  wire                                      rx11a_0_yDecSb_ff;
  wire                                      rx11a_0_yDecSb_we;

  wire             [rx11a_0_yDecSb2_w-1:0]  rx11a_0_yDecSb2;
  wire                                      rx11a_0_yDecSb2_or;
  wire                                      rx11a_0_yDecSb2_ff;
  wire                                      rx11a_0_yDecSb2_we;

  wire             [rx11a_0_yDecVit_w-1:0]  rx11a_0_yDecVit;
  wire                                      rx11a_0_yDecVit_or;
  wire                                      rx11a_0_yDecVit_ff;
  wire                                      rx11a_0_yDecVit_we;

  wire                   [rx11a_0_x_w-1:0]  rx11a_0_x;
  wire                                      rx11a_0_x_ir;
  wire                                      rx11a_0_x_fe;
  wire                                      rx11a_0_x_re;

  wire                [rx11a_0_xFft_w-1:0]  rx11a_0_xFft;
  wire                                      rx11a_0_xFft_ir;
  wire                                      rx11a_0_xFft_fe;
  wire                                      rx11a_0_xFft_re;

  wire             [rx11a_0_irqDone_w-1:0]  rx11a_0_irqDone;
  wire            [rx11a_0_ssDetect_w-1:0]  rx11a_0_ssDetect;

  wire           [rx11a_0_ssAcqHalt_w-1:0]  rx11a_0_ssAcqHalt;

  wire                                      rx11a_0_regWe;
  wire                                      rx11a_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  rx11a rx11a_0(rx11a_0_y, rx11a_0_y_or, rx11a_0_y_ff, rx11a_0_y_we,
                rx11a_0_yFft, rx11a_0_yFft_or, rx11a_0_yFft_ff, rx11a_0_yFft_we,
                rx11a_0_yAcqCor, rx11a_0_yAcqCor_or, rx11a_0_yAcqCor_ff, rx11a_0_yAcqCor_we,
                rx11a_0_yAcqAbs, rx11a_0_yAcqAbs_or, rx11a_0_yAcqAbs_ff, rx11a_0_yAcqAbs_we,
                rx11a_0_yAcqPh, rx11a_0_yAcqPh_or, rx11a_0_yAcqPh_ff, rx11a_0_yAcqPh_we,
                rx11a_0_ySyncAbs, rx11a_0_ySyncAbs_or, rx11a_0_ySyncAbs_ff, rx11a_0_ySyncAbs_we,
                rx11a_0_ySyncC, rx11a_0_ySyncC_or, rx11a_0_ySyncC_ff, rx11a_0_ySyncC_we,
                rx11a_0_ySyncSh, rx11a_0_ySyncSh_or, rx11a_0_ySyncSh_ff, rx11a_0_ySyncSh_we,
                rx11a_0_yDemD, rx11a_0_yDemD_or, rx11a_0_yDemD_ff, rx11a_0_yDemD_we,
                rx11a_0_yDemSb, rx11a_0_yDemSb_or, rx11a_0_yDemSb_ff, rx11a_0_yDemSb_we,
                rx11a_0_yDecSb, rx11a_0_yDecSb_or, rx11a_0_yDecSb_ff, rx11a_0_yDecSb_we,
                rx11a_0_yDecSb2, rx11a_0_yDecSb2_or, rx11a_0_yDecSb2_ff, rx11a_0_yDecSb2_we,
                rx11a_0_yDecVit, rx11a_0_yDecVit_or, rx11a_0_yDecVit_ff, rx11a_0_yDecVit_we,
                rx11a_0_x, rx11a_0_x_ir, rx11a_0_x_fe, rx11a_0_x_re, 
                rx11a_0_xFft, rx11a_0_xFft_ir, rx11a_0_xFft_fe, rx11a_0_xFft_re, 
                rx11a_0_irqDone, 
                rx11a_0_ssDetect, 
                rx11a_0_ssAcqHalt, 
                regBus, regWe, regRe, rx11a_0_regWe, rx11a_0_regRe, clk, clk2, reset);


//==============================================================================
