//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter rtx80_0_xTx20_w         = 20;
  parameter rtx80_0_xRx80_w         = 24;
  parameter rtx80_0_attnDb_w        = 7;

  // Outputs
  parameter rtx80_0_yRx20_w         = 20;
  parameter rtx80_0_yTx80_w         = 24;
  parameter rtx80_0_y40_w           = 28;

  // Input control lines

  // Output control lines

  // Eregs
  parameter rtx80_0_run1_w          = 2;
  parameter rtx80_0_run1_r          = 0;
  parameter rtx80_0_run1_s          = 0;

  // Parameters
  parameter rtx80_0_w               = 12;
  parameter rtx80_0_wx              = 10;
  parameter rtx80_0_wy              = 10;
  parameter rtx80_0_we              = 2;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam rtx80_0.xTx20_w         = rtx80_0_xTx20_w;
  defparam rtx80_0.xRx80_w         = rtx80_0_xRx80_w;
  defparam rtx80_0.attnDb_w        = rtx80_0_attnDb_w;
  defparam rtx80_0.yRx20_w         = rtx80_0_yRx20_w;
  defparam rtx80_0.yTx80_w         = rtx80_0_yTx80_w;
  defparam rtx80_0.y40_w           = rtx80_0_y40_w;
  defparam rtx80_0.run1_w          = rtx80_0_run1_w;
  defparam rtx80_0.run1_r          = rtx80_0_run1_r;
  defparam rtx80_0.run1_s          = rtx80_0_run1_s;
  defparam rtx80_0.w               = rtx80_0_w;
  defparam rtx80_0.wx              = rtx80_0_wx;
  defparam rtx80_0.wy              = rtx80_0_wy;
  defparam rtx80_0.we              = rtx80_0_we;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_rtx80_0_run1                                               = 0;
  defparam  rtx80_0.R_run1                                               = R_rtx80_0_run1;
  parameter R_rtx80_0_scaleTx_0_scFac                                    = 1;
  defparam  rtx80_0.R_scaleTx_0_scFac                                    = R_rtx80_0_scaleTx_0_scFac;
  parameter R_rtx80_0_wdfSrc_0_cLo1                                      = 2;
  defparam  rtx80_0.R_wdfSrc_0_cLo1                                      = R_rtx80_0_wdfSrc_0_cLo1;
  parameter R_rtx80_0_wdfSrc_0_cLo2                                      = 3;
  defparam  rtx80_0.R_wdfSrc_0_cLo2                                      = R_rtx80_0_wdfSrc_0_cLo2;
  parameter R_rtx80_0_wdfSrc_0_cLo3                                      = 4;
  defparam  rtx80_0.R_wdfSrc_0_cLo3                                      = R_rtx80_0_wdfSrc_0_cLo3;
  parameter R_rtx80_0_wdfSrc_0_cLo4                                      = 5;
  defparam  rtx80_0.R_wdfSrc_0_cLo4                                      = R_rtx80_0_wdfSrc_0_cLo4;
  parameter R_rtx80_0_wdfSrc_0_cHi1                                      = 6;
  defparam  rtx80_0.R_wdfSrc_0_cHi1                                      = R_rtx80_0_wdfSrc_0_cHi1;
  parameter R_rtx80_0_wdfSrc_0_cHi2                                      = 7;
  defparam  rtx80_0.R_wdfSrc_0_cHi2                                      = R_rtx80_0_wdfSrc_0_cHi2;
  parameter R_rtx80_0_wdfSrc_0_singleAdc                                 = 8;
  defparam  rtx80_0.R_wdfSrc_0_singleAdc                                 = R_rtx80_0_wdfSrc_0_singleAdc;
  parameter R_rtx80_0_freqShift_0_fShBr                                  = 9;
  defparam  rtx80_0.R_freqShift_0_fShBr                                  = R_rtx80_0_freqShift_0_fShBr;
  parameter R_rtx80_0_dcOffCorr_0_corrOn                                 = 10;
  defparam  rtx80_0.R_dcOffCorr_0_corrOn                                 = R_rtx80_0_dcOffCorr_0_corrOn;
  parameter R_rtx80_0_dcOffCorr_0_txDcOffRe                              = 11;
  defparam  rtx80_0.R_dcOffCorr_0_txDcOffRe                              = R_rtx80_0_dcOffCorr_0_txDcOffRe;
  parameter R_rtx80_0_dcOffCorr_0_txDcOffIm                              = 12;
  defparam  rtx80_0.R_dcOffCorr_0_txDcOffIm                              = R_rtx80_0_dcOffCorr_0_txDcOffIm;
  parameter R_rtx80_0_dcOffCorr_0_lut_rxDcOff_wrAdr                      = 13;
  defparam  rtx80_0.R_dcOffCorr_0_lut_rxDcOff_wrAdr                      = R_rtx80_0_dcOffCorr_0_lut_rxDcOff_wrAdr;
  parameter R_rtx80_0_dcOffCorr_0_lut_rxDcOff_wrDatHi                    = 14;
  defparam  rtx80_0.R_dcOffCorr_0_lut_rxDcOff_wrDatHi                    = R_rtx80_0_dcOffCorr_0_lut_rxDcOff_wrDatHi;
  parameter R_rtx80_0_dcOffCorr_0_lut_rxDcOff_wrDatLo                    = 15;
  defparam  rtx80_0.R_dcOffCorr_0_lut_rxDcOff_wrDatLo                    = R_rtx80_0_dcOffCorr_0_lut_rxDcOff_wrDatLo;
  parameter R_rtx80_0_dcOffCorr_0_lut_rxDcOff_simInit                    = 16;
  defparam  rtx80_0.R_dcOffCorr_0_lut_rxDcOff_simInit                    = R_rtx80_0_dcOffCorr_0_lut_rxDcOff_simInit;
  parameter R_rtx80_0_iqBuf_0_swSel                                      = 17;
  defparam  rtx80_0.R_iqBuf_0_swSel                                      = R_rtx80_0_iqBuf_0_swSel;
  parameter R_rtx80_0_iqBuf_0_dataBufX32_iqBuf_run1                      = 18;
  defparam  rtx80_0.R_iqBuf_0_dataBufX32_iqBuf_run1                      = R_rtx80_0_iqBuf_0_dataBufX32_iqBuf_run1;
  parameter R_rtx80_0_iqBuf_0_dataBufX32_iqBuf_datAdr                    = 19;
  defparam  rtx80_0.R_iqBuf_0_dataBufX32_iqBuf_datAdr                    = R_rtx80_0_iqBuf_0_dataBufX32_iqBuf_datAdr;
  parameter R_rtx80_0_iqBuf_0_dataBufX32_iqBuf_datValLo                  = 20;
  defparam  rtx80_0.R_iqBuf_0_dataBufX32_iqBuf_datValLo                  = R_rtx80_0_iqBuf_0_dataBufX32_iqBuf_datValLo;
  parameter R_rtx80_0_iqBuf_0_dataBufX32_iqBuf_datValHi                  = 21;
  defparam  rtx80_0.R_iqBuf_0_dataBufX32_iqBuf_datValHi                  = R_rtx80_0_iqBuf_0_dataBufX32_iqBuf_datValHi;
  parameter R_rtx80_0_iqBuf_0_thrPass_0_run1                             = 22;
  defparam  rtx80_0.R_iqBuf_0_thrPass_0_run1                             = R_rtx80_0_iqBuf_0_thrPass_0_run1;
  parameter R_rtx80_0_iqBuf_0_thrPass_0_thr                              = 23;
  defparam  rtx80_0.R_iqBuf_0_thrPass_0_thr                              = R_rtx80_0_iqBuf_0_thrPass_0_thr;
  parameter R_rtx80_0_iqBuf_0_thrPass_0_trig                             = 24;
  defparam  rtx80_0.R_iqBuf_0_thrPass_0_trig                             = R_rtx80_0_iqBuf_0_thrPass_0_trig;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [rtx80_0_yRx20_w-1:0]  rtx80_0_yRx20;
  wire                                      rtx80_0_yRx20_or;
  wire                                      rtx80_0_yRx20_ff;
  wire                                      rtx80_0_yRx20_we;

  wire               [rtx80_0_yTx80_w-1:0]  rtx80_0_yTx80;
  wire                                      rtx80_0_yTx80_or;
  wire                                      rtx80_0_yTx80_ff;
  wire                                      rtx80_0_yTx80_we;

  wire                 [rtx80_0_y40_w-1:0]  rtx80_0_y40;
  wire                                      rtx80_0_y40_or;
  wire                                      rtx80_0_y40_ff;
  wire                                      rtx80_0_y40_we;

  wire               [rtx80_0_xTx20_w-1:0]  rtx80_0_xTx20;
  wire                                      rtx80_0_xTx20_ir;
  wire                                      rtx80_0_xTx20_fe;
  wire                                      rtx80_0_xTx20_re;

  wire               [rtx80_0_xRx80_w-1:0]  rtx80_0_xRx80;
  wire                                      rtx80_0_xRx80_ir;
  wire                                      rtx80_0_xRx80_fe;
  wire                                      rtx80_0_xRx80_re;

  wire              [rtx80_0_attnDb_w-1:0]  rtx80_0_attnDb;
  wire                                      rtx80_0_attnDb_ir;
  wire                                      rtx80_0_attnDb_fe;
  wire                                      rtx80_0_attnDb_re;

  wire                                      rtx80_0_regWe;
  wire                                      rtx80_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  rtx80 rtx80_0(rtx80_0_yRx20, rtx80_0_yRx20_or, rtx80_0_yRx20_ff, rtx80_0_yRx20_we,
                rtx80_0_yTx80, rtx80_0_yTx80_or, rtx80_0_yTx80_ff, rtx80_0_yTx80_we,
                rtx80_0_y40, rtx80_0_y40_or, rtx80_0_y40_ff, rtx80_0_y40_we,
                rtx80_0_xTx20, rtx80_0_xTx20_ir, rtx80_0_xTx20_fe, rtx80_0_xTx20_re, 
                rtx80_0_xRx80, rtx80_0_xRx80_ir, rtx80_0_xRx80_fe, rtx80_0_xRx80_re, 
                rtx80_0_attnDb, rtx80_0_attnDb_ir, rtx80_0_attnDb_fe, rtx80_0_attnDb_re, 
                regBus, regWe, regRe, rtx80_0_regWe, rtx80_0_regRe, clk, clk2, reset);


//==============================================================================
