//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter ppdu11b_0_x_w             = 1;

  // Outputs
  parameter ppdu11b_0_y_w             = 1;

  // Input control lines
  parameter ppdu11b_0_run1_w          = 1;

  // Output control lines

  // Eregs
  parameter ppdu11b_0_header_w        = 1;
  parameter ppdu11b_0_header_r        = 0;
  parameter ppdu11b_0_header_s        = 0;
  parameter ppdu11b_0_sfd_w           = 16;
  parameter ppdu11b_0_sfd_r           = 0;
  parameter ppdu11b_0_sfd_s           = 0;
  parameter ppdu11b_0_sigser_w        = 16;
  parameter ppdu11b_0_sigser_r        = 0;
  parameter ppdu11b_0_sigser_s        = 0;
  parameter ppdu11b_0_len_w           = 16;
  parameter ppdu11b_0_len_r           = 0;
  parameter ppdu11b_0_len_s           = 0;
  parameter ppdu11b_0_crc_w           = 16;
  parameter ppdu11b_0_crc_r           = 0;
  parameter ppdu11b_0_crc_s           = 0;
  parameter ppdu11b_0_numBits_w       = 15;
  parameter ppdu11b_0_numBits_r       = 0;
  parameter ppdu11b_0_numBits_s       = 0;

  // Parameters

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam ppdu11b_0.x_w             = ppdu11b_0_x_w;
  defparam ppdu11b_0.y_w             = ppdu11b_0_y_w;
  defparam ppdu11b_0.run1_w          = ppdu11b_0_run1_w;
  defparam ppdu11b_0.header_w        = ppdu11b_0_header_w;
  defparam ppdu11b_0.header_r        = ppdu11b_0_header_r;
  defparam ppdu11b_0.header_s        = ppdu11b_0_header_s;
  defparam ppdu11b_0.sfd_w           = ppdu11b_0_sfd_w;
  defparam ppdu11b_0.sfd_r           = ppdu11b_0_sfd_r;
  defparam ppdu11b_0.sfd_s           = ppdu11b_0_sfd_s;
  defparam ppdu11b_0.sigser_w        = ppdu11b_0_sigser_w;
  defparam ppdu11b_0.sigser_r        = ppdu11b_0_sigser_r;
  defparam ppdu11b_0.sigser_s        = ppdu11b_0_sigser_s;
  defparam ppdu11b_0.len_w           = ppdu11b_0_len_w;
  defparam ppdu11b_0.len_r           = ppdu11b_0_len_r;
  defparam ppdu11b_0.len_s           = ppdu11b_0_len_s;
  defparam ppdu11b_0.crc_w           = ppdu11b_0_crc_w;
  defparam ppdu11b_0.crc_r           = ppdu11b_0_crc_r;
  defparam ppdu11b_0.crc_s           = ppdu11b_0_crc_s;
  defparam ppdu11b_0.numBits_w       = ppdu11b_0_numBits_w;
  defparam ppdu11b_0.numBits_r       = ppdu11b_0_numBits_r;
  defparam ppdu11b_0.numBits_s       = ppdu11b_0_numBits_s;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_ppdu11b_0_header                                           = 0;
  defparam  ppdu11b_0.R_header                                           = R_ppdu11b_0_header;
  parameter R_ppdu11b_0_sfd                                              = 1;
  defparam  ppdu11b_0.R_sfd                                              = R_ppdu11b_0_sfd;
  parameter R_ppdu11b_0_sigser                                           = 2;
  defparam  ppdu11b_0.R_sigser                                           = R_ppdu11b_0_sigser;
  parameter R_ppdu11b_0_len                                              = 3;
  defparam  ppdu11b_0.R_len                                              = R_ppdu11b_0_len;
  parameter R_ppdu11b_0_crc                                              = 4;
  defparam  ppdu11b_0.R_crc                                              = R_ppdu11b_0_crc;
  parameter R_ppdu11b_0_numBits                                          = 5;
  defparam  ppdu11b_0.R_numBits                                          = R_ppdu11b_0_numBits;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                 [ppdu11b_0_y_w-1:0]  ppdu11b_0_y;
  wire                                      ppdu11b_0_y_or;
  wire                                      ppdu11b_0_y_ff;
  wire                                      ppdu11b_0_y_we;

  wire                 [ppdu11b_0_x_w-1:0]  ppdu11b_0_x;
  wire                                      ppdu11b_0_x_ir;
  wire                                      ppdu11b_0_x_fe;
  wire                                      ppdu11b_0_x_re;

  wire              [ppdu11b_0_run1_w-1:0]  ppdu11b_0_run1;

  wire                                      ppdu11b_0_regWe;
  wire                                      ppdu11b_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  ppdu11b ppdu11b_0(ppdu11b_0_y, ppdu11b_0_y_or, ppdu11b_0_y_ff, ppdu11b_0_y_we,
                    ppdu11b_0_x, ppdu11b_0_x_ir, ppdu11b_0_x_fe, ppdu11b_0_x_re, 
                    ppdu11b_0_run1, 
                    regBus, regWe, regRe, ppdu11b_0_regWe, ppdu11b_0_regRe, clk, clk2, reset);


//==============================================================================
