//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter normXDivCore_re5_nIn_w           = 11;
  parameter normXDivCore_re5_qIn_w           = 9;
  parameter normXDivCore_re5_dIn_w           = 8;

  // Outputs
  parameter normXDivCore_re5_nOut_w          = 11;
  parameter normXDivCore_re5_qOut_w          = 9;

  // Input control lines

  // Output control lines

  // Eregs

  // Parameters
  parameter normXDivCore_re5_wn              = 11;
  parameter normXDivCore_re5_wd              = 8;
  parameter normXDivCore_re5_wq              = 9;
  parameter normXDivCore_re5_ws              = 2;
  parameter normXDivCore_re5_wy              = 10;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam normXDivCore_re5.nIn_w           = normXDivCore_re5_nIn_w;
  defparam normXDivCore_re5.qIn_w           = normXDivCore_re5_qIn_w;
  defparam normXDivCore_re5.dIn_w           = normXDivCore_re5_dIn_w;
  defparam normXDivCore_re5.nOut_w          = normXDivCore_re5_nOut_w;
  defparam normXDivCore_re5.qOut_w          = normXDivCore_re5_qOut_w;
  defparam normXDivCore_re5.wn              = normXDivCore_re5_wn;
  defparam normXDivCore_re5.wd              = normXDivCore_re5_wd;
  defparam normXDivCore_re5.wq              = normXDivCore_re5_wq;
  defparam normXDivCore_re5.ws              = normXDivCore_re5_ws;
  defparam normXDivCore_re5.wy              = normXDivCore_re5_wy;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire       [normXDivCore_re5_nOut_w-1:0]  normXDivCore_re5_nOut;
  wire                                      normXDivCore_re5_nOut_or;
  wire                                      normXDivCore_re5_nOut_ff;
  wire                                      normXDivCore_re5_nOut_we;

  wire       [normXDivCore_re5_qOut_w-1:0]  normXDivCore_re5_qOut;
  wire                                      normXDivCore_re5_qOut_or;
  wire                                      normXDivCore_re5_qOut_ff;
  wire                                      normXDivCore_re5_qOut_we;

  wire        [normXDivCore_re5_nIn_w-1:0]  normXDivCore_re5_nIn;
  wire                                      normXDivCore_re5_nIn_ir;
  wire                                      normXDivCore_re5_nIn_fe;
  wire                                      normXDivCore_re5_nIn_re;

  wire        [normXDivCore_re5_qIn_w-1:0]  normXDivCore_re5_qIn;
  wire                                      normXDivCore_re5_qIn_ir;
  wire                                      normXDivCore_re5_qIn_fe;
  wire                                      normXDivCore_re5_qIn_re;

  wire        [normXDivCore_re5_dIn_w-1:0]  normXDivCore_re5_dIn;
  wire                                      normXDivCore_re5_dIn_ir;
  wire                                      normXDivCore_re5_dIn_fe;
  wire                                      normXDivCore_re5_dIn_re;

  wire                                      normXDivCore_re5_regWe;
  wire                                      normXDivCore_re5_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  normXDivCore normXDivCore_re5(normXDivCore_re5_nOut, normXDivCore_re5_nOut_or, normXDivCore_re5_nOut_ff, normXDivCore_re5_nOut_we,
                                normXDivCore_re5_qOut, normXDivCore_re5_qOut_or, normXDivCore_re5_qOut_ff, normXDivCore_re5_qOut_we,
                                normXDivCore_re5_nIn, normXDivCore_re5_nIn_ir, normXDivCore_re5_nIn_fe, normXDivCore_re5_nIn_re, 
                                normXDivCore_re5_qIn, normXDivCore_re5_qIn_ir, normXDivCore_re5_qIn_fe, normXDivCore_re5_qIn_re, 
                                normXDivCore_re5_dIn, normXDivCore_re5_dIn_ir, normXDivCore_re5_dIn_fe, normXDivCore_re5_dIn_re, 
                                regBus, regWe, regRe, normXDivCore_re5_regWe, normXDivCore_re5_regRe, clk, clk2, reset);


//==============================================================================
