//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter normXDivCore_re2_nIn_w           = 11;
  parameter normXDivCore_re2_qIn_w           = 9;
  parameter normXDivCore_re2_dIn_w           = 8;

  // Outputs
  parameter normXDivCore_re2_nOut_w          = 11;
  parameter normXDivCore_re2_qOut_w          = 9;

  // Input control lines

  // Output control lines

  // Eregs

  // Parameters
  parameter normXDivCore_re2_wn              = 11;
  parameter normXDivCore_re2_wd              = 8;
  parameter normXDivCore_re2_wq              = 9;
  parameter normXDivCore_re2_ws              = 2;
  parameter normXDivCore_re2_wy              = 10;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam normXDivCore_re2.nIn_w           = normXDivCore_re2_nIn_w;
  defparam normXDivCore_re2.qIn_w           = normXDivCore_re2_qIn_w;
  defparam normXDivCore_re2.dIn_w           = normXDivCore_re2_dIn_w;
  defparam normXDivCore_re2.nOut_w          = normXDivCore_re2_nOut_w;
  defparam normXDivCore_re2.qOut_w          = normXDivCore_re2_qOut_w;
  defparam normXDivCore_re2.wn              = normXDivCore_re2_wn;
  defparam normXDivCore_re2.wd              = normXDivCore_re2_wd;
  defparam normXDivCore_re2.wq              = normXDivCore_re2_wq;
  defparam normXDivCore_re2.ws              = normXDivCore_re2_ws;
  defparam normXDivCore_re2.wy              = normXDivCore_re2_wy;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire       [normXDivCore_re2_nOut_w-1:0]  normXDivCore_re2_nOut;
  wire                                      normXDivCore_re2_nOut_or;
  wire                                      normXDivCore_re2_nOut_ff;
  wire                                      normXDivCore_re2_nOut_we;

  wire       [normXDivCore_re2_qOut_w-1:0]  normXDivCore_re2_qOut;
  wire                                      normXDivCore_re2_qOut_or;
  wire                                      normXDivCore_re2_qOut_ff;
  wire                                      normXDivCore_re2_qOut_we;

  wire        [normXDivCore_re2_nIn_w-1:0]  normXDivCore_re2_nIn;
  wire                                      normXDivCore_re2_nIn_ir;
  wire                                      normXDivCore_re2_nIn_fe;
  wire                                      normXDivCore_re2_nIn_re;

  wire        [normXDivCore_re2_qIn_w-1:0]  normXDivCore_re2_qIn;
  wire                                      normXDivCore_re2_qIn_ir;
  wire                                      normXDivCore_re2_qIn_fe;
  wire                                      normXDivCore_re2_qIn_re;

  wire        [normXDivCore_re2_dIn_w-1:0]  normXDivCore_re2_dIn;
  wire                                      normXDivCore_re2_dIn_ir;
  wire                                      normXDivCore_re2_dIn_fe;
  wire                                      normXDivCore_re2_dIn_re;

  wire                                      normXDivCore_re2_regWe;
  wire                                      normXDivCore_re2_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  normXDivCore normXDivCore_re2(normXDivCore_re2_nOut, normXDivCore_re2_nOut_or, normXDivCore_re2_nOut_ff, normXDivCore_re2_nOut_we,
                                normXDivCore_re2_qOut, normXDivCore_re2_qOut_or, normXDivCore_re2_qOut_ff, normXDivCore_re2_qOut_we,
                                normXDivCore_re2_nIn, normXDivCore_re2_nIn_ir, normXDivCore_re2_nIn_fe, normXDivCore_re2_nIn_re, 
                                normXDivCore_re2_qIn, normXDivCore_re2_qIn_ir, normXDivCore_re2_qIn_fe, normXDivCore_re2_qIn_re, 
                                normXDivCore_re2_dIn, normXDivCore_re2_dIn_ir, normXDivCore_re2_dIn_fe, normXDivCore_re2_dIn_re, 
                                regBus, regWe, regRe, normXDivCore_re2_regWe, normXDivCore_re2_regRe, clk, clk2, reset);


//==============================================================================
