//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter normXDivCore_im2_nIn_w           = 11;
  parameter normXDivCore_im2_qIn_w           = 9;
  parameter normXDivCore_im2_dIn_w           = 8;

  // Outputs
  parameter normXDivCore_im2_nOut_w          = 11;
  parameter normXDivCore_im2_qOut_w          = 9;

  // Input control lines

  // Output control lines

  // Eregs

  // Parameters
  parameter normXDivCore_im2_wn              = 11;
  parameter normXDivCore_im2_wd              = 8;
  parameter normXDivCore_im2_wq              = 9;
  parameter normXDivCore_im2_ws              = 2;
  parameter normXDivCore_im2_wy              = 10;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam normXDivCore_im2.nIn_w           = normXDivCore_im2_nIn_w;
  defparam normXDivCore_im2.qIn_w           = normXDivCore_im2_qIn_w;
  defparam normXDivCore_im2.dIn_w           = normXDivCore_im2_dIn_w;
  defparam normXDivCore_im2.nOut_w          = normXDivCore_im2_nOut_w;
  defparam normXDivCore_im2.qOut_w          = normXDivCore_im2_qOut_w;
  defparam normXDivCore_im2.wn              = normXDivCore_im2_wn;
  defparam normXDivCore_im2.wd              = normXDivCore_im2_wd;
  defparam normXDivCore_im2.wq              = normXDivCore_im2_wq;
  defparam normXDivCore_im2.ws              = normXDivCore_im2_ws;
  defparam normXDivCore_im2.wy              = normXDivCore_im2_wy;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire       [normXDivCore_im2_nOut_w-1:0]  normXDivCore_im2_nOut;
  wire                                      normXDivCore_im2_nOut_or;
  wire                                      normXDivCore_im2_nOut_ff;
  wire                                      normXDivCore_im2_nOut_we;

  wire       [normXDivCore_im2_qOut_w-1:0]  normXDivCore_im2_qOut;
  wire                                      normXDivCore_im2_qOut_or;
  wire                                      normXDivCore_im2_qOut_ff;
  wire                                      normXDivCore_im2_qOut_we;

  wire        [normXDivCore_im2_nIn_w-1:0]  normXDivCore_im2_nIn;
  wire                                      normXDivCore_im2_nIn_ir;
  wire                                      normXDivCore_im2_nIn_fe;
  wire                                      normXDivCore_im2_nIn_re;

  wire        [normXDivCore_im2_qIn_w-1:0]  normXDivCore_im2_qIn;
  wire                                      normXDivCore_im2_qIn_ir;
  wire                                      normXDivCore_im2_qIn_fe;
  wire                                      normXDivCore_im2_qIn_re;

  wire        [normXDivCore_im2_dIn_w-1:0]  normXDivCore_im2_dIn;
  wire                                      normXDivCore_im2_dIn_ir;
  wire                                      normXDivCore_im2_dIn_fe;
  wire                                      normXDivCore_im2_dIn_re;

  wire                                      normXDivCore_im2_regWe;
  wire                                      normXDivCore_im2_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  normXDivCore normXDivCore_im2(normXDivCore_im2_nOut, normXDivCore_im2_nOut_or, normXDivCore_im2_nOut_ff, normXDivCore_im2_nOut_we,
                                normXDivCore_im2_qOut, normXDivCore_im2_qOut_or, normXDivCore_im2_qOut_ff, normXDivCore_im2_qOut_we,
                                normXDivCore_im2_nIn, normXDivCore_im2_nIn_ir, normXDivCore_im2_nIn_fe, normXDivCore_im2_nIn_re, 
                                normXDivCore_im2_qIn, normXDivCore_im2_qIn_ir, normXDivCore_im2_qIn_fe, normXDivCore_im2_qIn_re, 
                                normXDivCore_im2_dIn, normXDivCore_im2_dIn_ir, normXDivCore_im2_dIn_fe, normXDivCore_im2_dIn_re, 
                                regBus, regWe, regRe, normXDivCore_im2_regWe, normXDivCore_im2_regRe, clk, clk2, reset);


//==============================================================================
