//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter mod11b_0_x_w             = 1;

  // Outputs
  parameter mod11b_0_y_w             = 4;

  // Input control lines
  parameter mod11b_0_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam mod11b_0.x_w             = mod11b_0_x_w;
  defparam mod11b_0.y_w             = mod11b_0_y_w;
  defparam mod11b_0.run1_w          = mod11b_0_run1_w;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_mod11b_0_mod11bBpsk_0_numBits                              = 0;
  defparam  mod11b_0.R_mod11bBpsk_0_numBits                              = R_mod11b_0_mod11bBpsk_0_numBits;
  parameter R_mod11b_0_mod11bQpsk_0_numBits                              = 1;
  defparam  mod11b_0.R_mod11bQpsk_0_numBits                              = R_mod11b_0_mod11bQpsk_0_numBits;
  parameter R_mod11b_0_mod11bCck_0_numBits                               = 2;
  defparam  mod11b_0.R_mod11bCck_0_numBits                               = R_mod11b_0_mod11bCck_0_numBits;
  parameter R_mod11b_0_mod11bCck_0_mode1                                 = 3;
  defparam  mod11b_0.R_mod11bCck_0_mode1                                 = R_mod11b_0_mod11bCck_0_mode1;
  parameter R_mod11b_0_modQpskZero_0_numZeros                            = 4;
  defparam  mod11b_0.R_modQpskZero_0_numZeros                            = R_mod11b_0_modQpskZero_0_numZeros;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                  [mod11b_0_y_w-1:0]  mod11b_0_y;
  wire                                      mod11b_0_y_or;
  wire                                      mod11b_0_y_ff;
  wire                                      mod11b_0_y_we;

  wire                  [mod11b_0_x_w-1:0]  mod11b_0_x;
  wire                                      mod11b_0_x_ir;
  wire                                      mod11b_0_x_fe;
  wire                                      mod11b_0_x_re;

  wire               [mod11b_0_run1_w-1:0]  mod11b_0_run1;

  wire                                      mod11b_0_regWe;
  wire                                      mod11b_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  mod11b mod11b_0(mod11b_0_y, mod11b_0_y_or, mod11b_0_y_ff, mod11b_0_y_we,
                  mod11b_0_x, mod11b_0_x_ir, mod11b_0_x_fe, mod11b_0_x_re, 
                  mod11b_0_run1, 
                  regBus, regWe, regRe, mod11b_0_regWe, mod11b_0_regRe, clk, clk2, reset);


//==============================================================================
