//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter mod11bCck_0_x_w             = 1;

  // Outputs
  parameter mod11bCck_0_y_w             = 2;

  // Input control lines
  parameter mod11bCck_0_run1_w          = 1;
  parameter mod11bCck_0_phIn_w          = 2;

  // Output control lines
  parameter mod11bCck_0_runZeros_w      = 1;

  // Eregs
  parameter mod11bCck_0_numBits_w       = 16;
  parameter mod11bCck_0_numBits_r       = 0;
  parameter mod11bCck_0_numBits_s       = 0;
  parameter mod11bCck_0_mode1_w         = 1;
  parameter mod11bCck_0_mode1_r         = 0;
  parameter mod11bCck_0_mode1_s         = 0;

  // Parameters

  // Iregs
  parameter mod11bCck_0_ph_w            = 2;
  parameter mod11bCck_0_ph_n            = 1;
  parameter mod11bCck_0_ph_m            = `CLOG2(1);
  parameter mod11bCck_0_cntBits_w       = 16;
  parameter mod11bCck_0_cntBits_n       = 1;
  parameter mod11bCck_0_cntBits_m       = `CLOG2(1);
  parameter mod11bCck_0_tph_w           = 1;
  parameter mod11bCck_0_tph_n           = 1;
  parameter mod11bCck_0_tph_m           = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam mod11bCck_0.x_w             = mod11bCck_0_x_w;
  defparam mod11bCck_0.y_w             = mod11bCck_0_y_w;
  defparam mod11bCck_0.run1_w          = mod11bCck_0_run1_w;
  defparam mod11bCck_0.phIn_w          = mod11bCck_0_phIn_w;
  defparam mod11bCck_0.runZeros_w      = mod11bCck_0_runZeros_w;
  defparam mod11bCck_0.numBits_w       = mod11bCck_0_numBits_w;
  defparam mod11bCck_0.numBits_r       = mod11bCck_0_numBits_r;
  defparam mod11bCck_0.numBits_s       = mod11bCck_0_numBits_s;
  defparam mod11bCck_0.mode1_w         = mod11bCck_0_mode1_w;
  defparam mod11bCck_0.mode1_r         = mod11bCck_0_mode1_r;
  defparam mod11bCck_0.mode1_s         = mod11bCck_0_mode1_s;
  defparam mod11bCck_0.ph_w            = mod11bCck_0_ph_w;
  defparam mod11bCck_0.ph_n            = mod11bCck_0_ph_n;
  defparam mod11bCck_0.ph_m            = mod11bCck_0_ph_m;
  defparam mod11bCck_0.cntBits_w       = mod11bCck_0_cntBits_w;
  defparam mod11bCck_0.cntBits_n       = mod11bCck_0_cntBits_n;
  defparam mod11bCck_0.cntBits_m       = mod11bCck_0_cntBits_m;
  defparam mod11bCck_0.tph_w           = mod11bCck_0_tph_w;
  defparam mod11bCck_0.tph_n           = mod11bCck_0_tph_n;
  defparam mod11bCck_0.tph_m           = mod11bCck_0_tph_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_mod11bCck_0_numBits                                        = 0;
  defparam  mod11bCck_0.R_numBits                                        = R_mod11bCck_0_numBits;
  parameter R_mod11bCck_0_mode1                                          = 1;
  defparam  mod11bCck_0.R_mode1                                          = R_mod11bCck_0_mode1;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [mod11bCck_0_y_w-1:0]  mod11bCck_0_y;
  wire                                      mod11bCck_0_y_or;
  wire                                      mod11bCck_0_y_ff;
  wire                                      mod11bCck_0_y_we;

  wire               [mod11bCck_0_x_w-1:0]  mod11bCck_0_x;
  wire                                      mod11bCck_0_x_ir;
  wire                                      mod11bCck_0_x_fe;
  wire                                      mod11bCck_0_x_re;

  wire        [mod11bCck_0_runZeros_w-1:0]  mod11bCck_0_runZeros;

  wire            [mod11bCck_0_run1_w-1:0]  mod11bCck_0_run1;
  wire            [mod11bCck_0_phIn_w-1:0]  mod11bCck_0_phIn;

  wire                                      mod11bCck_0_regWe;
  wire                                      mod11bCck_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  mod11bCck mod11bCck_0(mod11bCck_0_y, mod11bCck_0_y_or, mod11bCck_0_y_ff, mod11bCck_0_y_we,
                        mod11bCck_0_x, mod11bCck_0_x_ir, mod11bCck_0_x_fe, mod11bCck_0_x_re, 
                        mod11bCck_0_runZeros, 
                        mod11bCck_0_run1, 
                        mod11bCck_0_phIn, 
                        regBus, regWe, regRe, mod11bCck_0_regWe, mod11bCck_0_regRe, clk, clk2, reset);


//==============================================================================
