//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter mod11a_0_x_w             = 1;
  parameter mod11a_0_xFft_w          = 20;

  // Outputs
  parameter mod11a_0_y_w             = 20;
  parameter mod11a_0_yFft_w          = 20;

  // Input control lines

  // Output control lines
  parameter mod11a_0_irqDone_w       = 3;

  // Eregs
  parameter mod11a_0_run1_w          = 2;
  parameter mod11a_0_run1_r          = 0;
  parameter mod11a_0_run1_s          = 0;

  // Parameters
  parameter mod11a_0_w               = 10;
  parameter mod11a_0_wf              = 10;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos
  parameter mod11a_0_qam2lpd_w       = 20;
  parameter mod11a_0_qam2lpd_n       = 7;
  parameter mod11a_0_qam2lpd_m       = 3;

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam mod11a_0.x_w             = mod11a_0_x_w;
  defparam mod11a_0.xFft_w          = mod11a_0_xFft_w;
  defparam mod11a_0.y_w             = mod11a_0_y_w;
  defparam mod11a_0.yFft_w          = mod11a_0_yFft_w;
  defparam mod11a_0.irqDone_w       = mod11a_0_irqDone_w;
  defparam mod11a_0.run1_w          = mod11a_0_run1_w;
  defparam mod11a_0.run1_r          = mod11a_0_run1_r;
  defparam mod11a_0.run1_s          = mod11a_0_run1_s;
  defparam mod11a_0.w               = mod11a_0_w;
  defparam mod11a_0.wf              = mod11a_0_wf;
  defparam mod11a_0.qam2lpd_w       = mod11a_0_qam2lpd_w;
  defparam mod11a_0.qam2lpd_m       = mod11a_0_qam2lpd_m;
  defparam mod11a_0.qam2lpd_n       = mod11a_0_qam2lpd_n;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_mod11a_0_run1                                              = 0;
  defparam  mod11a_0.R_run1                                              = R_mod11a_0_run1;
  parameter R_mod11a_0_intlv_0_mode1                                     = 1;
  defparam  mod11a_0.R_intlv_0_mode1                                     = R_mod11a_0_intlv_0_mode1;
  parameter R_mod11a_0_qamMod_0_mode1                                    = 2;
  defparam  mod11a_0.R_qamMod_0_mode1                                    = R_mod11a_0_qamMod_0_mode1;
  parameter R_mod11a_0_shortSym_0_numOfdm                                = 3;
  defparam  mod11a_0.R_shortSym_0_numOfdm                                = R_mod11a_0_shortSym_0_numOfdm;

  // FIFO address definitions - might be overwritten by an upper module
  parameter R_mod11a_0_qam2lpd                                           = 4;
  defparam  mod11a_0.R_qam2lpd                                           = R_mod11a_0_qam2lpd;

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                  [mod11a_0_y_w-1:0]  mod11a_0_y;
  wire                                      mod11a_0_y_or;
  wire                                      mod11a_0_y_ff;
  wire                                      mod11a_0_y_we;

  wire               [mod11a_0_yFft_w-1:0]  mod11a_0_yFft;
  wire                                      mod11a_0_yFft_or;
  wire                                      mod11a_0_yFft_ff;
  wire                                      mod11a_0_yFft_we;

  wire                  [mod11a_0_x_w-1:0]  mod11a_0_x;
  wire                                      mod11a_0_x_ir;
  wire                                      mod11a_0_x_fe;
  wire                                      mod11a_0_x_re;

  wire               [mod11a_0_xFft_w-1:0]  mod11a_0_xFft;
  wire                                      mod11a_0_xFft_ir;
  wire                                      mod11a_0_xFft_fe;
  wire                                      mod11a_0_xFft_re;

  wire            [mod11a_0_irqDone_w-1:0]  mod11a_0_irqDone;

  wire                                      mod11a_0_regWe;
  wire                                      mod11a_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  mod11a mod11a_0(mod11a_0_y, mod11a_0_y_or, mod11a_0_y_ff, mod11a_0_y_we,
                  mod11a_0_yFft, mod11a_0_yFft_or, mod11a_0_yFft_ff, mod11a_0_yFft_we,
                  mod11a_0_x, mod11a_0_x_ir, mod11a_0_x_fe, mod11a_0_x_re, 
                  mod11a_0_xFft, mod11a_0_xFft_ir, mod11a_0_xFft_fe, mod11a_0_xFft_re, 
                  mod11a_0_irqDone, 
                  regBus, regWe, regRe, mod11a_0_regWe, mod11a_0_regRe, clk, clk2, reset);


//==============================================================================
