//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter main_0_ctrlIn_w        = WlanCtrlWidth_C;
  parameter main_0_adcRe_w         = WlanAdcDacWidth_C;
  parameter main_0_adcIm_w         = WlanAdcDacWidth_C;
  parameter main_0_dataTx_w        = WlanDataWidth_C;

  // Outputs
  parameter main_0_ctrlOut_w       = WlanCtrlWidth_C;
  parameter main_0_dacRe_w         = WlanAdcDacWidth_C;
  parameter main_0_dacIm_w         = WlanAdcDacWidth_C;
  parameter main_0_dataRx_w        = WlanDataWidth_C;
  parameter main_0_attn_w          = WlanAttnSelWidth_C;

  // Input control lines
  parameter main_0_uartIn_w        = 1;
  parameter main_0_ctrlSel_w       = 1;
  parameter main_0_gpi_w           = WlanGpioWidth_C;

  // Output control lines
  parameter main_0_uartOut_w       = 1;
  parameter main_0_statLed_w       = WlanStatLedWidth_C;
  parameter main_0_resetOut_w      = 1;
  parameter main_0_paOn_w          = 1;
  parameter main_0_txOn_w          = 1;
  parameter main_0_rxOn_w          = 1;
  parameter main_0_twbClk_w        = 1;
  parameter main_0_twbDat_w        = 1;
  parameter main_0_twbEn_w         = 1;
  parameter main_0_gpo_w           = WlanGpioWidth_C;

  // Eregs
  parameter main_0_resetReg_w      = 1;
  parameter main_0_resetReg_r      = 0;
  parameter main_0_resetReg_s      = 0;
  parameter main_0_rxRfCtrl_w      = 1;
  parameter main_0_rxRfCtrl_r      = 0;
  parameter main_0_rxRfCtrl_s      = 0;
  parameter main_0_txDataSrcSel_w  = 1;
  parameter main_0_txDataSrcSel_r  = 0;
  parameter main_0_txDataSrcSel_s  = 0;
  parameter main_0_twbClkR_w       = 1;
  parameter main_0_twbClkR_r       = 0;
  parameter main_0_twbClkR_s       = 0;
  parameter main_0_twbDatR_w       = 1;
  parameter main_0_twbDatR_r       = 0;
  parameter main_0_twbDatR_s       = 0;
  parameter main_0_twbEnR_w        = 1;
  parameter main_0_twbEnR_r        = 0;
  parameter main_0_twbEnR_s        = 0;
  parameter main_0_gpoR_w          = WlanGpioWidth_C;
  parameter main_0_gpoR_r          = 0;
  parameter main_0_gpoR_s          = 0;
  parameter main_0_gpiR_w          = WlanGpioWidth_C;
  parameter main_0_gpiR_r          = 0;
  parameter main_0_gpiR_s          = 0;
  parameter main_0_stat_w          = WlanStatLedWidth_C;
  parameter main_0_stat_r          = 0;
  parameter main_0_stat_s          = 0;

  // Parameters

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos
  parameter main_0_extIf2Host_w    = WlanCtrlWidth_C;
  parameter main_0_extIf2Host_n    = 24;
  parameter main_0_extIf2Host_m    = 5;

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam main_0.ctrlIn_w        = main_0_ctrlIn_w;
  defparam main_0.adcRe_w         = main_0_adcRe_w;
  defparam main_0.adcIm_w         = main_0_adcIm_w;
  defparam main_0.dataTx_w        = main_0_dataTx_w;
  defparam main_0.ctrlOut_w       = main_0_ctrlOut_w;
  defparam main_0.dacRe_w         = main_0_dacRe_w;
  defparam main_0.dacIm_w         = main_0_dacIm_w;
  defparam main_0.dataRx_w        = main_0_dataRx_w;
  defparam main_0.attn_w          = main_0_attn_w;
  defparam main_0.uartIn_w        = main_0_uartIn_w;
  defparam main_0.ctrlSel_w       = main_0_ctrlSel_w;
  defparam main_0.gpi_w           = main_0_gpi_w;
  defparam main_0.uartOut_w       = main_0_uartOut_w;
  defparam main_0.statLed_w       = main_0_statLed_w;
  defparam main_0.resetOut_w      = main_0_resetOut_w;
  defparam main_0.paOn_w          = main_0_paOn_w;
  defparam main_0.txOn_w          = main_0_txOn_w;
  defparam main_0.rxOn_w          = main_0_rxOn_w;
  defparam main_0.twbClk_w        = main_0_twbClk_w;
  defparam main_0.twbDat_w        = main_0_twbDat_w;
  defparam main_0.twbEn_w         = main_0_twbEn_w;
  defparam main_0.gpo_w           = main_0_gpo_w;
  defparam main_0.resetReg_w      = main_0_resetReg_w;
  defparam main_0.resetReg_r      = main_0_resetReg_r;
  defparam main_0.resetReg_s      = main_0_resetReg_s;
  defparam main_0.rxRfCtrl_w      = main_0_rxRfCtrl_w;
  defparam main_0.rxRfCtrl_r      = main_0_rxRfCtrl_r;
  defparam main_0.rxRfCtrl_s      = main_0_rxRfCtrl_s;
  defparam main_0.txDataSrcSel_w  = main_0_txDataSrcSel_w;
  defparam main_0.txDataSrcSel_r  = main_0_txDataSrcSel_r;
  defparam main_0.txDataSrcSel_s  = main_0_txDataSrcSel_s;
  defparam main_0.twbClkR_w       = main_0_twbClkR_w;
  defparam main_0.twbClkR_r       = main_0_twbClkR_r;
  defparam main_0.twbClkR_s       = main_0_twbClkR_s;
  defparam main_0.twbDatR_w       = main_0_twbDatR_w;
  defparam main_0.twbDatR_r       = main_0_twbDatR_r;
  defparam main_0.twbDatR_s       = main_0_twbDatR_s;
  defparam main_0.twbEnR_w        = main_0_twbEnR_w;
  defparam main_0.twbEnR_r        = main_0_twbEnR_r;
  defparam main_0.twbEnR_s        = main_0_twbEnR_s;
  defparam main_0.gpoR_w          = main_0_gpoR_w;
  defparam main_0.gpoR_r          = main_0_gpoR_r;
  defparam main_0.gpoR_s          = main_0_gpoR_s;
  defparam main_0.gpiR_w          = main_0_gpiR_w;
  defparam main_0.gpiR_r          = main_0_gpiR_r;
  defparam main_0.gpiR_s          = main_0_gpiR_s;
  defparam main_0.stat_w          = main_0_stat_w;
  defparam main_0.stat_r          = main_0_stat_r;
  defparam main_0.stat_s          = main_0_stat_s;
  defparam main_0.extIf2Host_w    = main_0_extIf2Host_w;
  defparam main_0.extIf2Host_m    = main_0_extIf2Host_m;
  defparam main_0.extIf2Host_n    = main_0_extIf2Host_n;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_main_0_resetReg                                            = 0;
  defparam  main_0.R_resetReg                                            = R_main_0_resetReg;
  parameter R_main_0_rxRfCtrl                                            = 1;
  defparam  main_0.R_rxRfCtrl                                            = R_main_0_rxRfCtrl;
  parameter R_main_0_txDataSrcSel                                        = 2;
  defparam  main_0.R_txDataSrcSel                                        = R_main_0_txDataSrcSel;
  parameter R_main_0_twbClkR                                             = 3;
  defparam  main_0.R_twbClkR                                             = R_main_0_twbClkR;
  parameter R_main_0_twbDatR                                             = 4;
  defparam  main_0.R_twbDatR                                             = R_main_0_twbDatR;
  parameter R_main_0_twbEnR                                              = 5;
  defparam  main_0.R_twbEnR                                              = R_main_0_twbEnR;
  parameter R_main_0_gpoR                                                = 6;
  defparam  main_0.R_gpoR                                                = R_main_0_gpoR;
  parameter R_main_0_gpiR                                                = 7;
  defparam  main_0.R_gpiR                                                = R_main_0_gpiR;
  parameter R_main_0_stat                                                = 8;
  defparam  main_0.R_stat                                                = R_main_0_stat;
  parameter R_main_0_uart16_wlan_div                                     = 9;
  defparam  main_0.R_uart16_wlan_div                                     = R_main_0_uart16_wlan_div;
  parameter R_main_0_extIf_0_rxDat                                       = 10;
  defparam  main_0.R_extIf_0_rxDat                                       = R_main_0_extIf_0_rxDat;
  parameter R_main_0_extIf_0_rxSt                                        = 11;
  defparam  main_0.R_extIf_0_rxSt                                        = R_main_0_extIf_0_rxSt;
  parameter R_main_0_extIf_0_txDat                                       = 12;
  defparam  main_0.R_extIf_0_txDat                                       = R_main_0_extIf_0_txDat;
  parameter R_main_0_extIf_0_txSt                                        = 13;
  defparam  main_0.R_extIf_0_txSt                                        = R_main_0_extIf_0_txSt;
  parameter R_main_0_extIf_0_ctrlOn                                      = 14;
  defparam  main_0.R_extIf_0_ctrlOn                                      = R_main_0_extIf_0_ctrlOn;
  parameter R_main_0_irqCtrl_wlan_run1                                   = 15;
  defparam  main_0.R_irqCtrl_wlan_run1                                   = R_main_0_irqCtrl_wlan_run1;
  parameter R_main_0_irqCtrl_wlan_irqStat                                = 16;
  defparam  main_0.R_irqCtrl_wlan_irqStat                                = R_main_0_irqCtrl_wlan_irqStat;
  parameter R_main_0_irqCtrl_wlan_irqEdgeLevel                           = 17;
  defparam  main_0.R_irqCtrl_wlan_irqEdgeLevel                           = R_main_0_irqCtrl_wlan_irqEdgeLevel;
  parameter R_main_0_irqCtrl_wlan_irqMaskIn                              = 18;
  defparam  main_0.R_irqCtrl_wlan_irqMaskIn                              = R_main_0_irqCtrl_wlan_irqMaskIn;
  parameter R_main_0_irqCtrl_wlan_irqMaskOut                             = 19;
  defparam  main_0.R_irqCtrl_wlan_irqMaskOut                             = R_main_0_irqCtrl_wlan_irqMaskOut;
  parameter R_main_0_irqCtrl_wlan_irqClr                                 = 20;
  defparam  main_0.R_irqCtrl_wlan_irqClr                                 = R_main_0_irqCtrl_wlan_irqClr;
  parameter R_main_0_irqCtrl_wlan_irqSet                                 = 21;
  defparam  main_0.R_irqCtrl_wlan_irqSet                                 = R_main_0_irqCtrl_wlan_irqSet;
  parameter R_main_0_irqCtrl_wlan_irqIdx                                 = 22;
  defparam  main_0.R_irqCtrl_wlan_irqIdx                                 = R_main_0_irqCtrl_wlan_irqIdx;
  parameter R_main_0_X16_0_cmd                                           = 23;
  defparam  main_0.R_X16_0_cmd                                           = R_main_0_X16_0_cmd;
  parameter R_main_0_X16_0_pramAdr                                       = 24;
  defparam  main_0.R_X16_0_pramAdr                                       = R_main_0_X16_0_pramAdr;
  parameter R_main_0_X16_0_pramDat                                       = 25;
  defparam  main_0.R_X16_0_pramDat                                       = R_main_0_X16_0_pramDat;
  parameter R_main_0_X16_0_dramAdr                                       = 26;
  defparam  main_0.R_X16_0_dramAdr                                       = R_main_0_X16_0_dramAdr;
  parameter R_main_0_X16_0_dramDat                                       = 27;
  defparam  main_0.R_X16_0_dramDat                                       = R_main_0_X16_0_dramDat;
  parameter R_main_0_main11_0_singleAdc                                  = 28;
  defparam  main_0.R_main11_0_singleAdc                                  = R_main_0_main11_0_singleAdc;
  parameter R_main_0_main11_0_main11a_0_txRxSel                          = 29;
  defparam  main_0.R_main11_0_main11a_0_txRxSel                          = R_main_0_main11_0_main11a_0_txRxSel;
  parameter R_main_0_main11_0_main11a_0_state11a                         = 30;
  defparam  main_0.R_main11_0_main11a_0_state11a                         = R_main_0_main11_0_main11a_0_state11a;
  parameter R_main_0_main11_0_main11a_0_state11aDbg                      = 31;
  defparam  main_0.R_main11_0_main11a_0_state11aDbg                      = R_main_0_main11_0_main11a_0_state11aDbg;
  parameter R_main_0_main11_0_main11a_0_X16_11a_cmd                      = 32;
  defparam  main_0.R_main11_0_main11a_0_X16_11a_cmd                      = R_main_0_main11_0_main11a_0_X16_11a_cmd;
  parameter R_main_0_main11_0_main11a_0_X16_11a_pramAdr                  = 33;
  defparam  main_0.R_main11_0_main11a_0_X16_11a_pramAdr                  = R_main_0_main11_0_main11a_0_X16_11a_pramAdr;
  parameter R_main_0_main11_0_main11a_0_X16_11a_pramDat                  = 34;
  defparam  main_0.R_main11_0_main11a_0_X16_11a_pramDat                  = R_main_0_main11_0_main11a_0_X16_11a_pramDat;
  parameter R_main_0_main11_0_main11a_0_X16_11a_dramAdr                  = 35;
  defparam  main_0.R_main11_0_main11a_0_X16_11a_dramAdr                  = R_main_0_main11_0_main11a_0_X16_11a_dramAdr;
  parameter R_main_0_main11_0_main11a_0_X16_11a_dramDat                  = 36;
  defparam  main_0.R_main11_0_main11a_0_X16_11a_dramDat                  = R_main_0_main11_0_main11a_0_X16_11a_dramDat;
  parameter R_main_0_main11_0_main11a_0_irqCtrl_11a_run1                 = 37;
  defparam  main_0.R_main11_0_main11a_0_irqCtrl_11a_run1                 = R_main_0_main11_0_main11a_0_irqCtrl_11a_run1;
  parameter R_main_0_main11_0_main11a_0_irqCtrl_11a_irqStat              = 38;
  defparam  main_0.R_main11_0_main11a_0_irqCtrl_11a_irqStat              = R_main_0_main11_0_main11a_0_irqCtrl_11a_irqStat;
  parameter R_main_0_main11_0_main11a_0_irqCtrl_11a_irqEdgeLevel         = 39;
  defparam  main_0.R_main11_0_main11a_0_irqCtrl_11a_irqEdgeLevel         = R_main_0_main11_0_main11a_0_irqCtrl_11a_irqEdgeLevel;
  parameter R_main_0_main11_0_main11a_0_irqCtrl_11a_irqMaskIn            = 40;
  defparam  main_0.R_main11_0_main11a_0_irqCtrl_11a_irqMaskIn            = R_main_0_main11_0_main11a_0_irqCtrl_11a_irqMaskIn;
  parameter R_main_0_main11_0_main11a_0_irqCtrl_11a_irqMaskOut           = 41;
  defparam  main_0.R_main11_0_main11a_0_irqCtrl_11a_irqMaskOut           = R_main_0_main11_0_main11a_0_irqCtrl_11a_irqMaskOut;
  parameter R_main_0_main11_0_main11a_0_irqCtrl_11a_irqClr               = 42;
  defparam  main_0.R_main11_0_main11a_0_irqCtrl_11a_irqClr               = R_main_0_main11_0_main11a_0_irqCtrl_11a_irqClr;
  parameter R_main_0_main11_0_main11a_0_irqCtrl_11a_irqSet               = 43;
  defparam  main_0.R_main11_0_main11a_0_irqCtrl_11a_irqSet               = R_main_0_main11_0_main11a_0_irqCtrl_11a_irqSet;
  parameter R_main_0_main11_0_main11a_0_irqCtrl_11a_irqIdx               = 44;
  defparam  main_0.R_main11_0_main11a_0_irqCtrl_11a_irqIdx               = R_main_0_main11_0_main11a_0_irqCtrl_11a_irqIdx;
  parameter R_main_0_main11_0_main11a_0_tx11a_0_enc11a_0_run1            = 45;
  defparam  main_0.R_main11_0_main11a_0_tx11a_0_enc11a_0_run1            = R_main_0_main11_0_main11a_0_tx11a_0_enc11a_0_run1;
  parameter R_main_0_main11_0_main11a_0_tx11a_0_enc11a_0_crc32_0_numBits = 46;
  defparam  main_0.R_main11_0_main11a_0_tx11a_0_enc11a_0_crc32_0_numBits = R_main_0_main11_0_main11a_0_tx11a_0_enc11a_0_crc32_0_numBits;
  parameter R_main_0_main11_0_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_plcpHdr0 = 47;
  defparam  main_0.R_main11_0_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_plcpHdr0 = R_main_0_main11_0_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_plcpHdr0;
  parameter R_main_0_main11_0_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_plcpHdr1 = 48;
  defparam  main_0.R_main11_0_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_plcpHdr1 = R_main_0_main11_0_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_plcpHdr1;
  parameter R_main_0_main11_0_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_numByte = 49;
  defparam  main_0.R_main11_0_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_numByte = R_main_0_main11_0_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_numByte;
  parameter R_main_0_main11_0_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_numPadBit = 50;
  defparam  main_0.R_main11_0_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_numPadBit = R_main_0_main11_0_main11a_0_tx11a_0_enc11a_0_ppdu11a_0_numPadBit;
  parameter R_main_0_main11_0_main11a_0_tx11a_0_enc11a_0_scrmbl_0_s      = 51;
  defparam  main_0.R_main11_0_main11a_0_tx11a_0_enc11a_0_scrmbl_0_s      = R_main_0_main11_0_main11a_0_tx11a_0_enc11a_0_scrmbl_0_s;
  parameter R_main_0_main11_0_main11a_0_tx11a_0_enc11a_0_punct_0_run1    = 52;
  defparam  main_0.R_main11_0_main11a_0_tx11a_0_enc11a_0_punct_0_run1    = R_main_0_main11_0_main11a_0_tx11a_0_enc11a_0_punct_0_run1;
  parameter R_main_0_main11_0_main11a_0_tx11a_0_mod11a_0_run1            = 53;
  defparam  main_0.R_main11_0_main11a_0_tx11a_0_mod11a_0_run1            = R_main_0_main11_0_main11a_0_tx11a_0_mod11a_0_run1;
  parameter R_main_0_main11_0_main11a_0_tx11a_0_mod11a_0_intlv_0_mode1   = 54;
  defparam  main_0.R_main11_0_main11a_0_tx11a_0_mod11a_0_intlv_0_mode1   = R_main_0_main11_0_main11a_0_tx11a_0_mod11a_0_intlv_0_mode1;
  parameter R_main_0_main11_0_main11a_0_tx11a_0_mod11a_0_qamMod_0_mode1  = 55;
  defparam  main_0.R_main11_0_main11a_0_tx11a_0_mod11a_0_qamMod_0_mode1  = R_main_0_main11_0_main11a_0_tx11a_0_mod11a_0_qamMod_0_mode1;
  parameter R_main_0_main11_0_main11a_0_tx11a_0_mod11a_0_shortSym_0_numOfdm = 56;
  defparam  main_0.R_main11_0_main11a_0_tx11a_0_mod11a_0_shortSym_0_numOfdm = R_main_0_main11_0_main11a_0_tx11a_0_mod11a_0_shortSym_0_numOfdm;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_runAcqBuf                = 57;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_runAcqBuf                = R_main_0_main11_0_main11a_0_rx11a_0_runAcqBuf;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_bufNormRot_0_numOut      = 58;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_bufNormRot_0_numOut      = R_main_0_main11_0_main11a_0_rx11a_0_bufNormRot_0_numOut;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_bufNormRot_0_runOut      = 59;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_bufNormRot_0_runOut      = R_main_0_main11_0_main11a_0_rx11a_0_bufNormRot_0_runOut;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_bufNormRot_0_fftWrap     = 60;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_bufNormRot_0_fftWrap     = R_main_0_main11_0_main11a_0_rx11a_0_bufNormRot_0_fftWrap;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_wrAdr = 61;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_wrAdr = R_main_0_main11_0_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_wrAdr;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_rdAdr0 = 62;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_rdAdr0 = R_main_0_main11_0_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_rdAdr0;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_irqAdr = 63;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_irqAdr = R_main_0_main11_0_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_irqAdr;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_agcDoneAdr = 64;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_agcDoneAdr = R_main_0_main11_0_main11a_0_rx11a_0_bufNormRot_0_rxBuf_0_agcDoneAdr;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_bufNormRot_0_normX_0_amp = 65;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_bufNormRot_0_normX_0_amp = R_main_0_main11_0_main11a_0_rx11a_0_bufNormRot_0_normX_0_amp;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_bufNormRot_0_cordicRot_0_ph = 66;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_bufNormRot_0_cordicRot_0_ph = R_main_0_main11_0_main11a_0_rx11a_0_bufNormRot_0_cordicRot_0_ph;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_bufNormRot_0_cordicRot_0_dph = 67;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_bufNormRot_0_cordicRot_0_dph = R_main_0_main11_0_main11a_0_rx11a_0_bufNormRot_0_cordicRot_0_dph;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_acq11a_0_freqOff         = 68;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_acq11a_0_freqOff         = R_main_0_main11_0_main11a_0_rx11a_0_acq11a_0_freqOff;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_acq11a_0_timeOff         = 69;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_acq11a_0_timeOff         = R_main_0_main11_0_main11a_0_rx11a_0_acq11a_0_timeOff;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_acq11a_0_ampEst          = 70;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_acq11a_0_ampEst          = R_main_0_main11_0_main11a_0_rx11a_0_acq11a_0_ampEst;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_acq11a_0_ssNorm_0_cutN_20c4_numCut = 71;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_acq11a_0_ssNorm_0_cutN_20c4_numCut = R_main_0_main11_0_main11a_0_rx11a_0_acq11a_0_ssNorm_0_cutN_20c4_numCut;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr2 = 72;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr2 = R_main_0_main11_0_main11a_0_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr2;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr3 = 73;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr3 = R_main_0_main11_0_main11a_0_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr3;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr4 = 74;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr4 = R_main_0_main11_0_main11a_0_rx11a_0_acq11a_0_ssCcfAvgDet_0_thr4;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_acq11a_0_ctfe_0_ctfeCordic_0_thr = 75;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_acq11a_0_ctfe_0_ctfeCordic_0_thr = R_main_0_main11_0_main11a_0_rx11a_0_acq11a_0_ctfe_0_ctfeCordic_0_thr;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_sync11a_0_run1           = 76;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_sync11a_0_run1           = R_main_0_main11_0_main11a_0_rx11a_0_sync11a_0_run1;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_sync11a_0_lsCcf_0_peakPos = 77;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_sync11a_0_lsCcf_0_peakPos = R_main_0_main11_0_main11a_0_rx11a_0_sync11a_0_lsCcf_0_peakPos;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_sync11a_0_lsCcf_0_peakVal = 78;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_sync11a_0_lsCcf_0_peakVal = R_main_0_main11_0_main11a_0_rx11a_0_sync11a_0_lsCcf_0_peakVal;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_sync11a_0_cxMulAvg_0_numSmpl = 79;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_sync11a_0_cxMulAvg_0_numSmpl = R_main_0_main11_0_main11a_0_rx11a_0_sync11a_0_cxMulAvg_0_numSmpl;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_sync11a_0_cxMulAvg_0_yReLo = 80;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_sync11a_0_cxMulAvg_0_yReLo = R_main_0_main11_0_main11a_0_rx11a_0_sync11a_0_cxMulAvg_0_yReLo;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_sync11a_0_cxMulAvg_0_yImHi = 81;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_sync11a_0_cxMulAvg_0_yImHi = R_main_0_main11_0_main11a_0_rx11a_0_sync11a_0_cxMulAvg_0_yImHi;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_dem11a_0_run1            = 82;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_dem11a_0_run1            = R_main_0_main11_0_main11a_0_rx11a_0_dem11a_0_run1;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_run1 = 83;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_run1 = R_main_0_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_run1;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_ph   = 84;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_ph   = R_main_0_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_ph;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dph3 = 85;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dph3 = R_main_0_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dph3;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dph4 = 86;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dph4 = R_main_0_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dph4;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dphM49 = 87;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dphM49 = R_main_0_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dphM49;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dph14 = 88;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dph14 = R_main_0_main11_0_main11a_0_rx11a_0_dem11a_0_ttCordic_0_dph14;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_dem11a_0_pltExt_0_pltSumRe = 89;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_dem11a_0_pltExt_0_pltSumRe = R_main_0_main11_0_main11a_0_rx11a_0_dem11a_0_pltExt_0_pltSumRe;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_dem11a_0_pltExt_0_pltSumIm = 90;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_dem11a_0_pltExt_0_pltSumIm = R_main_0_main11_0_main11a_0_rx11a_0_dem11a_0_pltExt_0_pltSumIm;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_dec11a_0_run1            = 91;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_dec11a_0_run1            = R_main_0_main11_0_main11a_0_rx11a_0_dec11a_0_run1;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_dec11a_0_deIntlv_0_mode1 = 92;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_dec11a_0_deIntlv_0_mode1 = R_main_0_main11_0_main11a_0_rx11a_0_dec11a_0_deIntlv_0_mode1;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_dec11a_0_dePunct_0_run1  = 93;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_dec11a_0_dePunct_0_run1  = R_main_0_main11_0_main11a_0_rx11a_0_dec11a_0_dePunct_0_run1;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_dec11a_0_vitMain_0_run1  = 94;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_dec11a_0_vitMain_0_run1  = R_main_0_main11_0_main11a_0_rx11a_0_dec11a_0_vitMain_0_run1;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_dec11a_0_vitMain_0_numBits = 95;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_dec11a_0_vitMain_0_numBits = R_main_0_main11_0_main11a_0_rx11a_0_dec11a_0_vitMain_0_numBits;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_dec11a_0_vitMain_0_rxMode = 96;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_dec11a_0_vitMain_0_rxMode = R_main_0_main11_0_main11a_0_rx11a_0_dec11a_0_vitMain_0_rxMode;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_dec11a_0_vitMain_0_rxLen = 97;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_dec11a_0_vitMain_0_rxLen = R_main_0_main11_0_main11a_0_rx11a_0_dec11a_0_vitMain_0_rxLen;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_dec11a_0_vitMain_0_pm00  = 98;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_dec11a_0_vitMain_0_pm00  = R_main_0_main11_0_main11a_0_rx11a_0_dec11a_0_vitMain_0_pm00;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_dec11a_0_crc32x8_0_numBytes = 99;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_dec11a_0_crc32x8_0_numBytes = R_main_0_main11_0_main11a_0_rx11a_0_dec11a_0_crc32x8_0_numBytes;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_dec11a_0_crc32x8_0_crcRes = 100;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_dec11a_0_crc32x8_0_crcRes = R_main_0_main11_0_main11a_0_rx11a_0_dec11a_0_crc32x8_0_crcRes;
  parameter R_main_0_main11_0_main11a_0_cordicR2P_0_run1                 = 101;
  defparam  main_0.R_main11_0_main11a_0_cordicR2P_0_run1                 = R_main_0_main11_0_main11a_0_cordicR2P_0_run1;
  parameter R_main_0_main11_0_main11a_0_cordicR2P_0_numIt                = 102;
  defparam  main_0.R_main11_0_main11a_0_cordicR2P_0_numIt                = R_main_0_main11_0_main11a_0_cordicR2P_0_numIt;
  parameter R_main_0_main11_0_main11a_0_cordicR2P_0_xReAbs               = 103;
  defparam  main_0.R_main11_0_main11a_0_cordicR2P_0_xReAbs               = R_main_0_main11_0_main11a_0_cordicR2P_0_xReAbs;
  parameter R_main_0_main11_0_main11a_0_cordicR2P_0_xImPh                = 104;
  defparam  main_0.R_main11_0_main11a_0_cordicR2P_0_xImPh                = R_main_0_main11_0_main11a_0_cordicR2P_0_xImPh;
  parameter R_main_0_main11_0_main11a_0_cordicR2P_0_thr                  = 105;
  defparam  main_0.R_main11_0_main11a_0_cordicR2P_0_thr                  = R_main_0_main11_0_main11a_0_cordicR2P_0_thr;
  parameter R_main_0_main11_0_main11a_0_sqrtX_0_run1                     = 106;
  defparam  main_0.R_main11_0_main11a_0_sqrtX_0_run1                     = R_main_0_main11_0_main11a_0_sqrtX_0_run1;
  parameter R_main_0_main11_0_main11a_0_sqrtX_0_xy                       = 107;
  defparam  main_0.R_main11_0_main11a_0_sqrtX_0_xy                       = R_main_0_main11_0_main11a_0_sqrtX_0_xy;
  parameter R_main_0_main11_0_main11a_0_fft64_0_run1                     = 108;
  defparam  main_0.R_main11_0_main11a_0_fft64_0_run1                     = R_main_0_main11_0_main11a_0_fft64_0_run1;
  parameter R_main_0_main11_0_main11a_0_fft64_0_tglMode                  = 109;
  defparam  main_0.R_main11_0_main11a_0_fft64_0_tglMode                  = R_main_0_main11_0_main11a_0_fft64_0_tglMode;
  parameter R_main_0_main11_0_main11a_0_fft64_0_inpOrd                   = 110;
  defparam  main_0.R_main11_0_main11a_0_fft64_0_inpOrd                   = R_main_0_main11_0_main11a_0_fft64_0_inpOrd;
  parameter R_main_0_main11_0_main11a_0_fft64_0_outpOrd                  = 111;
  defparam  main_0.R_main11_0_main11a_0_fft64_0_outpOrd                  = R_main_0_main11_0_main11a_0_fft64_0_outpOrd;
  parameter R_main_0_main11_0_main11b_0_state11b                         = 112;
  defparam  main_0.R_main11_0_main11b_0_state11b                         = R_main_0_main11_0_main11b_0_state11b;
  parameter R_main_0_main11_0_main11b_0_state11bDbg                      = 113;
  defparam  main_0.R_main11_0_main11b_0_state11bDbg                      = R_main_0_main11_0_main11b_0_state11bDbg;
  parameter R_main_0_main11_0_main11b_0_X16_11b_cmd                      = 114;
  defparam  main_0.R_main11_0_main11b_0_X16_11b_cmd                      = R_main_0_main11_0_main11b_0_X16_11b_cmd;
  parameter R_main_0_main11_0_main11b_0_X16_11b_pramAdr                  = 115;
  defparam  main_0.R_main11_0_main11b_0_X16_11b_pramAdr                  = R_main_0_main11_0_main11b_0_X16_11b_pramAdr;
  parameter R_main_0_main11_0_main11b_0_X16_11b_pramDat                  = 116;
  defparam  main_0.R_main11_0_main11b_0_X16_11b_pramDat                  = R_main_0_main11_0_main11b_0_X16_11b_pramDat;
  parameter R_main_0_main11_0_main11b_0_X16_11b_dramAdr                  = 117;
  defparam  main_0.R_main11_0_main11b_0_X16_11b_dramAdr                  = R_main_0_main11_0_main11b_0_X16_11b_dramAdr;
  parameter R_main_0_main11_0_main11b_0_X16_11b_dramDat                  = 118;
  defparam  main_0.R_main11_0_main11b_0_X16_11b_dramDat                  = R_main_0_main11_0_main11b_0_X16_11b_dramDat;
  parameter R_main_0_main11_0_main11b_0_irqCtrl_11b_run1                 = 119;
  defparam  main_0.R_main11_0_main11b_0_irqCtrl_11b_run1                 = R_main_0_main11_0_main11b_0_irqCtrl_11b_run1;
  parameter R_main_0_main11_0_main11b_0_irqCtrl_11b_irqStat              = 120;
  defparam  main_0.R_main11_0_main11b_0_irqCtrl_11b_irqStat              = R_main_0_main11_0_main11b_0_irqCtrl_11b_irqStat;
  parameter R_main_0_main11_0_main11b_0_irqCtrl_11b_irqEdgeLevel         = 121;
  defparam  main_0.R_main11_0_main11b_0_irqCtrl_11b_irqEdgeLevel         = R_main_0_main11_0_main11b_0_irqCtrl_11b_irqEdgeLevel;
  parameter R_main_0_main11_0_main11b_0_irqCtrl_11b_irqMaskIn            = 122;
  defparam  main_0.R_main11_0_main11b_0_irqCtrl_11b_irqMaskIn            = R_main_0_main11_0_main11b_0_irqCtrl_11b_irqMaskIn;
  parameter R_main_0_main11_0_main11b_0_irqCtrl_11b_irqMaskOut           = 123;
  defparam  main_0.R_main11_0_main11b_0_irqCtrl_11b_irqMaskOut           = R_main_0_main11_0_main11b_0_irqCtrl_11b_irqMaskOut;
  parameter R_main_0_main11_0_main11b_0_irqCtrl_11b_irqClr               = 124;
  defparam  main_0.R_main11_0_main11b_0_irqCtrl_11b_irqClr               = R_main_0_main11_0_main11b_0_irqCtrl_11b_irqClr;
  parameter R_main_0_main11_0_main11b_0_irqCtrl_11b_irqSet               = 125;
  defparam  main_0.R_main11_0_main11b_0_irqCtrl_11b_irqSet               = R_main_0_main11_0_main11b_0_irqCtrl_11b_irqSet;
  parameter R_main_0_main11_0_main11b_0_irqCtrl_11b_irqIdx               = 126;
  defparam  main_0.R_main11_0_main11b_0_irqCtrl_11b_irqIdx               = R_main_0_main11_0_main11b_0_irqCtrl_11b_irqIdx;
  parameter R_main_0_main11_0_main11b_0_tx11b_0_run1                     = 127;
  defparam  main_0.R_main11_0_main11b_0_tx11b_0_run1                     = R_main_0_main11_0_main11b_0_tx11b_0_run1;
  parameter R_main_0_main11_0_main11b_0_tx11b_0_crc32_0_numBits          = 128;
  defparam  main_0.R_main11_0_main11b_0_tx11b_0_crc32_0_numBits          = R_main_0_main11_0_main11b_0_tx11b_0_crc32_0_numBits;
  parameter R_main_0_main11_0_main11b_0_tx11b_0_ppdu11b_0_header         = 129;
  defparam  main_0.R_main11_0_main11b_0_tx11b_0_ppdu11b_0_header         = R_main_0_main11_0_main11b_0_tx11b_0_ppdu11b_0_header;
  parameter R_main_0_main11_0_main11b_0_tx11b_0_ppdu11b_0_sfd            = 130;
  defparam  main_0.R_main11_0_main11b_0_tx11b_0_ppdu11b_0_sfd            = R_main_0_main11_0_main11b_0_tx11b_0_ppdu11b_0_sfd;
  parameter R_main_0_main11_0_main11b_0_tx11b_0_ppdu11b_0_sigser         = 131;
  defparam  main_0.R_main11_0_main11b_0_tx11b_0_ppdu11b_0_sigser         = R_main_0_main11_0_main11b_0_tx11b_0_ppdu11b_0_sigser;
  parameter R_main_0_main11_0_main11b_0_tx11b_0_ppdu11b_0_len            = 132;
  defparam  main_0.R_main11_0_main11b_0_tx11b_0_ppdu11b_0_len            = R_main_0_main11_0_main11b_0_tx11b_0_ppdu11b_0_len;
  parameter R_main_0_main11_0_main11b_0_tx11b_0_ppdu11b_0_crc            = 133;
  defparam  main_0.R_main11_0_main11b_0_tx11b_0_ppdu11b_0_crc            = R_main_0_main11_0_main11b_0_tx11b_0_ppdu11b_0_crc;
  parameter R_main_0_main11_0_main11b_0_tx11b_0_ppdu11b_0_numBits        = 134;
  defparam  main_0.R_main11_0_main11b_0_tx11b_0_ppdu11b_0_numBits        = R_main_0_main11_0_main11b_0_tx11b_0_ppdu11b_0_numBits;
  parameter R_main_0_main11_0_main11b_0_tx11b_0_scrmbl_tx11b_s           = 135;
  defparam  main_0.R_main11_0_main11b_0_tx11b_0_scrmbl_tx11b_s           = R_main_0_main11_0_main11b_0_tx11b_0_scrmbl_tx11b_s;
  parameter R_main_0_main11_0_main11b_0_tx11b_0_mod11b_0_mod11bBpsk_0_numBits = 136;
  defparam  main_0.R_main11_0_main11b_0_tx11b_0_mod11b_0_mod11bBpsk_0_numBits = R_main_0_main11_0_main11b_0_tx11b_0_mod11b_0_mod11bBpsk_0_numBits;
  parameter R_main_0_main11_0_main11b_0_tx11b_0_mod11b_0_mod11bQpsk_0_numBits = 137;
  defparam  main_0.R_main11_0_main11b_0_tx11b_0_mod11b_0_mod11bQpsk_0_numBits = R_main_0_main11_0_main11b_0_tx11b_0_mod11b_0_mod11bQpsk_0_numBits;
  parameter R_main_0_main11_0_main11b_0_tx11b_0_mod11b_0_mod11bCck_0_numBits = 138;
  defparam  main_0.R_main11_0_main11b_0_tx11b_0_mod11b_0_mod11bCck_0_numBits = R_main_0_main11_0_main11b_0_tx11b_0_mod11b_0_mod11bCck_0_numBits;
  parameter R_main_0_main11_0_main11b_0_tx11b_0_mod11b_0_mod11bCck_0_mode1 = 139;
  defparam  main_0.R_main11_0_main11b_0_tx11b_0_mod11b_0_mod11bCck_0_mode1 = R_main_0_main11_0_main11b_0_tx11b_0_mod11b_0_mod11bCck_0_mode1;
  parameter R_main_0_main11_0_main11b_0_tx11b_0_mod11b_0_modQpskZero_0_numZeros = 140;
  defparam  main_0.R_main11_0_main11b_0_tx11b_0_mod11b_0_modQpskZero_0_numZeros = R_main_0_main11_0_main11b_0_tx11b_0_mod11b_0_modQpskZero_0_numZeros;
  parameter R_main_0_main11_0_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_wrAdr = 141;
  defparam  main_0.R_main11_0_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_wrAdr = R_main_0_main11_0_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_wrAdr;
  parameter R_main_0_main11_0_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_wrDatHi = 142;
  defparam  main_0.R_main11_0_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_wrDatHi = R_main_0_main11_0_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_wrDatHi;
  parameter R_main_0_main11_0_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_wrDatLo = 143;
  defparam  main_0.R_main11_0_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_wrDatLo = R_main_0_main11_0_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_wrDatLo;
  parameter R_main_0_main11_0_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_simInit = 144;
  defparam  main_0.R_main11_0_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_simInit = R_main_0_main11_0_main11b_0_tx11b_0_src11to20_0_lut_cf11bTx_simInit;
  parameter R_main_0_main11_0_rtx80_0_run1                               = 145;
  defparam  main_0.R_main11_0_rtx80_0_run1                               = R_main_0_main11_0_rtx80_0_run1;
  parameter R_main_0_main11_0_rtx80_0_scaleTx_0_scFac                    = 146;
  defparam  main_0.R_main11_0_rtx80_0_scaleTx_0_scFac                    = R_main_0_main11_0_rtx80_0_scaleTx_0_scFac;
  parameter R_main_0_main11_0_rtx80_0_wdfSrc_0_cLo1                      = 147;
  defparam  main_0.R_main11_0_rtx80_0_wdfSrc_0_cLo1                      = R_main_0_main11_0_rtx80_0_wdfSrc_0_cLo1;
  parameter R_main_0_main11_0_rtx80_0_wdfSrc_0_cLo2                      = 148;
  defparam  main_0.R_main11_0_rtx80_0_wdfSrc_0_cLo2                      = R_main_0_main11_0_rtx80_0_wdfSrc_0_cLo2;
  parameter R_main_0_main11_0_rtx80_0_wdfSrc_0_cLo3                      = 149;
  defparam  main_0.R_main11_0_rtx80_0_wdfSrc_0_cLo3                      = R_main_0_main11_0_rtx80_0_wdfSrc_0_cLo3;
  parameter R_main_0_main11_0_rtx80_0_wdfSrc_0_cLo4                      = 150;
  defparam  main_0.R_main11_0_rtx80_0_wdfSrc_0_cLo4                      = R_main_0_main11_0_rtx80_0_wdfSrc_0_cLo4;
  parameter R_main_0_main11_0_rtx80_0_wdfSrc_0_cHi1                      = 151;
  defparam  main_0.R_main11_0_rtx80_0_wdfSrc_0_cHi1                      = R_main_0_main11_0_rtx80_0_wdfSrc_0_cHi1;
  parameter R_main_0_main11_0_rtx80_0_wdfSrc_0_cHi2                      = 152;
  defparam  main_0.R_main11_0_rtx80_0_wdfSrc_0_cHi2                      = R_main_0_main11_0_rtx80_0_wdfSrc_0_cHi2;
  parameter R_main_0_main11_0_rtx80_0_wdfSrc_0_singleAdc                 = 153;
  defparam  main_0.R_main11_0_rtx80_0_wdfSrc_0_singleAdc                 = R_main_0_main11_0_rtx80_0_wdfSrc_0_singleAdc;
  parameter R_main_0_main11_0_rtx80_0_freqShift_0_fShBr                  = 154;
  defparam  main_0.R_main11_0_rtx80_0_freqShift_0_fShBr                  = R_main_0_main11_0_rtx80_0_freqShift_0_fShBr;
  parameter R_main_0_main11_0_rtx80_0_dcOffCorr_0_corrOn                 = 155;
  defparam  main_0.R_main11_0_rtx80_0_dcOffCorr_0_corrOn                 = R_main_0_main11_0_rtx80_0_dcOffCorr_0_corrOn;
  parameter R_main_0_main11_0_rtx80_0_dcOffCorr_0_txDcOffRe              = 156;
  defparam  main_0.R_main11_0_rtx80_0_dcOffCorr_0_txDcOffRe              = R_main_0_main11_0_rtx80_0_dcOffCorr_0_txDcOffRe;
  parameter R_main_0_main11_0_rtx80_0_dcOffCorr_0_txDcOffIm              = 157;
  defparam  main_0.R_main11_0_rtx80_0_dcOffCorr_0_txDcOffIm              = R_main_0_main11_0_rtx80_0_dcOffCorr_0_txDcOffIm;
  parameter R_main_0_main11_0_rtx80_0_dcOffCorr_0_lut_rxDcOff_wrAdr      = 158;
  defparam  main_0.R_main11_0_rtx80_0_dcOffCorr_0_lut_rxDcOff_wrAdr      = R_main_0_main11_0_rtx80_0_dcOffCorr_0_lut_rxDcOff_wrAdr;
  parameter R_main_0_main11_0_rtx80_0_dcOffCorr_0_lut_rxDcOff_wrDatHi    = 159;
  defparam  main_0.R_main11_0_rtx80_0_dcOffCorr_0_lut_rxDcOff_wrDatHi    = R_main_0_main11_0_rtx80_0_dcOffCorr_0_lut_rxDcOff_wrDatHi;
  parameter R_main_0_main11_0_rtx80_0_dcOffCorr_0_lut_rxDcOff_wrDatLo    = 160;
  defparam  main_0.R_main11_0_rtx80_0_dcOffCorr_0_lut_rxDcOff_wrDatLo    = R_main_0_main11_0_rtx80_0_dcOffCorr_0_lut_rxDcOff_wrDatLo;
  parameter R_main_0_main11_0_rtx80_0_dcOffCorr_0_lut_rxDcOff_simInit    = 161;
  defparam  main_0.R_main11_0_rtx80_0_dcOffCorr_0_lut_rxDcOff_simInit    = R_main_0_main11_0_rtx80_0_dcOffCorr_0_lut_rxDcOff_simInit;
  parameter R_main_0_main11_0_rtx80_0_iqBuf_0_swSel                      = 162;
  defparam  main_0.R_main11_0_rtx80_0_iqBuf_0_swSel                      = R_main_0_main11_0_rtx80_0_iqBuf_0_swSel;
  parameter R_main_0_main11_0_rtx80_0_iqBuf_0_dataBufX32_iqBuf_run1      = 163;
  defparam  main_0.R_main11_0_rtx80_0_iqBuf_0_dataBufX32_iqBuf_run1      = R_main_0_main11_0_rtx80_0_iqBuf_0_dataBufX32_iqBuf_run1;
  parameter R_main_0_main11_0_rtx80_0_iqBuf_0_dataBufX32_iqBuf_datAdr    = 164;
  defparam  main_0.R_main11_0_rtx80_0_iqBuf_0_dataBufX32_iqBuf_datAdr    = R_main_0_main11_0_rtx80_0_iqBuf_0_dataBufX32_iqBuf_datAdr;
  parameter R_main_0_main11_0_rtx80_0_iqBuf_0_dataBufX32_iqBuf_datValLo  = 165;
  defparam  main_0.R_main11_0_rtx80_0_iqBuf_0_dataBufX32_iqBuf_datValLo  = R_main_0_main11_0_rtx80_0_iqBuf_0_dataBufX32_iqBuf_datValLo;
  parameter R_main_0_main11_0_rtx80_0_iqBuf_0_dataBufX32_iqBuf_datValHi  = 166;
  defparam  main_0.R_main11_0_rtx80_0_iqBuf_0_dataBufX32_iqBuf_datValHi  = R_main_0_main11_0_rtx80_0_iqBuf_0_dataBufX32_iqBuf_datValHi;
  parameter R_main_0_main11_0_rtx80_0_iqBuf_0_thrPass_0_run1             = 167;
  defparam  main_0.R_main11_0_rtx80_0_iqBuf_0_thrPass_0_run1             = R_main_0_main11_0_rtx80_0_iqBuf_0_thrPass_0_run1;
  parameter R_main_0_main11_0_rtx80_0_iqBuf_0_thrPass_0_thr              = 168;
  defparam  main_0.R_main11_0_rtx80_0_iqBuf_0_thrPass_0_thr              = R_main_0_main11_0_rtx80_0_iqBuf_0_thrPass_0_thr;
  parameter R_main_0_main11_0_rtx80_0_iqBuf_0_thrPass_0_trig             = 169;
  defparam  main_0.R_main11_0_rtx80_0_iqBuf_0_thrPass_0_trig             = R_main_0_main11_0_rtx80_0_iqBuf_0_thrPass_0_trig;
  parameter R_main_0_main11_0_agcMain_0_run1                             = 170;
  defparam  main_0.R_main11_0_agcMain_0_run1                             = R_main_0_main11_0_agcMain_0_run1;
  parameter R_main_0_main11_0_agcMain_0_numSteps                         = 171;
  defparam  main_0.R_main11_0_agcMain_0_numSteps                         = R_main_0_main11_0_agcMain_0_numSteps;
  parameter R_main_0_main11_0_agcMain_0_attnCur                          = 172;
  defparam  main_0.R_main11_0_agcMain_0_attnCur                          = R_main_0_main11_0_agcMain_0_attnCur;
  parameter R_main_0_main11_0_agcMain_0_attnCurReal                      = 173;
  defparam  main_0.R_main11_0_agcMain_0_attnCurReal                      = R_main_0_main11_0_agcMain_0_attnCurReal;
  parameter R_main_0_main11_0_agcMain_0_attnInit                         = 174;
  defparam  main_0.R_main11_0_agcMain_0_attnInit                         = R_main_0_main11_0_agcMain_0_attnInit;
  parameter R_main_0_main11_0_agcMain_0_attnTest                         = 175;
  defparam  main_0.R_main11_0_agcMain_0_attnTest                         = R_main_0_main11_0_agcMain_0_attnTest;
  parameter R_main_0_main11_0_agcMain_0_backOffTgt                       = 176;
  defparam  main_0.R_main11_0_agcMain_0_backOffTgt                       = R_main_0_main11_0_agcMain_0_backOffTgt;
  parameter R_main_0_main11_0_agcMain_0_attnInitUpdt                     = 177;
  defparam  main_0.R_main11_0_agcMain_0_attnInitUpdt                     = R_main_0_main11_0_agcMain_0_attnInitUpdt;
  parameter R_main_0_main11_0_agcMain_0_thrLo                            = 178;
  defparam  main_0.R_main11_0_agcMain_0_thrLo                            = R_main_0_main11_0_agcMain_0_thrLo;
  parameter R_main_0_main11_0_agcMain_0_thrHi                            = 179;
  defparam  main_0.R_main11_0_agcMain_0_thrHi                            = R_main_0_main11_0_agcMain_0_thrHi;
  parameter R_main_0_main11_0_agcMain_0_thrX                             = 180;
  defparam  main_0.R_main11_0_agcMain_0_thrX                             = R_main_0_main11_0_agcMain_0_thrX;
  parameter R_main_0_main11_0_agcMain_0_stepDb                           = 181;
  defparam  main_0.R_main11_0_agcMain_0_stepDb                           = R_main_0_main11_0_agcMain_0_stepDb;
  parameter R_main_0_main11_0_agcMain_0_waitSettle                       = 182;
  defparam  main_0.R_main11_0_agcMain_0_waitSettle                       = R_main_0_main11_0_agcMain_0_waitSettle;
  parameter R_main_0_main11_0_agcMain_0_waitFinal                        = 183;
  defparam  main_0.R_main11_0_agcMain_0_waitFinal                        = R_main_0_main11_0_agcMain_0_waitFinal;
  parameter R_main_0_main11_0_agcMain_0_lut_agc_wrAdr                    = 184;
  defparam  main_0.R_main11_0_agcMain_0_lut_agc_wrAdr                    = R_main_0_main11_0_agcMain_0_lut_agc_wrAdr;
  parameter R_main_0_main11_0_agcMain_0_lut_agc_wrDatHi                  = 185;
  defparam  main_0.R_main11_0_agcMain_0_lut_agc_wrDatHi                  = R_main_0_main11_0_agcMain_0_lut_agc_wrDatHi;
  parameter R_main_0_main11_0_agcMain_0_lut_agc_wrDatLo                  = 186;
  defparam  main_0.R_main11_0_agcMain_0_lut_agc_wrDatLo                  = R_main_0_main11_0_agcMain_0_lut_agc_wrDatLo;
  parameter R_main_0_main11_0_agcMain_0_lut_agc_simInit                  = 187;
  defparam  main_0.R_main11_0_agcMain_0_lut_agc_simInit                  = R_main_0_main11_0_agcMain_0_lut_agc_simInit;
  parameter R_main_0_main11_0_agcMain_0_agcRssi_0_singleAdc              = 188;
  defparam  main_0.R_main11_0_agcMain_0_agcRssi_0_singleAdc              = R_main_0_main11_0_agcMain_0_agcRssi_0_singleAdc;
  parameter R_main_0_timer_0_run1                                        = 189;
  defparam  main_0.R_timer_0_run1                                        = R_main_0_timer_0_run1;
  parameter R_main_0_timer_0_timeLo                                      = 190;
  defparam  main_0.R_timer_0_timeLo                                      = R_main_0_timer_0_timeLo;
  parameter R_main_0_timer_0_timeHi                                      = 191;
  defparam  main_0.R_timer_0_timeHi                                      = R_main_0_timer_0_timeHi;
  parameter R_main_0_timer_0_irqEn0                                      = 192;
  defparam  main_0.R_timer_0_irqEn0                                      = R_main_0_timer_0_irqEn0;
  parameter R_main_0_timer_0_irqEn1                                      = 193;
  defparam  main_0.R_timer_0_irqEn1                                      = R_main_0_timer_0_irqEn1;
  parameter R_main_0_timer_0_tMatch0Lo                                   = 194;
  defparam  main_0.R_timer_0_tMatch0Lo                                   = R_main_0_timer_0_tMatch0Lo;
  parameter R_main_0_timer_0_tMatch0Hi                                   = 195;
  defparam  main_0.R_timer_0_tMatch0Hi                                   = R_main_0_timer_0_tMatch0Hi;
  parameter R_main_0_timer_0_tMatch1Lo                                   = 196;
  defparam  main_0.R_timer_0_tMatch1Lo                                   = R_main_0_timer_0_tMatch1Lo;
  parameter R_main_0_timer_0_tMatch1Hi                                   = 197;
  defparam  main_0.R_timer_0_tMatch1Hi                                   = R_main_0_timer_0_tMatch1Hi;
  parameter R_main_0_timer_0_pLo16                                       = 198;
  defparam  main_0.R_timer_0_pLo16                                       = R_main_0_timer_0_pLo16;
  parameter R_main_0_timer_0_pHi16                                       = 199;
  defparam  main_0.R_timer_0_pHi16                                       = R_main_0_timer_0_pHi16;
  parameter R_main_0_timer_0_qLo16                                       = 200;
  defparam  main_0.R_timer_0_qLo16                                       = R_main_0_timer_0_qLo16;
  parameter R_main_0_timer_0_qHi16                                       = 201;
  defparam  main_0.R_timer_0_qHi16                                       = R_main_0_timer_0_qHi16;
  parameter R_main_0_txRfCtrl_0_run1                                     = 202;
  defparam  main_0.R_txRfCtrl_0_run1                                     = R_main_0_txRfCtrl_0_run1;
  parameter R_main_0_txRfCtrl_0_paDelay                                  = 203;
  defparam  main_0.R_txRfCtrl_0_paDelay                                  = R_main_0_txRfCtrl_0_paDelay;
  parameter R_main_0_txRfCtrl_0_txDelay                                  = 204;
  defparam  main_0.R_txRfCtrl_0_txDelay                                  = R_main_0_txRfCtrl_0_txDelay;
  parameter R_main_0_txRfCtrl_0_bbDelay                                  = 205;
  defparam  main_0.R_txRfCtrl_0_bbDelay                                  = R_main_0_txRfCtrl_0_bbDelay;
  parameter R_main_0_dcfBuf_0_dcfMode                                    = 206;
  defparam  main_0.R_dcfBuf_0_dcfMode                                    = R_main_0_dcfBuf_0_dcfMode;
  parameter R_main_0_dcfBuf_0_dataBuf_dcfRx_run1                         = 207;
  defparam  main_0.R_dcfBuf_0_dataBuf_dcfRx_run1                         = R_main_0_dcfBuf_0_dataBuf_dcfRx_run1;
  parameter R_main_0_dcfBuf_0_dataBuf_dcfRx_datAdr                       = 208;
  defparam  main_0.R_dcfBuf_0_dataBuf_dcfRx_datAdr                       = R_main_0_dcfBuf_0_dataBuf_dcfRx_datAdr;
  parameter R_main_0_dcfBuf_0_dataBuf_dcfRx_datVal                       = 209;
  defparam  main_0.R_dcfBuf_0_dataBuf_dcfRx_datVal                       = R_main_0_dcfBuf_0_dataBuf_dcfRx_datVal;
  parameter R_main_0_dcfBuf_0_dataBuf_dcfTx_run1                         = 210;
  defparam  main_0.R_dcfBuf_0_dataBuf_dcfTx_run1                         = R_main_0_dcfBuf_0_dataBuf_dcfTx_run1;
  parameter R_main_0_dcfBuf_0_dataBuf_dcfTx_datAdr                       = 211;
  defparam  main_0.R_dcfBuf_0_dataBuf_dcfTx_datAdr                       = R_main_0_dcfBuf_0_dataBuf_dcfTx_datAdr;
  parameter R_main_0_dcfBuf_0_dataBuf_dcfTx_datVal                       = 212;
  defparam  main_0.R_dcfBuf_0_dataBuf_dcfTx_datVal                       = R_main_0_dcfBuf_0_dataBuf_dcfTx_datVal;
  parameter R_main_0_dcfBuf_0_fifoIf_0_run1                              = 213;
  defparam  main_0.R_dcfBuf_0_fifoIf_0_run1                              = R_main_0_dcfBuf_0_fifoIf_0_run1;
  parameter R_main_0_dcfBuf_0_fifoIf_0_rxDat                             = 214;
  defparam  main_0.R_dcfBuf_0_fifoIf_0_rxDat                             = R_main_0_dcfBuf_0_fifoIf_0_rxDat;
  parameter R_main_0_dcfBuf_0_fifoIf_0_rxSt                              = 215;
  defparam  main_0.R_dcfBuf_0_fifoIf_0_rxSt                              = R_main_0_dcfBuf_0_fifoIf_0_rxSt;
  parameter R_main_0_dcfBuf_0_fifoIf_0_txDat                             = 216;
  defparam  main_0.R_dcfBuf_0_fifoIf_0_txDat                             = R_main_0_dcfBuf_0_fifoIf_0_txDat;
  parameter R_main_0_dcfBuf_0_fifoIf_0_txSt                              = 217;
  defparam  main_0.R_dcfBuf_0_fifoIf_0_txSt                              = R_main_0_dcfBuf_0_fifoIf_0_txSt;
  parameter R_main_0_dcfBuf_0_c16To8_0_run1                              = 218;
  defparam  main_0.R_dcfBuf_0_c16To8_0_run1                              = R_main_0_dcfBuf_0_c16To8_0_run1;
  parameter R_main_0_dcfBuf_0_c16To8_0_nByte                             = 219;
  defparam  main_0.R_dcfBuf_0_c16To8_0_nByte                             = R_main_0_dcfBuf_0_c16To8_0_nByte;
  parameter R_main_0_dcfBuf_0_c8To16_0_run1                              = 220;
  defparam  main_0.R_dcfBuf_0_c8To16_0_run1                              = R_main_0_dcfBuf_0_c8To16_0_run1;
  parameter R_main_0_dcfBuf_0_c8To16_0_nByte                             = 221;
  defparam  main_0.R_dcfBuf_0_c8To16_0_nByte                             = R_main_0_dcfBuf_0_c8To16_0_nByte;
  parameter R_main_0_dataGen_0_run1                                      = 222;
  defparam  main_0.R_dataGen_0_run1                                      = R_main_0_dataGen_0_run1;
  parameter R_main_0_dataGen_0_outVal                                    = 223;
  defparam  main_0.R_dataGen_0_outVal                                    = R_main_0_dataGen_0_outVal;
  parameter R_main_0_dataGen_0_numBytes                                  = 224;
  defparam  main_0.R_dataGen_0_numBytes                                  = R_main_0_dataGen_0_numBytes;

  parameter R_main_0_main11_0_main11a_0_bridge_11a_fifoMst               = 225;
  defparam  main_0.R_main11_0_main11a_0_bridge_11a_fifoMst               = R_main_0_main11_0_main11a_0_bridge_11a_fifoMst;
  parameter R_main_0_main11_0_main11a_0_bridge_11a_ctrlMst               = 226;
  defparam  main_0.R_main11_0_main11a_0_bridge_11a_ctrlMst               = R_main_0_main11_0_main11a_0_bridge_11a_ctrlMst;
  parameter R_main_0_main11_0_main11a_0_bridge_11a_fifoSlv               = 227;
  defparam  main_0.R_main11_0_main11a_0_bridge_11a_fifoSlv               = R_main_0_main11_0_main11a_0_bridge_11a_fifoSlv;
  parameter R_main_0_main11_0_main11a_0_bridge_11a_ctrlSlv               = 228;
  defparam  main_0.R_main11_0_main11a_0_bridge_11a_ctrlSlv               = R_main_0_main11_0_main11a_0_bridge_11a_ctrlSlv;
  parameter R_main_0_main11_0_main11b_0_bridge_11b_fifoMst               = 229;
  defparam  main_0.R_main11_0_main11b_0_bridge_11b_fifoMst               = R_main_0_main11_0_main11b_0_bridge_11b_fifoMst;
  parameter R_main_0_main11_0_main11b_0_bridge_11b_ctrlMst               = 230;
  defparam  main_0.R_main11_0_main11b_0_bridge_11b_ctrlMst               = R_main_0_main11_0_main11b_0_bridge_11b_ctrlMst;
  parameter R_main_0_main11_0_main11b_0_bridge_11b_fifoSlv               = 231;
  defparam  main_0.R_main11_0_main11b_0_bridge_11b_fifoSlv               = R_main_0_main11_0_main11b_0_bridge_11b_fifoSlv;
  parameter R_main_0_main11_0_main11b_0_bridge_11b_ctrlSlv               = 232;
  defparam  main_0.R_main11_0_main11b_0_bridge_11b_ctrlSlv               = R_main_0_main11_0_main11b_0_bridge_11b_ctrlSlv;

  // FIFO address definitions - might be overwritten by an upper module
  parameter R_main_0_extIf2Host                                          = 233;
  defparam  main_0.R_extIf2Host                                          = R_main_0_extIf2Host;
  parameter R_main_0_main11_0_main11a_0_tx11a_0_mod11a_0_qam2lpd         = 234;
  defparam  main_0.R_main11_0_main11a_0_tx11a_0_mod11a_0_qam2lpd         = R_main_0_main11_0_main11a_0_tx11a_0_mod11a_0_qam2lpd;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_acq11a_0_ssNorm_0_ffIn   = 235;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_acq11a_0_ssNorm_0_ffIn   = R_main_0_main11_0_main11a_0_rx11a_0_acq11a_0_ssNorm_0_ffIn;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_dem11a_0_ffIn            = 236;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_dem11a_0_ffIn            = R_main_0_main11_0_main11a_0_rx11a_0_dem11a_0_ffIn;
  parameter R_main_0_main11_0_main11a_0_rx11a_0_dec11a_0_ffD2D           = 237;
  defparam  main_0.R_main11_0_main11a_0_rx11a_0_dec11a_0_ffD2D           = R_main_0_main11_0_main11a_0_rx11a_0_dec11a_0_ffD2D;
  parameter R_main_0_main11_0_main11b_0_tx11b_0_ffMod2Src                = 238;
  defparam  main_0.R_main11_0_main11b_0_tx11b_0_ffMod2Src                = R_main_0_main11_0_main11b_0_tx11b_0_ffMod2Src;
  parameter R_main_0_dcfBuf_0_phyTxFifo                                  = 239;
  defparam  main_0.R_dcfBuf_0_phyTxFifo                                  = R_main_0_dcfBuf_0_phyTxFifo;

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire              [main_0_ctrlOut_w-1:0]  main_0_ctrlOut;
  wire                                      main_0_ctrlOut_or;
  wire                                      main_0_ctrlOut_ff;
  wire                                      main_0_ctrlOut_we;

  wire                [main_0_dacRe_w-1:0]  main_0_dacRe;
  wire                                      main_0_dacRe_or;
  wire                                      main_0_dacRe_ff;
  wire                                      main_0_dacRe_we;

  wire                [main_0_dacIm_w-1:0]  main_0_dacIm;
  wire                                      main_0_dacIm_or;
  wire                                      main_0_dacIm_ff;
  wire                                      main_0_dacIm_we;

  wire               [main_0_dataRx_w-1:0]  main_0_dataRx;
  wire                                      main_0_dataRx_or;
  wire                                      main_0_dataRx_ff;
  wire                                      main_0_dataRx_we;

  wire                 [main_0_attn_w-1:0]  main_0_attn;
  wire                                      main_0_attn_or;
  wire                                      main_0_attn_ff;
  wire                                      main_0_attn_we;

  wire               [main_0_ctrlIn_w-1:0]  main_0_ctrlIn;
  wire                                      main_0_ctrlIn_ir;
  wire                                      main_0_ctrlIn_fe;
  wire                                      main_0_ctrlIn_re;

  wire                [main_0_adcRe_w-1:0]  main_0_adcRe;
  wire                                      main_0_adcRe_ir;
  wire                                      main_0_adcRe_fe;
  wire                                      main_0_adcRe_re;

  wire                [main_0_adcIm_w-1:0]  main_0_adcIm;
  wire                                      main_0_adcIm_ir;
  wire                                      main_0_adcIm_fe;
  wire                                      main_0_adcIm_re;

  wire               [main_0_dataTx_w-1:0]  main_0_dataTx;
  wire                                      main_0_dataTx_ir;
  wire                                      main_0_dataTx_fe;
  wire                                      main_0_dataTx_re;

  wire              [main_0_uartOut_w-1:0]  main_0_uartOut;
  wire              [main_0_statLed_w-1:0]  main_0_statLed;
  wire             [main_0_resetOut_w-1:0]  main_0_resetOut;
  wire                 [main_0_paOn_w-1:0]  main_0_paOn;
  wire                 [main_0_txOn_w-1:0]  main_0_txOn;
  wire                 [main_0_rxOn_w-1:0]  main_0_rxOn;
  wire               [main_0_twbClk_w-1:0]  main_0_twbClk;
  wire               [main_0_twbDat_w-1:0]  main_0_twbDat;
  wire                [main_0_twbEn_w-1:0]  main_0_twbEn;
  wire                  [main_0_gpo_w-1:0]  main_0_gpo;

  wire               [main_0_uartIn_w-1:0]  main_0_uartIn;
  wire              [main_0_ctrlSel_w-1:0]  main_0_ctrlSel;
  wire                  [main_0_gpi_w-1:0]  main_0_gpi;

  wire                                      main_0_regWe;
  wire                                      main_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  main main_0(main_0_ctrlOut, main_0_ctrlOut_or, main_0_ctrlOut_ff, main_0_ctrlOut_we,
              main_0_dacRe, main_0_dacRe_or, main_0_dacRe_ff, main_0_dacRe_we,
              main_0_dacIm, main_0_dacIm_or, main_0_dacIm_ff, main_0_dacIm_we,
              main_0_dataRx, main_0_dataRx_or, main_0_dataRx_ff, main_0_dataRx_we,
              main_0_attn, main_0_attn_or, main_0_attn_ff, main_0_attn_we,
              main_0_ctrlIn, main_0_ctrlIn_ir, main_0_ctrlIn_fe, main_0_ctrlIn_re, 
              main_0_adcRe, main_0_adcRe_ir, main_0_adcRe_fe, main_0_adcRe_re, 
              main_0_adcIm, main_0_adcIm_ir, main_0_adcIm_fe, main_0_adcIm_re, 
              main_0_dataTx, main_0_dataTx_ir, main_0_dataTx_fe, main_0_dataTx_re, 
              main_0_uartOut, 
              main_0_statLed, 
              main_0_resetOut, 
              main_0_paOn, 
              main_0_txOn, 
              main_0_rxOn, 
              main_0_twbClk, 
              main_0_twbDat, 
              main_0_twbEn, 
              main_0_gpo, 
              main_0_uartIn, 
              main_0_ctrlSel, 
              main_0_gpi, 
              regBus, regWe, regRe, main_0_regWe, main_0_regRe, clk, clk2, reset);


//==============================================================================
