//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter lut_rxDcOff_adr_w           = 7;

  // Outputs
  parameter lut_rxDcOff_dat_w           = 24;

  // Input control lines

  // Output control lines

  // Eregs
  parameter lut_rxDcOff_wrAdr_w         = 7;
  parameter lut_rxDcOff_wrAdr_r         = 0;
  parameter lut_rxDcOff_wrAdr_s         = 0;
  parameter lut_rxDcOff_wrDatHi_w       = 16;
  parameter lut_rxDcOff_wrDatHi_r       = 0;
  parameter lut_rxDcOff_wrDatHi_s       = 0;
  parameter lut_rxDcOff_wrDatLo_w       = 16;
  parameter lut_rxDcOff_wrDatLo_r       = 0;
  parameter lut_rxDcOff_wrDatLo_s       = 0;
  parameter lut_rxDcOff_simInit_w       = 1;
  parameter lut_rxDcOff_simInit_r       = 0;
  parameter lut_rxDcOff_simInit_s       = 0;

  // Parameters
  parameter lut_rxDcOff_w               = 24;
  parameter lut_rxDcOff_n               = 70;
  parameter lut_rxDcOff_m               = 7;
  parameter lut_rxDcOff_lutDat          = 0;

  // Iregs

  // Single ported memories
  parameter lut_rxDcOff_lutMem_w        = 24;
  parameter lut_rxDcOff_lutMem_n        = 70;
  parameter lut_rxDcOff_lutMem_m        = `CLOG2(70);

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam lut_rxDcOff.adr_w           = lut_rxDcOff_adr_w;
  defparam lut_rxDcOff.dat_w           = lut_rxDcOff_dat_w;
  defparam lut_rxDcOff.wrAdr_w         = lut_rxDcOff_wrAdr_w;
  defparam lut_rxDcOff.wrAdr_r         = lut_rxDcOff_wrAdr_r;
  defparam lut_rxDcOff.wrAdr_s         = lut_rxDcOff_wrAdr_s;
  defparam lut_rxDcOff.wrDatHi_w       = lut_rxDcOff_wrDatHi_w;
  defparam lut_rxDcOff.wrDatHi_r       = lut_rxDcOff_wrDatHi_r;
  defparam lut_rxDcOff.wrDatHi_s       = lut_rxDcOff_wrDatHi_s;
  defparam lut_rxDcOff.wrDatLo_w       = lut_rxDcOff_wrDatLo_w;
  defparam lut_rxDcOff.wrDatLo_r       = lut_rxDcOff_wrDatLo_r;
  defparam lut_rxDcOff.wrDatLo_s       = lut_rxDcOff_wrDatLo_s;
  defparam lut_rxDcOff.simInit_w       = lut_rxDcOff_simInit_w;
  defparam lut_rxDcOff.simInit_r       = lut_rxDcOff_simInit_r;
  defparam lut_rxDcOff.simInit_s       = lut_rxDcOff_simInit_s;
  defparam lut_rxDcOff.w               = lut_rxDcOff_w;
  defparam lut_rxDcOff.n               = lut_rxDcOff_n;
  defparam lut_rxDcOff.m               = lut_rxDcOff_m;
  defparam lut_rxDcOff.lutDat          = lut_rxDcOff_lutDat;
  defparam lut_rxDcOff.lutMem_w        = lut_rxDcOff_lutMem_w;
  defparam lut_rxDcOff.lutMem_n        = lut_rxDcOff_lutMem_n;
  defparam lut_rxDcOff.lutMem_m        = lut_rxDcOff_lutMem_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_lut_rxDcOff_wrAdr                                          = 0;
  defparam  lut_rxDcOff.R_wrAdr                                          = R_lut_rxDcOff_wrAdr;
  parameter R_lut_rxDcOff_wrDatHi                                        = 1;
  defparam  lut_rxDcOff.R_wrDatHi                                        = R_lut_rxDcOff_wrDatHi;
  parameter R_lut_rxDcOff_wrDatLo                                        = 2;
  defparam  lut_rxDcOff.R_wrDatLo                                        = R_lut_rxDcOff_wrDatLo;
  parameter R_lut_rxDcOff_simInit                                        = 3;
  defparam  lut_rxDcOff.R_simInit                                        = R_lut_rxDcOff_simInit;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire             [lut_rxDcOff_dat_w-1:0]  lut_rxDcOff_dat;
  wire                                      lut_rxDcOff_dat_or;
  wire                                      lut_rxDcOff_dat_ff;
  wire                                      lut_rxDcOff_dat_we;

  wire             [lut_rxDcOff_adr_w-1:0]  lut_rxDcOff_adr;
  wire                                      lut_rxDcOff_adr_ir;
  wire                                      lut_rxDcOff_adr_fe;
  wire                                      lut_rxDcOff_adr_re;

  wire                                      lut_rxDcOff_regWe;
  wire                                      lut_rxDcOff_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  lut lut_rxDcOff(lut_rxDcOff_dat, lut_rxDcOff_dat_or, lut_rxDcOff_dat_ff, lut_rxDcOff_dat_we,
                  lut_rxDcOff_adr, lut_rxDcOff_adr_ir, lut_rxDcOff_adr_fe, lut_rxDcOff_adr_re, 
                  regBus, regWe, regRe, lut_rxDcOff_regWe, lut_rxDcOff_regRe, clk, clk2, reset);


//==============================================================================
