//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter lut_cf11bTx_adr_w           = 5;

  // Outputs
  parameter lut_cf11bTx_dat_w           = 24;

  // Input control lines

  // Output control lines

  // Eregs
  parameter lut_cf11bTx_wrAdr_w         = 5;
  parameter lut_cf11bTx_wrAdr_r         = 0;
  parameter lut_cf11bTx_wrAdr_s         = 0;
  parameter lut_cf11bTx_wrDatHi_w       = 16;
  parameter lut_cf11bTx_wrDatHi_r       = 0;
  parameter lut_cf11bTx_wrDatHi_s       = 0;
  parameter lut_cf11bTx_wrDatLo_w       = 16;
  parameter lut_cf11bTx_wrDatLo_r       = 0;
  parameter lut_cf11bTx_wrDatLo_s       = 0;
  parameter lut_cf11bTx_simInit_w       = 1;
  parameter lut_cf11bTx_simInit_r       = 0;
  parameter lut_cf11bTx_simInit_s       = 0;

  // Parameters
  parameter lut_cf11bTx_w               = 24;
  parameter lut_cf11bTx_n               = 20;
  parameter lut_cf11bTx_m               = 5;
  parameter lut_cf11bTx_lutDat          = 0;

  // Iregs

  // Single ported memories
  parameter lut_cf11bTx_lutMem_w        = 24;
  parameter lut_cf11bTx_lutMem_n        = 20;
  parameter lut_cf11bTx_lutMem_m        = `CLOG2(20);

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam lut_cf11bTx.adr_w           = lut_cf11bTx_adr_w;
  defparam lut_cf11bTx.dat_w           = lut_cf11bTx_dat_w;
  defparam lut_cf11bTx.wrAdr_w         = lut_cf11bTx_wrAdr_w;
  defparam lut_cf11bTx.wrAdr_r         = lut_cf11bTx_wrAdr_r;
  defparam lut_cf11bTx.wrAdr_s         = lut_cf11bTx_wrAdr_s;
  defparam lut_cf11bTx.wrDatHi_w       = lut_cf11bTx_wrDatHi_w;
  defparam lut_cf11bTx.wrDatHi_r       = lut_cf11bTx_wrDatHi_r;
  defparam lut_cf11bTx.wrDatHi_s       = lut_cf11bTx_wrDatHi_s;
  defparam lut_cf11bTx.wrDatLo_w       = lut_cf11bTx_wrDatLo_w;
  defparam lut_cf11bTx.wrDatLo_r       = lut_cf11bTx_wrDatLo_r;
  defparam lut_cf11bTx.wrDatLo_s       = lut_cf11bTx_wrDatLo_s;
  defparam lut_cf11bTx.simInit_w       = lut_cf11bTx_simInit_w;
  defparam lut_cf11bTx.simInit_r       = lut_cf11bTx_simInit_r;
  defparam lut_cf11bTx.simInit_s       = lut_cf11bTx_simInit_s;
  defparam lut_cf11bTx.w               = lut_cf11bTx_w;
  defparam lut_cf11bTx.n               = lut_cf11bTx_n;
  defparam lut_cf11bTx.m               = lut_cf11bTx_m;
  defparam lut_cf11bTx.lutDat          = lut_cf11bTx_lutDat;
  defparam lut_cf11bTx.lutMem_w        = lut_cf11bTx_lutMem_w;
  defparam lut_cf11bTx.lutMem_n        = lut_cf11bTx_lutMem_n;
  defparam lut_cf11bTx.lutMem_m        = lut_cf11bTx_lutMem_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_lut_cf11bTx_wrAdr                                          = 0;
  defparam  lut_cf11bTx.R_wrAdr                                          = R_lut_cf11bTx_wrAdr;
  parameter R_lut_cf11bTx_wrDatHi                                        = 1;
  defparam  lut_cf11bTx.R_wrDatHi                                        = R_lut_cf11bTx_wrDatHi;
  parameter R_lut_cf11bTx_wrDatLo                                        = 2;
  defparam  lut_cf11bTx.R_wrDatLo                                        = R_lut_cf11bTx_wrDatLo;
  parameter R_lut_cf11bTx_simInit                                        = 3;
  defparam  lut_cf11bTx.R_simInit                                        = R_lut_cf11bTx_simInit;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire             [lut_cf11bTx_dat_w-1:0]  lut_cf11bTx_dat;
  wire                                      lut_cf11bTx_dat_or;
  wire                                      lut_cf11bTx_dat_ff;
  wire                                      lut_cf11bTx_dat_we;

  wire             [lut_cf11bTx_adr_w-1:0]  lut_cf11bTx_adr;
  wire                                      lut_cf11bTx_adr_ir;
  wire                                      lut_cf11bTx_adr_fe;
  wire                                      lut_cf11bTx_adr_re;

  wire                                      lut_cf11bTx_regWe;
  wire                                      lut_cf11bTx_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  lut lut_cf11bTx(lut_cf11bTx_dat, lut_cf11bTx_dat_or, lut_cf11bTx_dat_ff, lut_cf11bTx_dat_we,
                  lut_cf11bTx_adr, lut_cf11bTx_adr_ir, lut_cf11bTx_adr_fe, lut_cf11bTx_adr_re, 
                  regBus, regWe, regRe, lut_cf11bTx_regWe, lut_cf11bTx_regRe, clk, clk2, reset);


//==============================================================================
