//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter lsMul_0_x_w             = 20;

  // Outputs
  parameter lsMul_0_y_w             = 20;

  // Input control lines
  parameter lsMul_0_run1_w          = 2;

  // Output control lines

  // Eregs

  // Parameters
  parameter lsMul_0_w               = 10;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam lsMul_0.x_w             = lsMul_0_x_w;
  defparam lsMul_0.y_w             = lsMul_0_y_w;
  defparam lsMul_0.run1_w          = lsMul_0_run1_w;
  defparam lsMul_0.w               = lsMul_0_w;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                   [lsMul_0_y_w-1:0]  lsMul_0_y;
  wire                                      lsMul_0_y_or;
  wire                                      lsMul_0_y_ff;
  wire                                      lsMul_0_y_we;

  wire                   [lsMul_0_x_w-1:0]  lsMul_0_x;
  wire                                      lsMul_0_x_ir;
  wire                                      lsMul_0_x_fe;
  wire                                      lsMul_0_x_re;

  wire                [lsMul_0_run1_w-1:0]  lsMul_0_run1;

  wire                                      lsMul_0_regWe;
  wire                                      lsMul_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  lsMul lsMul_0(lsMul_0_y, lsMul_0_y_or, lsMul_0_y_ff, lsMul_0_y_we,
                lsMul_0_x, lsMul_0_x_ir, lsMul_0_x_fe, lsMul_0_x_re, 
                lsMul_0_run1, 
                regBus, regWe, regRe, lsMul_0_regWe, lsMul_0_regRe, clk, clk2, reset);


//==============================================================================
