//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs

  // Outputs

  // Input control lines
  parameter irqCtrl_wlan_irqIn_w         = 8;

  // Output control lines
  parameter irqCtrl_wlan_irqOut_w        = 1;

  // Eregs
  parameter irqCtrl_wlan_run1_w          = 1;
  parameter irqCtrl_wlan_run1_r          = 0;
  parameter irqCtrl_wlan_run1_s          = 0;
  parameter irqCtrl_wlan_irqStat_w       = 8;
  parameter irqCtrl_wlan_irqStat_r       = 0;
  parameter irqCtrl_wlan_irqStat_s       = 0;
  parameter irqCtrl_wlan_irqEdgeLevel_w  = 8;
  parameter irqCtrl_wlan_irqEdgeLevel_r  = 0;
  parameter irqCtrl_wlan_irqEdgeLevel_s  = 0;
  parameter irqCtrl_wlan_irqMaskIn_w     = 8;
  parameter irqCtrl_wlan_irqMaskIn_r     = 0;
  parameter irqCtrl_wlan_irqMaskIn_s     = 0;
  parameter irqCtrl_wlan_irqMaskOut_w    = 8;
  parameter irqCtrl_wlan_irqMaskOut_r    = 0;
  parameter irqCtrl_wlan_irqMaskOut_s    = 0;
  parameter irqCtrl_wlan_irqClr_w        = 0;
  parameter irqCtrl_wlan_irqClr_r        = 0;
  parameter irqCtrl_wlan_irqClr_s        = 0;
  parameter irqCtrl_wlan_irqSet_w        = 0;
  parameter irqCtrl_wlan_irqSet_r        = 0;
  parameter irqCtrl_wlan_irqSet_s        = 0;
  parameter irqCtrl_wlan_irqIdx_w        = 4;
  parameter irqCtrl_wlan_irqIdx_r        = 0;
  parameter irqCtrl_wlan_irqIdx_s        = 0;

  // Parameters
  parameter irqCtrl_wlan_w               = 8;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam irqCtrl_wlan.irqIn_w         = irqCtrl_wlan_irqIn_w;
  defparam irqCtrl_wlan.irqOut_w        = irqCtrl_wlan_irqOut_w;
  defparam irqCtrl_wlan.run1_w          = irqCtrl_wlan_run1_w;
  defparam irqCtrl_wlan.run1_r          = irqCtrl_wlan_run1_r;
  defparam irqCtrl_wlan.run1_s          = irqCtrl_wlan_run1_s;
  defparam irqCtrl_wlan.irqStat_w       = irqCtrl_wlan_irqStat_w;
  defparam irqCtrl_wlan.irqStat_r       = irqCtrl_wlan_irqStat_r;
  defparam irqCtrl_wlan.irqStat_s       = irqCtrl_wlan_irqStat_s;
  defparam irqCtrl_wlan.irqEdgeLevel_w  = irqCtrl_wlan_irqEdgeLevel_w;
  defparam irqCtrl_wlan.irqEdgeLevel_r  = irqCtrl_wlan_irqEdgeLevel_r;
  defparam irqCtrl_wlan.irqEdgeLevel_s  = irqCtrl_wlan_irqEdgeLevel_s;
  defparam irqCtrl_wlan.irqMaskIn_w     = irqCtrl_wlan_irqMaskIn_w;
  defparam irqCtrl_wlan.irqMaskIn_r     = irqCtrl_wlan_irqMaskIn_r;
  defparam irqCtrl_wlan.irqMaskIn_s     = irqCtrl_wlan_irqMaskIn_s;
  defparam irqCtrl_wlan.irqMaskOut_w    = irqCtrl_wlan_irqMaskOut_w;
  defparam irqCtrl_wlan.irqMaskOut_r    = irqCtrl_wlan_irqMaskOut_r;
  defparam irqCtrl_wlan.irqMaskOut_s    = irqCtrl_wlan_irqMaskOut_s;
  defparam irqCtrl_wlan.irqClr_w        = irqCtrl_wlan_irqClr_w;
  defparam irqCtrl_wlan.irqClr_r        = irqCtrl_wlan_irqClr_r;
  defparam irqCtrl_wlan.irqClr_s        = irqCtrl_wlan_irqClr_s;
  defparam irqCtrl_wlan.irqSet_w        = irqCtrl_wlan_irqSet_w;
  defparam irqCtrl_wlan.irqSet_r        = irqCtrl_wlan_irqSet_r;
  defparam irqCtrl_wlan.irqSet_s        = irqCtrl_wlan_irqSet_s;
  defparam irqCtrl_wlan.irqIdx_w        = irqCtrl_wlan_irqIdx_w;
  defparam irqCtrl_wlan.irqIdx_r        = irqCtrl_wlan_irqIdx_r;
  defparam irqCtrl_wlan.irqIdx_s        = irqCtrl_wlan_irqIdx_s;
  defparam irqCtrl_wlan.w               = irqCtrl_wlan_w;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_irqCtrl_wlan_run1                                          = 0;
  defparam  irqCtrl_wlan.R_run1                                          = R_irqCtrl_wlan_run1;
  parameter R_irqCtrl_wlan_irqStat                                       = 1;
  defparam  irqCtrl_wlan.R_irqStat                                       = R_irqCtrl_wlan_irqStat;
  parameter R_irqCtrl_wlan_irqEdgeLevel                                  = 2;
  defparam  irqCtrl_wlan.R_irqEdgeLevel                                  = R_irqCtrl_wlan_irqEdgeLevel;
  parameter R_irqCtrl_wlan_irqMaskIn                                     = 3;
  defparam  irqCtrl_wlan.R_irqMaskIn                                     = R_irqCtrl_wlan_irqMaskIn;
  parameter R_irqCtrl_wlan_irqMaskOut                                    = 4;
  defparam  irqCtrl_wlan.R_irqMaskOut                                    = R_irqCtrl_wlan_irqMaskOut;
  parameter R_irqCtrl_wlan_irqClr                                        = 5;
  defparam  irqCtrl_wlan.R_irqClr                                        = R_irqCtrl_wlan_irqClr;
  parameter R_irqCtrl_wlan_irqSet                                        = 6;
  defparam  irqCtrl_wlan.R_irqSet                                        = R_irqCtrl_wlan_irqSet;
  parameter R_irqCtrl_wlan_irqIdx                                        = 7;
  defparam  irqCtrl_wlan.R_irqIdx                                        = R_irqCtrl_wlan_irqIdx;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire         [irqCtrl_wlan_irqOut_w-1:0]  irqCtrl_wlan_irqOut;

  wire          [irqCtrl_wlan_irqIn_w-1:0]  irqCtrl_wlan_irqIn;

  wire                                      irqCtrl_wlan_regWe;
  wire                                      irqCtrl_wlan_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  irqCtrl irqCtrl_wlan(irqCtrl_wlan_irqOut, 
                       irqCtrl_wlan_irqIn, 
                       regBus, regWe, regRe, irqCtrl_wlan_regWe, irqCtrl_wlan_regRe, clk, clk2, reset);


//==============================================================================
