//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter fifoIf_0_rx_w            = WlanDataWidth_C;

  // Outputs
  parameter fifoIf_0_tx_w            = WlanDataWidth_C;

  // Input control lines

  // Output control lines
  parameter fifoIf_0_irqRx_w         = 1;
  parameter fifoIf_0_irqTx_w         = 1;

  // Eregs
  parameter fifoIf_0_run1_w          = 1;
  parameter fifoIf_0_run1_r          = 0;
  parameter fifoIf_0_run1_s          = 0;
  parameter fifoIf_0_rxDat_w         = WlanDataWidth_C;
  parameter fifoIf_0_rxDat_r         = 0;
  parameter fifoIf_0_rxDat_s         = 0;
  parameter fifoIf_0_rxSt_w          = 1;
  parameter fifoIf_0_rxSt_r          = 0;
  parameter fifoIf_0_rxSt_s          = 0;
  parameter fifoIf_0_txDat_w         = WlanDataWidth_C;
  parameter fifoIf_0_txDat_r         = 0;
  parameter fifoIf_0_txDat_s         = 0;
  parameter fifoIf_0_txSt_w          = 1;
  parameter fifoIf_0_txSt_r          = 0;
  parameter fifoIf_0_txSt_s          = 0;

  // Parameters
  parameter fifoIf_0_w               = WlanDataWidth_C;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam fifoIf_0.rx_w            = fifoIf_0_rx_w;
  defparam fifoIf_0.tx_w            = fifoIf_0_tx_w;
  defparam fifoIf_0.irqRx_w         = fifoIf_0_irqRx_w;
  defparam fifoIf_0.irqTx_w         = fifoIf_0_irqTx_w;
  defparam fifoIf_0.run1_w          = fifoIf_0_run1_w;
  defparam fifoIf_0.run1_r          = fifoIf_0_run1_r;
  defparam fifoIf_0.run1_s          = fifoIf_0_run1_s;
  defparam fifoIf_0.rxDat_w         = fifoIf_0_rxDat_w;
  defparam fifoIf_0.rxDat_r         = fifoIf_0_rxDat_r;
  defparam fifoIf_0.rxDat_s         = fifoIf_0_rxDat_s;
  defparam fifoIf_0.rxSt_w          = fifoIf_0_rxSt_w;
  defparam fifoIf_0.rxSt_r          = fifoIf_0_rxSt_r;
  defparam fifoIf_0.rxSt_s          = fifoIf_0_rxSt_s;
  defparam fifoIf_0.txDat_w         = fifoIf_0_txDat_w;
  defparam fifoIf_0.txDat_r         = fifoIf_0_txDat_r;
  defparam fifoIf_0.txDat_s         = fifoIf_0_txDat_s;
  defparam fifoIf_0.txSt_w          = fifoIf_0_txSt_w;
  defparam fifoIf_0.txSt_r          = fifoIf_0_txSt_r;
  defparam fifoIf_0.txSt_s          = fifoIf_0_txSt_s;
  defparam fifoIf_0.w               = fifoIf_0_w;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_fifoIf_0_run1                                              = 0;
  defparam  fifoIf_0.R_run1                                              = R_fifoIf_0_run1;
  parameter R_fifoIf_0_rxDat                                             = 1;
  defparam  fifoIf_0.R_rxDat                                             = R_fifoIf_0_rxDat;
  parameter R_fifoIf_0_rxSt                                              = 2;
  defparam  fifoIf_0.R_rxSt                                              = R_fifoIf_0_rxSt;
  parameter R_fifoIf_0_txDat                                             = 3;
  defparam  fifoIf_0.R_txDat                                             = R_fifoIf_0_txDat;
  parameter R_fifoIf_0_txSt                                              = 4;
  defparam  fifoIf_0.R_txSt                                              = R_fifoIf_0_txSt;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                 [fifoIf_0_tx_w-1:0]  fifoIf_0_tx;
  wire                                      fifoIf_0_tx_or;
  wire                                      fifoIf_0_tx_ff;
  wire                                      fifoIf_0_tx_we;

  wire                 [fifoIf_0_rx_w-1:0]  fifoIf_0_rx;
  wire                                      fifoIf_0_rx_ir;
  wire                                      fifoIf_0_rx_fe;
  wire                                      fifoIf_0_rx_re;

  wire              [fifoIf_0_irqRx_w-1:0]  fifoIf_0_irqRx;
  wire              [fifoIf_0_irqTx_w-1:0]  fifoIf_0_irqTx;

  wire                                      fifoIf_0_regWe;
  wire                                      fifoIf_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  fifoIf fifoIf_0(fifoIf_0_tx, fifoIf_0_tx_or, fifoIf_0_tx_ff, fifoIf_0_tx_we,
                  fifoIf_0_rx, fifoIf_0_rx_ir, fifoIf_0_rx_fe, fifoIf_0_rx_re, 
                  fifoIf_0_irqRx, 
                  fifoIf_0_irqTx, 
                  regBus, regWe, regRe, fifoIf_0_regWe, fifoIf_0_regRe, clk, clk2, reset);


//==============================================================================
