//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter fft64_0_x_w             = 20;

  // Outputs
  parameter fft64_0_y_w             = 20;

  // Input control lines

  // Output control lines

  // Eregs
  parameter fft64_0_run1_w          = 2;
  parameter fft64_0_run1_r          = 0;
  parameter fft64_0_run1_s          = 0;
  parameter fft64_0_tglMode_w       = 1;
  parameter fft64_0_tglMode_r       = 0;
  parameter fft64_0_tglMode_s       = 0;
  parameter fft64_0_inpOrd_w        = 1;
  parameter fft64_0_inpOrd_r        = 0;
  parameter fft64_0_inpOrd_s        = 0;
  parameter fft64_0_outpOrd_w       = 1;
  parameter fft64_0_outpOrd_r       = 0;
  parameter fft64_0_outpOrd_s       = 0;

  // Parameters
  parameter fft64_0_w               = 10;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam fft64_0.x_w             = fft64_0_x_w;
  defparam fft64_0.y_w             = fft64_0_y_w;
  defparam fft64_0.run1_w          = fft64_0_run1_w;
  defparam fft64_0.run1_r          = fft64_0_run1_r;
  defparam fft64_0.run1_s          = fft64_0_run1_s;
  defparam fft64_0.tglMode_w       = fft64_0_tglMode_w;
  defparam fft64_0.tglMode_r       = fft64_0_tglMode_r;
  defparam fft64_0.tglMode_s       = fft64_0_tglMode_s;
  defparam fft64_0.inpOrd_w        = fft64_0_inpOrd_w;
  defparam fft64_0.inpOrd_r        = fft64_0_inpOrd_r;
  defparam fft64_0.inpOrd_s        = fft64_0_inpOrd_s;
  defparam fft64_0.outpOrd_w       = fft64_0_outpOrd_w;
  defparam fft64_0.outpOrd_r       = fft64_0_outpOrd_r;
  defparam fft64_0.outpOrd_s       = fft64_0_outpOrd_s;
  defparam fft64_0.w               = fft64_0_w;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_fft64_0_run1                                               = 0;
  defparam  fft64_0.R_run1                                               = R_fft64_0_run1;
  parameter R_fft64_0_tglMode                                            = 1;
  defparam  fft64_0.R_tglMode                                            = R_fft64_0_tglMode;
  parameter R_fft64_0_inpOrd                                             = 2;
  defparam  fft64_0.R_inpOrd                                             = R_fft64_0_inpOrd;
  parameter R_fft64_0_outpOrd                                            = 3;
  defparam  fft64_0.R_outpOrd                                            = R_fft64_0_outpOrd;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                   [fft64_0_y_w-1:0]  fft64_0_y;
  wire                                      fft64_0_y_or;
  wire                                      fft64_0_y_ff;
  wire                                      fft64_0_y_we;

  wire                   [fft64_0_x_w-1:0]  fft64_0_x;
  wire                                      fft64_0_x_ir;
  wire                                      fft64_0_x_fe;
  wire                                      fft64_0_x_re;

  wire                                      fft64_0_regWe;
  wire                                      fft64_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  fft64 fft64_0(fft64_0_y, fft64_0_y_or, fft64_0_y_ff, fft64_0_y_we,
                fft64_0_x, fft64_0_x_ir, fft64_0_x_fe, fft64_0_x_re, 
                regBus, regWe, regRe, fft64_0_regWe, fft64_0_regRe, clk, clk2, reset);


//==============================================================================
