//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter extIf_0_rx_w            = 16;

  // Outputs
  parameter extIf_0_tx_w            = 16;

  // Input control lines

  // Output control lines
  parameter extIf_0_resetOut_w      = 1;
  parameter extIf_0_irqRx_w         = 1;
  parameter extIf_0_irqTx_w         = 1;

  // Eregs
  parameter extIf_0_rxDat_w         = 16;
  parameter extIf_0_rxDat_r         = 0;
  parameter extIf_0_rxDat_s         = 0;
  parameter extIf_0_rxSt_w          = 1;
  parameter extIf_0_rxSt_r          = 0;
  parameter extIf_0_rxSt_s          = 0;
  parameter extIf_0_txDat_w         = 16;
  parameter extIf_0_txDat_r         = 0;
  parameter extIf_0_txDat_s         = 0;
  parameter extIf_0_txSt_w          = 1;
  parameter extIf_0_txSt_r          = 0;
  parameter extIf_0_txSt_s          = 0;
  parameter extIf_0_ctrlOn_w        = 1;
  parameter extIf_0_ctrlOn_r        = 1;
  parameter extIf_0_ctrlOn_s        = 0;

  // Parameters

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam extIf_0.rx_w            = extIf_0_rx_w;
  defparam extIf_0.tx_w            = extIf_0_tx_w;
  defparam extIf_0.resetOut_w      = extIf_0_resetOut_w;
  defparam extIf_0.irqRx_w         = extIf_0_irqRx_w;
  defparam extIf_0.irqTx_w         = extIf_0_irqTx_w;
  defparam extIf_0.rxDat_w         = extIf_0_rxDat_w;
  defparam extIf_0.rxDat_r         = extIf_0_rxDat_r;
  defparam extIf_0.rxDat_s         = extIf_0_rxDat_s;
  defparam extIf_0.rxSt_w          = extIf_0_rxSt_w;
  defparam extIf_0.rxSt_r          = extIf_0_rxSt_r;
  defparam extIf_0.rxSt_s          = extIf_0_rxSt_s;
  defparam extIf_0.txDat_w         = extIf_0_txDat_w;
  defparam extIf_0.txDat_r         = extIf_0_txDat_r;
  defparam extIf_0.txDat_s         = extIf_0_txDat_s;
  defparam extIf_0.txSt_w          = extIf_0_txSt_w;
  defparam extIf_0.txSt_r          = extIf_0_txSt_r;
  defparam extIf_0.txSt_s          = extIf_0_txSt_s;
  defparam extIf_0.ctrlOn_w        = extIf_0_ctrlOn_w;
  defparam extIf_0.ctrlOn_r        = extIf_0_ctrlOn_r;
  defparam extIf_0.ctrlOn_s        = extIf_0_ctrlOn_s;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_extIf_0_rxDat                                              = 0;
  defparam  extIf_0.R_rxDat                                              = R_extIf_0_rxDat;
  parameter R_extIf_0_rxSt                                               = 1;
  defparam  extIf_0.R_rxSt                                               = R_extIf_0_rxSt;
  parameter R_extIf_0_txDat                                              = 2;
  defparam  extIf_0.R_txDat                                              = R_extIf_0_txDat;
  parameter R_extIf_0_txSt                                               = 3;
  defparam  extIf_0.R_txSt                                               = R_extIf_0_txSt;
  parameter R_extIf_0_ctrlOn                                             = 4;
  defparam  extIf_0.R_ctrlOn                                             = R_extIf_0_ctrlOn;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                  [extIf_0_tx_w-1:0]  extIf_0_tx;
  wire                                      extIf_0_tx_or;
  wire                                      extIf_0_tx_ff;
  wire                                      extIf_0_tx_we;

  wire                  [extIf_0_rx_w-1:0]  extIf_0_rx;
  wire                                      extIf_0_rx_ir;
  wire                                      extIf_0_rx_fe;
  wire                                      extIf_0_rx_re;

  wire            [extIf_0_resetOut_w-1:0]  extIf_0_resetOut;
  wire               [extIf_0_irqRx_w-1:0]  extIf_0_irqRx;
  wire               [extIf_0_irqTx_w-1:0]  extIf_0_irqTx;

  wire                                      extIf_0_regWe;
  wire                                      extIf_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  extIf extIf_0(extIf_0_tx, extIf_0_tx_or, extIf_0_tx_ff, extIf_0_tx_we,
                extIf_0_rx, extIf_0_rx_ir, extIf_0_rx_fe, extIf_0_rx_re, 
                extIf_0_resetOut, 
                extIf_0_irqRx, 
                extIf_0_irqTx, 
                regBus, regWe, regRe, extIf_0_regWe, extIf_0_regRe, clk, clk2, reset);


//==============================================================================
