//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter dec11a_0_x_w             = 22;

  // Outputs
  parameter dec11a_0_y_w             = 8;
  parameter dec11a_0_ySb_w           = 8;
  parameter dec11a_0_ySb2_w          = 8;
  parameter dec11a_0_yVit_w          = 8;

  // Input control lines

  // Output control lines
  parameter dec11a_0_irqVitDone_w    = 2;

  // Eregs
  parameter dec11a_0_run1_w          = 2;
  parameter dec11a_0_run1_r          = 0;
  parameter dec11a_0_run1_s          = 0;

  // Parameters
  parameter dec11a_0_wx              = 22;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos
  parameter dec11a_0_ffD2D_w         = 8;
  parameter dec11a_0_ffD2D_n         = 16;
  parameter dec11a_0_ffD2D_m         = 5;

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam dec11a_0.x_w             = dec11a_0_x_w;
  defparam dec11a_0.y_w             = dec11a_0_y_w;
  defparam dec11a_0.ySb_w           = dec11a_0_ySb_w;
  defparam dec11a_0.ySb2_w          = dec11a_0_ySb2_w;
  defparam dec11a_0.yVit_w          = dec11a_0_yVit_w;
  defparam dec11a_0.irqVitDone_w    = dec11a_0_irqVitDone_w;
  defparam dec11a_0.run1_w          = dec11a_0_run1_w;
  defparam dec11a_0.run1_r          = dec11a_0_run1_r;
  defparam dec11a_0.run1_s          = dec11a_0_run1_s;
  defparam dec11a_0.wx              = dec11a_0_wx;
  defparam dec11a_0.ffD2D_w         = dec11a_0_ffD2D_w;
  defparam dec11a_0.ffD2D_m         = dec11a_0_ffD2D_m;
  defparam dec11a_0.ffD2D_n         = dec11a_0_ffD2D_n;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_dec11a_0_run1                                              = 0;
  defparam  dec11a_0.R_run1                                              = R_dec11a_0_run1;
  parameter R_dec11a_0_deIntlv_0_mode1                                   = 1;
  defparam  dec11a_0.R_deIntlv_0_mode1                                   = R_dec11a_0_deIntlv_0_mode1;
  parameter R_dec11a_0_dePunct_0_run1                                    = 2;
  defparam  dec11a_0.R_dePunct_0_run1                                    = R_dec11a_0_dePunct_0_run1;
  parameter R_dec11a_0_vitMain_0_run1                                    = 3;
  defparam  dec11a_0.R_vitMain_0_run1                                    = R_dec11a_0_vitMain_0_run1;
  parameter R_dec11a_0_vitMain_0_numBits                                 = 4;
  defparam  dec11a_0.R_vitMain_0_numBits                                 = R_dec11a_0_vitMain_0_numBits;
  parameter R_dec11a_0_vitMain_0_rxMode                                  = 5;
  defparam  dec11a_0.R_vitMain_0_rxMode                                  = R_dec11a_0_vitMain_0_rxMode;
  parameter R_dec11a_0_vitMain_0_rxLen                                   = 6;
  defparam  dec11a_0.R_vitMain_0_rxLen                                   = R_dec11a_0_vitMain_0_rxLen;
  parameter R_dec11a_0_vitMain_0_pm00                                    = 7;
  defparam  dec11a_0.R_vitMain_0_pm00                                    = R_dec11a_0_vitMain_0_pm00;
  parameter R_dec11a_0_crc32x8_0_numBytes                                = 8;
  defparam  dec11a_0.R_crc32x8_0_numBytes                                = R_dec11a_0_crc32x8_0_numBytes;
  parameter R_dec11a_0_crc32x8_0_crcRes                                  = 9;
  defparam  dec11a_0.R_crc32x8_0_crcRes                                  = R_dec11a_0_crc32x8_0_crcRes;

  // FIFO address definitions - might be overwritten by an upper module
  parameter R_dec11a_0_ffD2D                                             = 10;
  defparam  dec11a_0.R_ffD2D                                             = R_dec11a_0_ffD2D;

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                  [dec11a_0_y_w-1:0]  dec11a_0_y;
  wire                                      dec11a_0_y_or;
  wire                                      dec11a_0_y_ff;
  wire                                      dec11a_0_y_we;

  wire                [dec11a_0_ySb_w-1:0]  dec11a_0_ySb;
  wire                                      dec11a_0_ySb_or;
  wire                                      dec11a_0_ySb_ff;
  wire                                      dec11a_0_ySb_we;

  wire               [dec11a_0_ySb2_w-1:0]  dec11a_0_ySb2;
  wire                                      dec11a_0_ySb2_or;
  wire                                      dec11a_0_ySb2_ff;
  wire                                      dec11a_0_ySb2_we;

  wire               [dec11a_0_yVit_w-1:0]  dec11a_0_yVit;
  wire                                      dec11a_0_yVit_or;
  wire                                      dec11a_0_yVit_ff;
  wire                                      dec11a_0_yVit_we;

  wire                  [dec11a_0_x_w-1:0]  dec11a_0_x;
  wire                                      dec11a_0_x_ir;
  wire                                      dec11a_0_x_fe;
  wire                                      dec11a_0_x_re;

  wire         [dec11a_0_irqVitDone_w-1:0]  dec11a_0_irqVitDone;

  wire                                      dec11a_0_regWe;
  wire                                      dec11a_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  dec11a dec11a_0(dec11a_0_y, dec11a_0_y_or, dec11a_0_y_ff, dec11a_0_y_we,
                  dec11a_0_ySb, dec11a_0_ySb_or, dec11a_0_ySb_ff, dec11a_0_ySb_we,
                  dec11a_0_ySb2, dec11a_0_ySb2_or, dec11a_0_ySb2_ff, dec11a_0_ySb2_we,
                  dec11a_0_yVit, dec11a_0_yVit_or, dec11a_0_yVit_ff, dec11a_0_yVit_we,
                  dec11a_0_x, dec11a_0_x_ir, dec11a_0_x_fe, dec11a_0_x_re, 
                  dec11a_0_irqVitDone, 
                  regBus, regWe, regRe, dec11a_0_regWe, dec11a_0_regRe, clk, clk2, reset);


//==============================================================================
