//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter deIntlv_0_x_w             = 22;

  // Outputs
  parameter deIntlv_0_y_w             = 8;

  // Input control lines
  parameter deIntlv_0_run1_w          = 2;

  // Output control lines

  // Eregs
  parameter deIntlv_0_mode1_w         = 2;
  parameter deIntlv_0_mode1_r         = 0;
  parameter deIntlv_0_mode1_s         = 0;

  // Parameters
  parameter deIntlv_0_wy              = 4;
  parameter deIntlv_0_wb              = 6;

  // Iregs
  parameter deIntlv_0_cntBlock_w      = 2;
  parameter deIntlv_0_cntBlock_n      = 1;
  parameter deIntlv_0_cntBlock_m      = `CLOG2(1);

  // Single ported memories

  // Dual ported memories
  parameter deIntlv_0_m0_w            = 22;
  parameter deIntlv_0_m0_n            = 16;
  parameter deIntlv_0_m0_m            = `CLOG2(16);
  parameter deIntlv_0_m1_w            = 22;
  parameter deIntlv_0_m1_n            = 16;
  parameter deIntlv_0_m1_m            = `CLOG2(16);

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam deIntlv_0.x_w             = deIntlv_0_x_w;
  defparam deIntlv_0.y_w             = deIntlv_0_y_w;
  defparam deIntlv_0.run1_w          = deIntlv_0_run1_w;
  defparam deIntlv_0.mode1_w         = deIntlv_0_mode1_w;
  defparam deIntlv_0.mode1_r         = deIntlv_0_mode1_r;
  defparam deIntlv_0.mode1_s         = deIntlv_0_mode1_s;
  defparam deIntlv_0.wy              = deIntlv_0_wy;
  defparam deIntlv_0.wb              = deIntlv_0_wb;
  defparam deIntlv_0.cntBlock_w      = deIntlv_0_cntBlock_w;
  defparam deIntlv_0.cntBlock_n      = deIntlv_0_cntBlock_n;
  defparam deIntlv_0.cntBlock_m      = deIntlv_0_cntBlock_m;
  defparam deIntlv_0.m0_w            = deIntlv_0_m0_w;
  defparam deIntlv_0.m0_n            = deIntlv_0_m0_n;
  defparam deIntlv_0.m0_m            = deIntlv_0_m0_m;
  defparam deIntlv_0.m1_w            = deIntlv_0_m1_w;
  defparam deIntlv_0.m1_n            = deIntlv_0_m1_n;
  defparam deIntlv_0.m1_m            = deIntlv_0_m1_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_deIntlv_0_mode1                                            = 0;
  defparam  deIntlv_0.R_mode1                                            = R_deIntlv_0_mode1;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                 [deIntlv_0_y_w-1:0]  deIntlv_0_y;
  wire                                      deIntlv_0_y_or;
  wire                                      deIntlv_0_y_ff;
  wire                                      deIntlv_0_y_we;

  wire                 [deIntlv_0_x_w-1:0]  deIntlv_0_x;
  wire                                      deIntlv_0_x_ir;
  wire                                      deIntlv_0_x_fe;
  wire                                      deIntlv_0_x_re;

  wire              [deIntlv_0_run1_w-1:0]  deIntlv_0_run1;

  wire                                      deIntlv_0_regWe;
  wire                                      deIntlv_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  deIntlv deIntlv_0(deIntlv_0_y, deIntlv_0_y_or, deIntlv_0_y_ff, deIntlv_0_y_we,
                    deIntlv_0_x, deIntlv_0_x_ir, deIntlv_0_x_fe, deIntlv_0_x_re, 
                    deIntlv_0_run1, 
                    regBus, regWe, regRe, deIntlv_0_regWe, deIntlv_0_regRe, clk, clk2, reset);


//==============================================================================
